/*
 * Decompiled with CFR 0.152.
 */
package software.hoegg.mule.tasks;

import java.io.File;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.Component;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import software.hoegg.mule.TransformZipUnArchiver;

public class BundleDirectoryTask {
    @Component
    protected TransformZipUnArchiver unArchiver;
    private String path;
    private String includePattern;

    public void bundle(Set<Artifact> appArtifacts, File outputDirectory) {
        File dir = new File(outputDirectory, this.path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.unArchiver.setDestDirectory(outputDirectory);
        this.unArchiver.setTransformer(TransformZipUnArchiver.NO_TRANSFORMER);
        this.unArchiver.setFileSelectors(new FileSelector[]{this.selector()});
        for (Artifact appArtifact : appArtifacts) {
            this.unArchiver.setSourceFile(appArtifact.getFile());
            this.unArchiver.extract();
        }
    }

    private IncludeExcludeFileSelector selector() {
        IncludeExcludeFileSelector s = new IncludeExcludeFileSelector();
        s.setIncludes(new String[]{this.includePattern});
        return s;
    }
}

