/*
 * Decompiled with CFR 0.152.
 */
package software.hoegg.mule.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.Component;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import software.hoegg.mule.TransformZipUnArchiver;

public class BundleConfigFilesTask {
    @Component
    protected TransformZipUnArchiver unArchiver;

    public List<String> bundleConfigFiles(Set<Artifact> appArtifacts, File outputDirectory, String excludes) {
        this.unArchiver.setDestDirectory(outputDirectory);
        this.unArchiver.setFileSelectors(new FileSelector[]{this.muleConfigSelector(excludes)});
        PrefixMuleConfigTransformer transformer = new PrefixMuleConfigTransformer();
        this.unArchiver.setTransformer(transformer);
        for (Artifact appArtifact : appArtifacts) {
            this.unArchiver.setSourceFile(appArtifact.getFile());
            transformer.setPrefix(appArtifact.getArtifactId() + ".");
            this.unArchiver.extract();
        }
        return transformer.getIncludedFiles();
    }

    private IncludeExcludeFileSelector muleConfigSelector(String excludes) {
        IncludeExcludeFileSelector s = new IncludeExcludeFileSelector();
        s.setIncludes(new String[]{"*.xml"});
        if (StringUtils.isNotEmpty((CharSequence)excludes)) {
            s.setExcludes(excludes.split(","));
        }
        return s;
    }

    public class PrefixMuleConfigTransformer
    implements TransformZipUnArchiver.Transformer {
        private String prefix;
        private List<String> includedFiles = new ArrayList<String>();

        @Override
        public File transformDestinationDirectory(TransformZipUnArchiver.EntryContext context) {
            return context.getDestinationDirectory();
        }

        @Override
        public String transformEntryName(TransformZipUnArchiver.EntryContext context) {
            String name = this.getPrefix() + context.getEntryName();
            this.includedFiles.add(name);
            return name;
        }

        @Override
        public Date transformEntryDate(TransformZipUnArchiver.EntryContext context) {
            return context.getEntryDate();
        }

        public List<String> getIncludedFiles() {
            return Collections.unmodifiableList(this.includedFiles);
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }
}

