/*
 * Decompiled with CFR 0.152.
 */
package software.hoegg.mule;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;

public class TransformZipUnArchiver
extends ZipUnArchiver {
    private Transformer transformer = NO_TRANSFORMER;
    public static Transformer NO_TRANSFORMER = new Transformer(){

        @Override
        public File transformDestinationDirectory(EntryContext context) {
            return context.getDestinationDirectory();
        }

        @Override
        public String transformEntryName(EntryContext context) {
            return context.getEntryName();
        }

        @Override
        public Date transformEntryDate(EntryContext context) {
            return context.getEntryDate();
        }
    };

    protected void extractFile(File sourceFile, File destDirectory, InputStream compressedInputStream, String entryName, Date entryDate, boolean isDirectory, Integer mode, String symlinkDestination) throws IOException, ArchiverException {
        EntryContext context = new EntryContext(sourceFile, destDirectory, entryName, entryDate, isDirectory, mode);
        super.extractFile(sourceFile, this.transformer.transformDestinationDirectory(context), compressedInputStream, this.transformer.transformEntryName(context), this.transformer.transformEntryDate(context), isDirectory, mode, symlinkDestination);
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public static class EntryContext {
        private final File sourceFile;
        private final File destinationDirectory;
        private final String entryName;
        private final Date entryDate;
        private final boolean isDirectory;
        private final Integer mode;

        public EntryContext(File sourceFile, File destDirectory, String entryName, Date entryDate, boolean isDirectory, Integer mode) {
            this.sourceFile = sourceFile;
            this.destinationDirectory = destDirectory;
            this.entryName = entryName;
            this.entryDate = entryDate;
            this.isDirectory = isDirectory;
            this.mode = mode;
        }

        public File getSourceFile() {
            return this.sourceFile;
        }

        public File getDestinationDirectory() {
            return this.destinationDirectory;
        }

        public String getEntryName() {
            return this.entryName;
        }

        public Date getEntryDate() {
            return this.entryDate;
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public Integer getMode() {
            return this.mode;
        }
    }

    public static interface Transformer {
        public File transformDestinationDirectory(EntryContext var1);

        public String transformEntryName(EntryContext var1);

        public Date transformEntryDate(EntryContext var1);
    }
}

