/*
 * Decompiled with CFR 0.152.
 */
package software.hoegg.mule;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.mule.tools.maven.plugin.app.Exclusion;
import org.mule.tools.maven.plugin.app.Inclusion;
import software.hoegg.mule.TransformZipUnArchiver;
import software.hoegg.mule.tasks.BundleConfigFilesTask;
import software.hoegg.mule.tasks.BundleDirectoryTask;
import software.hoegg.mule.tasks.BundleLibsTask;

@Mojo(name="bundle", requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true)
public class PrepareBundleMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Component
    protected TransformZipUnArchiver unArchiver;
    @Component
    protected BundleConfigFilesTask bundleConfigFilesTask;
    @Component
    protected BundleLibsTask bundleLibsTask;
    @Component(hint="classes")
    protected BundleDirectoryTask bundleClassesTask;
    @Component(hint="api")
    protected BundleDirectoryTask bundleApisTask;
    @Parameter(defaultValue="${project.build.directory}/mule-bundle", required=true)
    protected File outputDirectory;
    @Parameter
    protected List<Inclusion> inclusions;
    @Parameter
    protected List<Exclusion> exclusions;
    @Parameter(defaultValue="**/*unbundled.xml")
    protected String configExcludes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("Should bundle " + StringUtils.join(this.getZipDependencies(), (String)",")));
        this.outputDirectory.mkdirs();
        List<String> includedFiles = this.bundleConfigFilesTask.bundleConfigFiles(this.getZipDependencies(), this.outputDirectory, this.configExcludes);
        this.getLog().info((CharSequence)("Bundled mule configuration files: " + StringUtils.join(includedFiles, (String)",")));
        this.bundleLibsTask.bundleLibDependencies(this.project, this.inclusions, this.exclusions, this.outputDirectory);
        this.bundleClassesTask.bundle(this.getZipDependencies(), this.outputDirectory);
        this.bundleApisTask.bundle(this.getZipDependencies(), this.outputDirectory);
        List<String> bundleFiles = this.bundleResources();
        bundleFiles.addAll(includedFiles);
        this.writeMuleDeployProperties(bundleFiles);
    }

    private List<String> bundleResources() throws MojoFailureException {
        try {
            File bundleSourceDirectory = this.bundleSourceDir();
            FileUtils.copyDirectory((File)bundleSourceDirectory, (File)this.outputDirectory);
            return bundleSourceDirectory.exists() ? FileUtils.getFileNames((File)bundleSourceDirectory, (String)"**/*.xml", (String)"", (boolean)false) : new ArrayList<String>();
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to copy bundle resources from src/main/bundle", (Throwable)e);
        }
    }

    private File bundleSourceDir() {
        return new File(this.project.getBasedir(), "src/main/bundle");
    }

    private void writeMuleDeployProperties(List<String> includedFiles) throws MojoFailureException {
        Properties deployProperties = new Properties();
        deployProperties.setProperty("config.resources", StringUtils.join(includedFiles, (String)","));
        File muleDeployPropertiesFile = new File(this.outputDirectory, "mule-deploy.properties");
        try {
            muleDeployPropertiesFile.createNewFile();
            FileOutputStream out = new FileOutputStream(muleDeployPropertiesFile);
            deployProperties.store(out, "");
            out.flush();
            IOUtils.closeQuietly((OutputStream)out);
        }
        catch (IOException e) {
            throw new MojoFailureException("Could not create bundle mule-deploy.properties", (Throwable)e);
        }
    }

    private Set<Artifact> getZipDependencies() {
        return (Set)CollectionUtils.select((Iterable)this.project.getArtifacts(), (Predicate)new Predicate<Artifact>(){

            public boolean evaluate(Artifact a) {
                return "zip".equals(a.getType());
            }
        }, new HashSet());
    }
}

