/*
 * Decompiled with CFR 0.152.
 */
package software.hoegg.mule;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.util.FileUtils;
import org.mule.tools.maven.plugin.app.ArtifactFilter;
import org.mule.tools.maven.plugin.app.Exclusion;
import org.mule.tools.maven.plugin.app.Inclusion;
import software.hoegg.mule.TransformZipUnArchiver;

@Mojo(name="bundle", requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true)
public class PrepareBundleMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Component
    protected TransformZipUnArchiver unArchiver;
    @Parameter(defaultValue="${project.build.directory}/mule-bundle", required=true)
    protected File outputDirectory;
    @Parameter
    protected List<Inclusion> inclusions;
    @Parameter
    protected List<Exclusion> exclusions;
    @Parameter(defaultValue="**/*unbundled.xml")
    protected String configExcludes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("Should bundle " + StringUtils.join(this.getZipDependencies(), (String)",")));
        this.outputDirectory.mkdirs();
        List<String> includedFiles = this.bundleConfigFiles();
        this.getLog().info((CharSequence)("Bundled mule configuration files: " + StringUtils.join(includedFiles, (String)",")));
        this.writeMuleDeployProperties(includedFiles);
        this.bundleLibDependencies();
        this.bundleResources();
    }

    private void bundleResources() throws MojoFailureException {
        try {
            FileUtils.copyDirectory((File)this.bundleSourceDir(), (File)this.outputDirectory);
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to copy bundle resources from src/main/bundle", (Throwable)e);
        }
    }

    private File bundleSourceDir() {
        return new File(this.project.getBasedir(), "src/main/bundle");
    }

    private void bundleLibDependencies() throws MojoFailureException {
        File libDir = new File(this.outputDirectory, "lib");
        if (!libDir.exists()) {
            libDir.mkdirs();
        }
        for (Artifact a : this.getLibDependencies()) {
            try {
                FileUtils.copyFileToDirectory((File)a.getFile(), (File)libDir);
            }
            catch (IOException e) {
                throw new MojoFailureException("Unable to copy dependency to bundle lib", (Throwable)e);
            }
        }
    }

    private List<String> bundleConfigFiles() {
        this.unArchiver.setDestDirectory(this.outputDirectory);
        this.unArchiver.setFileSelectors(new FileSelector[]{this.muleConfigSelector()});
        PrefixMuleConfigTransformer transformer = new PrefixMuleConfigTransformer();
        this.unArchiver.setTransformer(transformer);
        for (Artifact appArtifact : this.getZipDependencies()) {
            this.unArchiver.setSourceFile(appArtifact.getFile());
            transformer.setPrefix(appArtifact.getArtifactId() + ".");
            this.unArchiver.extract();
        }
        return transformer.getIncludedFiles();
    }

    private void writeMuleDeployProperties(List<String> includedFiles) throws MojoFailureException {
        Properties deployProperties = new Properties();
        deployProperties.setProperty("config.resources", StringUtils.join(includedFiles, (String)","));
        File muleDeployPropertiesFile = new File(this.outputDirectory, "mule-deploy.properties");
        try {
            muleDeployPropertiesFile.createNewFile();
            FileOutputStream out = new FileOutputStream(muleDeployPropertiesFile);
            deployProperties.store(out, "");
            out.flush();
            IOUtils.closeQuietly((OutputStream)out);
        }
        catch (IOException e) {
            throw new MojoFailureException("Could not create bundle mule-deploy.properties", (Throwable)e);
        }
    }

    private IncludeExcludeFileSelector muleConfigSelector() {
        IncludeExcludeFileSelector s = new IncludeExcludeFileSelector();
        s.setIncludes(new String[]{"*.xml"});
        if (StringUtils.isNotEmpty((CharSequence)this.configExcludes)) {
            s.setExcludes(this.configExcludes.split(","));
        }
        return s;
    }

    private Set<Artifact> getZipDependencies() {
        return (Set)CollectionUtils.select((Iterable)this.project.getArtifacts(), (Predicate)new Predicate<Artifact>(){

            public boolean evaluate(Artifact a) {
                return "zip".equals(a.getType());
            }
        }, new HashSet());
    }

    private Set<Artifact> getLibDependencies() {
        ArtifactFilter filter = new ArtifactFilter(this.project, this.inclusions, this.exclusions, true);
        return this.keepOnlyJarArtifacts(filter.getArtifactsToArchive());
    }

    private Set<Artifact> keepOnlyJarArtifacts(Set<Artifact> artifactsToArchive) {
        return (Set)CollectionUtils.select(artifactsToArchive, (Predicate)new Predicate<Artifact>(){

            public boolean evaluate(Artifact a) {
                return "jar".equals(a.getType());
            }
        }, new HashSet());
    }

    public class PrefixMuleConfigTransformer
    implements TransformZipUnArchiver.Transformer {
        private String prefix;
        private List<String> includedFiles = new ArrayList<String>();

        @Override
        public File transformDestinationDirectory(TransformZipUnArchiver.EntryContext context) {
            return context.getDestinationDirectory();
        }

        @Override
        public String transformEntryName(TransformZipUnArchiver.EntryContext context) {
            String name = this.getPrefix() + context.getEntryName();
            this.includedFiles.add(name);
            return name;
        }

        @Override
        public Date transformEntryDate(TransformZipUnArchiver.EntryContext context) {
            return context.getEntryDate();
        }

        public List<String> getIncludedFiles() {
            return Collections.unmodifiableList(this.includedFiles);
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }
}

