package software.crldev.elrondspringbootstarterreactive.domain.transaction;

import software.crldev.elrondspringbootstarterreactive.error.exception.InvalidTransactionVersionException;
import static software.crldev.elrondspringbootstarterreactive.config.TransactionConstants.TRANSACTION_VERSION_DEFAULT;
import static software.crldev.elrondspringbootstarterreactive.config.TransactionConstants.TRANSACTION_VERSION_TX_HASH_SIGN;

/**
 * Value object for TransactionVersion
 *
 * @author carlo_stanciu
 */
public final class TransactionVersion {
    private final Integer value;

    private TransactionVersion(Integer value) {
        if (Integer.signum(value) == -1) {
            throw new InvalidTransactionVersionException(value);
        }
        this.value = value;
    }

    /**
     * Creates an TransactionVersion object from
     * a number value
     *
     * @param value - value in Integer format
     * @return an instance of TransactionVersion
     */
    public static TransactionVersion fromInteger(Integer value) {
        return new TransactionVersion(value);
    }

    /**
     * Create an TransactionVersion object with default version
     *
     * @return an instance of TransactionVersion
     */
    public static TransactionVersion withDefaultVersion() {
        return new TransactionVersion(TRANSACTION_VERSION_DEFAULT);
    }

    /**
     * Create an TransactionVersion object with transaction hash sign version
     *
     * @return an instance of TransactionVersion
     */
    public static TransactionVersion withTransactionHashSignVersion() {
        return new TransactionVersion(TRANSACTION_VERSION_TX_HASH_SIGN);
    }

    @Override
    public String toString() {
        return value.toString();
    }

    public Integer getValue() {
        return this.value;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof TransactionVersion)) return false;
        final TransactionVersion other = (TransactionVersion) o;
        final Object this$value = this.getValue();
        final Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $value = this.getValue();
        result = result * PRIME + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}
