package software.crldev.elrondspringbootstarterreactive.domain.smartcontract;

import software.crldev.elrondspringbootstarterreactive.domain.transaction.Transaction;
import software.crldev.elrondspringbootstarterreactive.error.exception.FunctionNameException;
import static io.netty.util.internal.StringUtil.isNullOrEmpty;

/**
 * Value object for smart contract function name
 *
 * @author carlo_stanciu
 */
public final class FunctionName {
    private final String value;

    private FunctionName(String name) {
        this.value = name;
    }

    /**
     * Creates a FunctionArgs object with empty array of args
     *
     * @return - an instance of FunctionName
     */
    public static FunctionName fromString(String name) {
        if (isNullOrEmpty(name)) throw new FunctionNameException();
        return new FunctionName(name.trim());
    }

    /**
     * Returns the value
     *
     * @return - value in String format
     */
    @Override
    public String toString() {
        return value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof FunctionName)) return false;
        final FunctionName other = (FunctionName) o;
        final Object this$value = this.getValue();
        final Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $value = this.getValue();
        result = result * PRIME + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}
