package software.crldev.elrondspringbootstarterreactive.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * API response when simulating transaction execution
 *
 * @author carlo_stanciu
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = SimulationResults.SimulationResultsBuilder.class)
public final class SimulationResults {
    @JsonProperty("receiverShard")
    private final ShardFromSimulatedTransaction receiverShard;
    @JsonProperty("senderShard")
    private final ShardFromSimulatedTransaction senderShard;
    @JsonProperty("scResults")
    private final List<SmartContractResult> smartContractResults;
    @JsonProperty("receipts")
    private final List<Receipt> receipts;

    SimulationResults(final ShardFromSimulatedTransaction receiverShard, final ShardFromSimulatedTransaction senderShard, final List<SmartContractResult> smartContractResults, final List<Receipt> receipts) {
        this.receiverShard = receiverShard;
        this.senderShard = senderShard;
        this.smartContractResults = smartContractResults;
        this.receipts = receipts;
    }


    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    public static class SimulationResultsBuilder {
        private ShardFromSimulatedTransaction receiverShard;
        private ShardFromSimulatedTransaction senderShard;
        private List<SmartContractResult> smartContractResults;
        private List<Receipt> receipts;

        SimulationResultsBuilder() {
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("receiverShard")
        public SimulationResults.SimulationResultsBuilder receiverShard(final ShardFromSimulatedTransaction receiverShard) {
            this.receiverShard = receiverShard;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("senderShard")
        public SimulationResults.SimulationResultsBuilder senderShard(final ShardFromSimulatedTransaction senderShard) {
            this.senderShard = senderShard;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("scResults")
        public SimulationResults.SimulationResultsBuilder smartContractResults(final List<SmartContractResult> smartContractResults) {
            this.smartContractResults = smartContractResults;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("receipts")
        public SimulationResults.SimulationResultsBuilder receipts(final List<Receipt> receipts) {
            this.receipts = receipts;
            return this;
        }

        public SimulationResults build() {
            return new SimulationResults(this.receiverShard, this.senderShard, this.smartContractResults, this.receipts);
        }

        @Override
        public String toString() {
            return "SimulationResults.SimulationResultsBuilder(receiverShard=" + this.receiverShard + ", senderShard=" + this.senderShard + ", smartContractResults=" + this.smartContractResults + ", receipts=" + this.receipts + ")";
        }
    }

    public static SimulationResults.SimulationResultsBuilder builder() {
        return new SimulationResults.SimulationResultsBuilder();
    }

    public ShardFromSimulatedTransaction getReceiverShard() {
        return this.receiverShard;
    }

    public ShardFromSimulatedTransaction getSenderShard() {
        return this.senderShard;
    }

    public List<SmartContractResult> getSmartContractResults() {
        return this.smartContractResults;
    }

    public List<Receipt> getReceipts() {
        return this.receipts;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof SimulationResults)) return false;
        final SimulationResults other = (SimulationResults) o;
        final Object this$receiverShard = this.getReceiverShard();
        final Object other$receiverShard = other.getReceiverShard();
        if (this$receiverShard == null ? other$receiverShard != null : !this$receiverShard.equals(other$receiverShard)) return false;
        final Object this$senderShard = this.getSenderShard();
        final Object other$senderShard = other.getSenderShard();
        if (this$senderShard == null ? other$senderShard != null : !this$senderShard.equals(other$senderShard)) return false;
        final Object this$smartContractResults = this.getSmartContractResults();
        final Object other$smartContractResults = other.getSmartContractResults();
        if (this$smartContractResults == null ? other$smartContractResults != null : !this$smartContractResults.equals(other$smartContractResults)) return false;
        final Object this$receipts = this.getReceipts();
        final Object other$receipts = other.getReceipts();
        if (this$receipts == null ? other$receipts != null : !this$receipts.equals(other$receipts)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $receiverShard = this.getReceiverShard();
        result = result * PRIME + ($receiverShard == null ? 43 : $receiverShard.hashCode());
        final Object $senderShard = this.getSenderShard();
        result = result * PRIME + ($senderShard == null ? 43 : $senderShard.hashCode());
        final Object $smartContractResults = this.getSmartContractResults();
        result = result * PRIME + ($smartContractResults == null ? 43 : $smartContractResults.hashCode());
        final Object $receipts = this.getReceipts();
        result = result * PRIME + ($receipts == null ? 43 : $receipts.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SimulationResults(receiverShard=" + this.getReceiverShard() + ", senderShard=" + this.getSenderShard() + ", smartContractResults=" + this.getSmartContractResults() + ", receipts=" + this.getReceipts() + ")";
    }
}
