package software.crldev.elrondspringbootstarterreactive.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * API response when querying smart contract for string value
 *
 * @author carlo_stanciu
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = ScQueryResultString.ScQueryResultStringBuilder.class)
public final class ScQueryResultString {
    @JsonProperty("data")
    private final String value;

    ScQueryResultString(final String value) {
        this.value = value;
    }


    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    public static class ScQueryResultStringBuilder {
        private String value;

        ScQueryResultStringBuilder() {
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("data")
        public ScQueryResultString.ScQueryResultStringBuilder value(final String value) {
            this.value = value;
            return this;
        }

        public ScQueryResultString build() {
            return new ScQueryResultString(this.value);
        }

        @Override
        public String toString() {
            return "ScQueryResultString.ScQueryResultStringBuilder(value=" + this.value + ")";
        }
    }

    public static ScQueryResultString.ScQueryResultStringBuilder builder() {
        return new ScQueryResultString.ScQueryResultStringBuilder();
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof ScQueryResultString)) return false;
        final ScQueryResultString other = (ScQueryResultString) o;
        final Object this$value = this.getValue();
        final Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $value = this.getValue();
        result = result * PRIME + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ScQueryResultString(value=" + this.getValue() + ")";
    }
}
