package software.crldev.elrondspringbootstarterreactive.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;

/**
 * API response when querying smart contract for integer value
 *
 * @author carlo_stanciu
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = ScQueryResultInt.ScQueryResultIntBuilder.class)
public final class ScQueryResultInt {
    @JsonProperty("data")
    private final BigInteger value;

    ScQueryResultInt(final BigInteger value) {
        this.value = value;
    }


    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    public static class ScQueryResultIntBuilder {
        private BigInteger value;

        ScQueryResultIntBuilder() {
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("data")
        public ScQueryResultInt.ScQueryResultIntBuilder value(final BigInteger value) {
            this.value = value;
            return this;
        }

        public ScQueryResultInt build() {
            return new ScQueryResultInt(this.value);
        }

        @Override
        public String toString() {
            return "ScQueryResultInt.ScQueryResultIntBuilder(value=" + this.value + ")";
        }
    }

    public static ScQueryResultInt.ScQueryResultIntBuilder builder() {
        return new ScQueryResultInt.ScQueryResultIntBuilder();
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof ScQueryResultInt)) return false;
        final ScQueryResultInt other = (ScQueryResultInt) o;
        final Object this$value = this.getValue();
        final Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $value = this.getValue();
        result = result * PRIME + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ScQueryResultInt(value=" + this.getValue() + ")";
    }
}
