package software.crldev.elrondspringbootstarterreactive.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * API response when querying smart contract for hex value
 *
 * @author carlo_stanciu
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = ScQueryResultHex.ScQueryResultHexBuilder.class)
public final class ScQueryResultHex {
    @JsonProperty("data")
    private final String value;

    ScQueryResultHex(final String value) {
        this.value = value;
    }


    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    public static class ScQueryResultHexBuilder {
        private String value;

        ScQueryResultHexBuilder() {
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("data")
        public ScQueryResultHex.ScQueryResultHexBuilder value(final String value) {
            this.value = value;
            return this;
        }

        public ScQueryResultHex build() {
            return new ScQueryResultHex(this.value);
        }

        @Override
        public String toString() {
            return "ScQueryResultHex.ScQueryResultHexBuilder(value=" + this.value + ")";
        }
    }

    public static ScQueryResultHex.ScQueryResultHexBuilder builder() {
        return new ScQueryResultHex.ScQueryResultHexBuilder();
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof ScQueryResultHex)) return false;
        final ScQueryResultHex other = (ScQueryResultHex) o;
        final Object this$value = this.getValue();
        final Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $value = this.getValue();
        result = result * PRIME + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ScQueryResultHex(value=" + this.getValue() + ")";
    }
}
