package software.crldev.elrondspringbootstarterreactive.domain.transaction;

import org.bouncycastle.util.encoders.Hex;

/**
 * Value object for transaction Hash
 *
 * @author carlo_stanciu
 */
public final class Hash {
    private final byte[] value;

    private Hash(byte[] value) {
        this.value = value;
    }

    /**
     * Creates an Hash object from
     * a String value
     *
     * @param hash - value in String format
     * @return - an instance of Hash
     */
    public static Hash fromString(String hash) {
        return new Hash(Hex.decode(hash));
    }

    /**
     * Creates an Hash object from
     * a buffer
     *
     * @param buffer - value in buffer format
     * @return - an instance of Hash
     */
    public static Hash fromBuffer(byte[] buffer) {
        return new Hash(buffer);
    }

    /**
     * Creates an empty Hash
     *
     * @return - an instance of Hash
     */
    public static Hash empty() {
        return new Hash(new byte[] {});
    }

    /**
     * Checks if Hash is empty
     *
     * @return - boolean
     */
    public boolean isEmpty() {
        return value.length == 0;
    }

    /**
     * Getter
     *
     * @return -
     */
    public byte[] getValue() {
        return value;
    }

    @Override
    public String toString() {
        return Hex.toHexString(value);
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof Hash)) return false;
        final Hash other = (Hash) o;
        if (!java.util.Arrays.equals(this.getValue(), other.getValue())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + java.util.Arrays.hashCode(this.getValue());
        return result;
    }
}
