package software.crldev.elrondspringbootstarterreactive.domain.transaction;

import software.crldev.elrondspringbootstarterreactive.error.exception.NegativeGasException;
import software.crldev.elrondspringbootstarterreactive.config.CurrencyConstants;
import java.math.BigInteger;

/**
 * Value object for GasLimit
 *
 * @author carlo_stanciu
 */
public final class GasLimit {
    private final BigInteger value;

    private GasLimit(BigInteger value) {
        if (value.signum() == -1) throw new NegativeGasException(value);
        this.value = value;
    }

    /**
     * Creates an GasLimit object from
     * a number value
     *
     * @param value - value in BigInteger format
     * @return an instance of GasLimit
     */
    public static GasLimit fromNumber(BigInteger value) {
        return new GasLimit(value);
    }

    /**
     * Creates an GasLimit object from
     * a String value
     *
     * @param value - value in String format
     * @return an instance of GasLimit
     */
    public static GasLimit fromString(String value) {
        return fromNumber(new BigInteger(value));
    }

    @Override
    public String toString() {
        return value.toString(CurrencyConstants.BASE10);
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof GasLimit)) return false;
        final GasLimit other = (GasLimit) o;
        final Object this$value = this.getValue();
        final Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $value = this.getValue();
        result = result * PRIME + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}
