package software.crldev.elrondspringbootstarterreactive.domain.smartcontract;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AccessLevel;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import static java.util.Objects.nonNull;

public final class ScQuery {
    @NonNull
    private final Address smartContractAddress;
    @NonNull
    private final FunctionName functionName;
    @NonNull
    private final FunctionArgs args;
    private final Address callerAddress;
    private final Balance value;

    public Sendable toSendable() {
        return Sendable.builder().smartContractAddress(smartContractAddress.getBech32()).functionName(functionName.getValue()).args(args.getValue().toArray(new String[] {})).callerAddress(nonNull(callerAddress) ? callerAddress.getBech32() : null).value(nonNull(value) ? value.toString() : null).build();
    }


    public static final class Sendable {
        @JsonProperty("scAddress")
        private final String smartContractAddress;
        @JsonProperty("funcName")
        private final String functionName;
        @JsonProperty("args")
        private final String[] args;
        @JsonProperty("caller")
        private final String callerAddress;
        @JsonProperty("value")
        private final String value;

        Sendable(final String smartContractAddress, final String functionName, final String[] args, final String callerAddress, final String value) {
            this.smartContractAddress = smartContractAddress;
            this.functionName = functionName;
            this.args = args;
            this.callerAddress = callerAddress;
            this.value = value;
        }


        private static class SendableBuilder {
            private String smartContractAddress;
            private String functionName;
            private String[] args;
            private String callerAddress;
            private String value;

            SendableBuilder() {
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("scAddress")
            private ScQuery.Sendable.SendableBuilder smartContractAddress(final String smartContractAddress) {
                this.smartContractAddress = smartContractAddress;
                return this;
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("funcName")
            private ScQuery.Sendable.SendableBuilder functionName(final String functionName) {
                this.functionName = functionName;
                return this;
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("args")
            private ScQuery.Sendable.SendableBuilder args(final String[] args) {
                this.args = args;
                return this;
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("caller")
            private ScQuery.Sendable.SendableBuilder callerAddress(final String callerAddress) {
                this.callerAddress = callerAddress;
                return this;
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("value")
            private ScQuery.Sendable.SendableBuilder value(final String value) {
                this.value = value;
                return this;
            }

            private ScQuery.Sendable build() {
                return new ScQuery.Sendable(this.smartContractAddress, this.functionName, this.args, this.callerAddress, this.value);
            }

            @Override
            public String toString() {
                return "ScQuery.Sendable.SendableBuilder(smartContractAddress=" + this.smartContractAddress + ", functionName=" + this.functionName + ", args=" + java.util.Arrays.deepToString(this.args) + ", callerAddress=" + this.callerAddress + ", value=" + this.value + ")";
            }
        }

        private static ScQuery.Sendable.SendableBuilder builder() {
            return new ScQuery.Sendable.SendableBuilder();
        }

        public String getSmartContractAddress() {
            return this.smartContractAddress;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public String[] getArgs() {
            return this.args;
        }

        public String getCallerAddress() {
            return this.callerAddress;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public boolean equals(final Object o) {
            if (o == this) return true;
            if (!(o instanceof ScQuery.Sendable)) return false;
            final ScQuery.Sendable other = (ScQuery.Sendable) o;
            final Object this$smartContractAddress = this.getSmartContractAddress();
            final Object other$smartContractAddress = other.getSmartContractAddress();
            if (this$smartContractAddress == null ? other$smartContractAddress != null : !this$smartContractAddress.equals(other$smartContractAddress)) return false;
            final Object this$functionName = this.getFunctionName();
            final Object other$functionName = other.getFunctionName();
            if (this$functionName == null ? other$functionName != null : !this$functionName.equals(other$functionName)) return false;
            if (!java.util.Arrays.deepEquals(this.getArgs(), other.getArgs())) return false;
            final Object this$callerAddress = this.getCallerAddress();
            final Object other$callerAddress = other.getCallerAddress();
            if (this$callerAddress == null ? other$callerAddress != null : !this$callerAddress.equals(other$callerAddress)) return false;
            final Object this$value = this.getValue();
            final Object other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final Object $smartContractAddress = this.getSmartContractAddress();
            result = result * PRIME + ($smartContractAddress == null ? 43 : $smartContractAddress.hashCode());
            final Object $functionName = this.getFunctionName();
            result = result * PRIME + ($functionName == null ? 43 : $functionName.hashCode());
            result = result * PRIME + java.util.Arrays.deepHashCode(this.getArgs());
            final Object $callerAddress = this.getCallerAddress();
            result = result * PRIME + ($callerAddress == null ? 43 : $callerAddress.hashCode());
            final Object $value = this.getValue();
            result = result * PRIME + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "ScQuery.Sendable(smartContractAddress=" + this.getSmartContractAddress() + ", functionName=" + this.getFunctionName() + ", args=" + java.util.Arrays.deepToString(this.getArgs()) + ", callerAddress=" + this.getCallerAddress() + ", value=" + this.getValue() + ")";
        }
    }

    ScQuery(@NonNull final Address smartContractAddress, @NonNull final FunctionName functionName, @NonNull final FunctionArgs args, final Address callerAddress, final Balance value) {
        if (smartContractAddress == null) {
            throw new NullPointerException("smartContractAddress is marked non-null but is null");
        }
        if (functionName == null) {
            throw new NullPointerException("functionName is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        this.smartContractAddress = smartContractAddress;
        this.functionName = functionName;
        this.args = args;
        this.callerAddress = callerAddress;
        this.value = value;
    }


    public static class ScQueryBuilder {
        private Address smartContractAddress;
        private FunctionName functionName;
        private FunctionArgs args;
        private Address callerAddress;
        private Balance value;

        ScQueryBuilder() {
        }

        /**
         * @return {@code this}.
         */
        public ScQuery.ScQueryBuilder smartContractAddress(@NonNull final Address smartContractAddress) {
            if (smartContractAddress == null) {
                throw new NullPointerException("smartContractAddress is marked non-null but is null");
            }
            this.smartContractAddress = smartContractAddress;
            return this;
        }

        /**
         * @return {@code this}.
         */
        public ScQuery.ScQueryBuilder functionName(@NonNull final FunctionName functionName) {
            if (functionName == null) {
                throw new NullPointerException("functionName is marked non-null but is null");
            }
            this.functionName = functionName;
            return this;
        }

        /**
         * @return {@code this}.
         */
        public ScQuery.ScQueryBuilder args(@NonNull final FunctionArgs args) {
            if (args == null) {
                throw new NullPointerException("args is marked non-null but is null");
            }
            this.args = args;
            return this;
        }

        /**
         * @return {@code this}.
         */
        public ScQuery.ScQueryBuilder callerAddress(final Address callerAddress) {
            this.callerAddress = callerAddress;
            return this;
        }

        /**
         * @return {@code this}.
         */
        public ScQuery.ScQueryBuilder value(final Balance value) {
            this.value = value;
            return this;
        }

        public ScQuery build() {
            return new ScQuery(this.smartContractAddress, this.functionName, this.args, this.callerAddress, this.value);
        }

        @Override
        public String toString() {
            return "ScQuery.ScQueryBuilder(smartContractAddress=" + this.smartContractAddress + ", functionName=" + this.functionName + ", args=" + this.args + ", callerAddress=" + this.callerAddress + ", value=" + this.value + ")";
        }
    }

    public static ScQuery.ScQueryBuilder builder() {
        return new ScQuery.ScQueryBuilder();
    }

    @NonNull
    public Address getSmartContractAddress() {
        return this.smartContractAddress;
    }

    @NonNull
    public FunctionName getFunctionName() {
        return this.functionName;
    }

    @NonNull
    public FunctionArgs getArgs() {
        return this.args;
    }

    public Address getCallerAddress() {
        return this.callerAddress;
    }

    public Balance getValue() {
        return this.value;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof ScQuery)) return false;
        final ScQuery other = (ScQuery) o;
        final Object this$smartContractAddress = this.getSmartContractAddress();
        final Object other$smartContractAddress = other.getSmartContractAddress();
        if (this$smartContractAddress == null ? other$smartContractAddress != null : !this$smartContractAddress.equals(other$smartContractAddress)) return false;
        final Object this$functionName = this.getFunctionName();
        final Object other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !this$functionName.equals(other$functionName)) return false;
        final Object this$args = this.getArgs();
        final Object other$args = other.getArgs();
        if (this$args == null ? other$args != null : !this$args.equals(other$args)) return false;
        final Object this$callerAddress = this.getCallerAddress();
        final Object other$callerAddress = other.getCallerAddress();
        if (this$callerAddress == null ? other$callerAddress != null : !this$callerAddress.equals(other$callerAddress)) return false;
        final Object this$value = this.getValue();
        final Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $smartContractAddress = this.getSmartContractAddress();
        result = result * PRIME + ($smartContractAddress == null ? 43 : $smartContractAddress.hashCode());
        final Object $functionName = this.getFunctionName();
        result = result * PRIME + ($functionName == null ? 43 : $functionName.hashCode());
        final Object $args = this.getArgs();
        result = result * PRIME + ($args == null ? 43 : $args.hashCode());
        final Object $callerAddress = this.getCallerAddress();
        result = result * PRIME + ($callerAddress == null ? 43 : $callerAddress.hashCode());
        final Object $value = this.getValue();
        result = result * PRIME + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ScQuery(smartContractAddress=" + this.getSmartContractAddress() + ", functionName=" + this.getFunctionName() + ", args=" + this.getArgs() + ", callerAddress=" + this.getCallerAddress() + ", value=" + this.getValue() + ")";
    }
}
