package software.crldev.elrondspringbootstarterreactive.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * part of API response used in smart contract query results
 *
 * @author carlo_stanciu
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = ScQueryResult.ScQueryResultBuilder.class)
public final class ScQueryResult {
    @JsonProperty("returnData")
    private final List<String> data;
    @JsonProperty("returnCode")
    private final String code;
    @JsonProperty("returnMessage")
    private final String message;

    ScQueryResult(final List<String> data, final String code, final String message) {
        this.data = data;
        this.code = code;
        this.message = message;
    }


    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    public static class ScQueryResultBuilder {
        private List<String> data;
        private String code;
        private String message;

        ScQueryResultBuilder() {
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("returnData")
        public ScQueryResult.ScQueryResultBuilder data(final List<String> data) {
            this.data = data;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("returnCode")
        public ScQueryResult.ScQueryResultBuilder code(final String code) {
            this.code = code;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("returnMessage")
        public ScQueryResult.ScQueryResultBuilder message(final String message) {
            this.message = message;
            return this;
        }

        public ScQueryResult build() {
            return new ScQueryResult(this.data, this.code, this.message);
        }

        @Override
        public String toString() {
            return "ScQueryResult.ScQueryResultBuilder(data=" + this.data + ", code=" + this.code + ", message=" + this.message + ")";
        }
    }

    public static ScQueryResult.ScQueryResultBuilder builder() {
        return new ScQueryResult.ScQueryResultBuilder();
    }

    public List<String> getData() {
        return this.data;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof ScQueryResult)) return false;
        final ScQueryResult other = (ScQueryResult) o;
        final Object this$data = this.getData();
        final Object other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) return false;
        final Object this$code = this.getCode();
        final Object other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
        final Object this$message = this.getMessage();
        final Object other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $data = this.getData();
        result = result * PRIME + ($data == null ? 43 : $data.hashCode());
        final Object $code = this.getCode();
        result = result * PRIME + ($code == null ? 43 : $code.hashCode());
        final Object $message = this.getMessage();
        result = result * PRIME + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ScQueryResult(data=" + this.getData() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ")";
    }
}
