package software.crldev.elrondspringbootstarterreactive.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;

/**
 * part of API response used in transactions and simulation results
 *
 * @author carlo_stanciu
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = Receipt.ReceiptBuilder.class)
public final class Receipt {
    @JsonProperty("hash")
    private final String hash;
    @JsonProperty("nonce")
    private final Long nonce;
    @JsonProperty("value")
    private final BigInteger value;
    @JsonProperty("receiver")
    private final String receiver;
    @JsonProperty("sender")
    private final String sender;

    Receipt(final String hash, final Long nonce, final BigInteger value, final String receiver, final String sender) {
        this.hash = hash;
        this.nonce = nonce;
        this.value = value;
        this.receiver = receiver;
        this.sender = sender;
    }


    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    public static class ReceiptBuilder {
        private String hash;
        private Long nonce;
        private BigInteger value;
        private String receiver;
        private String sender;

        ReceiptBuilder() {
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("hash")
        public Receipt.ReceiptBuilder hash(final String hash) {
            this.hash = hash;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("nonce")
        public Receipt.ReceiptBuilder nonce(final Long nonce) {
            this.nonce = nonce;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("value")
        public Receipt.ReceiptBuilder value(final BigInteger value) {
            this.value = value;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("receiver")
        public Receipt.ReceiptBuilder receiver(final String receiver) {
            this.receiver = receiver;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("sender")
        public Receipt.ReceiptBuilder sender(final String sender) {
            this.sender = sender;
            return this;
        }

        public Receipt build() {
            return new Receipt(this.hash, this.nonce, this.value, this.receiver, this.sender);
        }

        @Override
        public String toString() {
            return "Receipt.ReceiptBuilder(hash=" + this.hash + ", nonce=" + this.nonce + ", value=" + this.value + ", receiver=" + this.receiver + ", sender=" + this.sender + ")";
        }
    }

    public static Receipt.ReceiptBuilder builder() {
        return new Receipt.ReceiptBuilder();
    }

    public String getHash() {
        return this.hash;
    }

    public Long getNonce() {
        return this.nonce;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public String getSender() {
        return this.sender;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof Receipt)) return false;
        final Receipt other = (Receipt) o;
        final Object this$nonce = this.getNonce();
        final Object other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce)) return false;
        final Object this$hash = this.getHash();
        final Object other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) return false;
        final Object this$value = this.getValue();
        final Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
        final Object this$receiver = this.getReceiver();
        final Object other$receiver = other.getReceiver();
        if (this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver)) return false;
        final Object this$sender = this.getSender();
        final Object other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $nonce = this.getNonce();
        result = result * PRIME + ($nonce == null ? 43 : $nonce.hashCode());
        final Object $hash = this.getHash();
        result = result * PRIME + ($hash == null ? 43 : $hash.hashCode());
        final Object $value = this.getValue();
        result = result * PRIME + ($value == null ? 43 : $value.hashCode());
        final Object $receiver = this.getReceiver();
        result = result * PRIME + ($receiver == null ? 43 : $receiver.hashCode());
        final Object $sender = this.getSender();
        result = result * PRIME + ($sender == null ? 43 : $sender.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Receipt(hash=" + this.getHash() + ", nonce=" + this.getNonce() + ", value=" + this.getValue() + ", receiver=" + this.getReceiver() + ", sender=" + this.getSender() + ")";
    }
}
