package software.crldev.elrondspringbootstarterreactive.properties;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Configuration class for spring properties mapping
 *
 * @author carlo_stanciu
 */
@ConfigurationProperties(prefix = "spring.elrond.client")
public class ErdClientProperties {
    private String gateway = "https://devnet-gateway.elrond.com";
    private long readTimeoutMillis = 10000L;
    private long writeTimeoutMillis = 10000L;

    public ErdClientProperties() {
    }

    public String getGateway() {
        return this.gateway;
    }

    public long getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public long getWriteTimeoutMillis() {
        return this.writeTimeoutMillis;
    }

    public void setGateway(final String gateway) {
        this.gateway = gateway;
    }

    public void setReadTimeoutMillis(final long readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public void setWriteTimeoutMillis(final long writeTimeoutMillis) {
        this.writeTimeoutMillis = writeTimeoutMillis;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof ErdClientProperties)) return false;
        final ErdClientProperties other = (ErdClientProperties) o;
        if (!other.canEqual((Object) this)) return false;
        if (this.getReadTimeoutMillis() != other.getReadTimeoutMillis()) return false;
        if (this.getWriteTimeoutMillis() != other.getWriteTimeoutMillis()) return false;
        final Object this$gateway = this.getGateway();
        final Object other$gateway = other.getGateway();
        if (this$gateway == null ? other$gateway != null : !this$gateway.equals(other$gateway)) return false;
        return true;
    }

    protected boolean canEqual(final Object other) {
        return other instanceof ErdClientProperties;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final long $readTimeoutMillis = this.getReadTimeoutMillis();
        result = result * PRIME + (int) ($readTimeoutMillis >>> 32 ^ $readTimeoutMillis);
        final long $writeTimeoutMillis = this.getWriteTimeoutMillis();
        result = result * PRIME + (int) ($writeTimeoutMillis >>> 32 ^ $writeTimeoutMillis);
        final Object $gateway = this.getGateway();
        result = result * PRIME + ($gateway == null ? 43 : $gateway.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ErdClientProperties(gateway=" + this.getGateway() + ", readTimeoutMillis=" + this.getReadTimeoutMillis() + ", writeTimeoutMillis=" + this.getWriteTimeoutMillis() + ")";
    }
}
