package software.crldev.elrondspringbootstarterreactive.domain.common;

import software.crldev.elrondspringbootstarterreactive.error.exception.InvalidNonceException;

/**
 * Value object for Nonce
 *
 * @author carlo_stanciu
 */
public final class Nonce {
    private final Long value;

    private Nonce(Long value) {
        if (value < 0) {
            throw new InvalidNonceException(value);
        }
        this.value = value;
    }

    /**
     * Creates Nonce from Long
     *
     * @param value - Long value for nonce
     * @return - an instance of Nonce
     */
    public static Nonce fromLong(Long value) {
        return new Nonce(value);
    }

    /**
     * Creates a Nonce object with value 0
     *
     * @return - an instance of Nonce
     */
    public static Nonce zero() {
        return new Nonce(0L);
    }

    @Override
    public String toString() {
        return value.toString();
    }

    public Long getValue() {
        return this.value;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof Nonce)) return false;
        final Nonce other = (Nonce) o;
        final Object this$value = this.getValue();
        final Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $value = this.getValue();
        result = result * PRIME + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}
