package software.crldev.elrondspringbootstarterreactive.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * API response when sending a transaction for execution
 *
 * @author carlo_stanciu
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = TransactionHash.TransactionHashBuilder.class)
public final class TransactionHash {
    @JsonProperty("txHash")
    private final String hash;

    TransactionHash(final String hash) {
        this.hash = hash;
    }


    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    public static class TransactionHashBuilder {
        private String hash;

        TransactionHashBuilder() {
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("txHash")
        public TransactionHash.TransactionHashBuilder hash(final String hash) {
            this.hash = hash;
            return this;
        }

        public TransactionHash build() {
            return new TransactionHash(this.hash);
        }

        @Override
        public String toString() {
            return "TransactionHash.TransactionHashBuilder(hash=" + this.hash + ")";
        }
    }

    public static TransactionHash.TransactionHashBuilder builder() {
        return new TransactionHash.TransactionHashBuilder();
    }

    public String getHash() {
        return this.hash;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof TransactionHash)) return false;
        final TransactionHash other = (TransactionHash) o;
        final Object this$hash = this.getHash();
        final Object other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $hash = this.getHash();
        result = result * PRIME + ($hash == null ? 43 : $hash.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "TransactionHash(hash=" + this.getHash() + ")";
    }
}
