package software.crldev.elrondspringbootstarterreactive.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * API response when estimating transaction execution
 *
 * @author carlo_stanciu
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = TransactionCostEstimation.TransactionCostEstimationBuilder.class)
public final class TransactionCostEstimation {
    @JsonProperty("txGasUnits")
    private final String transactionGasUnits;
    @JsonProperty("returnMessage")
    private final String returnMessage;

    TransactionCostEstimation(final String transactionGasUnits, final String returnMessage) {
        this.transactionGasUnits = transactionGasUnits;
        this.returnMessage = returnMessage;
    }


    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    public static class TransactionCostEstimationBuilder {
        private String transactionGasUnits;
        private String returnMessage;

        TransactionCostEstimationBuilder() {
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("txGasUnits")
        public TransactionCostEstimation.TransactionCostEstimationBuilder transactionGasUnits(final String transactionGasUnits) {
            this.transactionGasUnits = transactionGasUnits;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("returnMessage")
        public TransactionCostEstimation.TransactionCostEstimationBuilder returnMessage(final String returnMessage) {
            this.returnMessage = returnMessage;
            return this;
        }

        public TransactionCostEstimation build() {
            return new TransactionCostEstimation(this.transactionGasUnits, this.returnMessage);
        }

        @Override
        public String toString() {
            return "TransactionCostEstimation.TransactionCostEstimationBuilder(transactionGasUnits=" + this.transactionGasUnits + ", returnMessage=" + this.returnMessage + ")";
        }
    }

    public static TransactionCostEstimation.TransactionCostEstimationBuilder builder() {
        return new TransactionCostEstimation.TransactionCostEstimationBuilder();
    }

    public String getTransactionGasUnits() {
        return this.transactionGasUnits;
    }

    public String getReturnMessage() {
        return this.returnMessage;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof TransactionCostEstimation)) return false;
        final TransactionCostEstimation other = (TransactionCostEstimation) o;
        final Object this$transactionGasUnits = this.getTransactionGasUnits();
        final Object other$transactionGasUnits = other.getTransactionGasUnits();
        if (this$transactionGasUnits == null ? other$transactionGasUnits != null : !this$transactionGasUnits.equals(other$transactionGasUnits)) return false;
        final Object this$returnMessage = this.getReturnMessage();
        final Object other$returnMessage = other.getReturnMessage();
        if (this$returnMessage == null ? other$returnMessage != null : !this$returnMessage.equals(other$returnMessage)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $transactionGasUnits = this.getTransactionGasUnits();
        result = result * PRIME + ($transactionGasUnits == null ? 43 : $transactionGasUnits.hashCode());
        final Object $returnMessage = this.getReturnMessage();
        result = result * PRIME + ($returnMessage == null ? 43 : $returnMessage.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "TransactionCostEstimation(transactionGasUnits=" + this.getTransactionGasUnits() + ", returnMessage=" + this.getReturnMessage() + ")";
    }
}
