package software.crldev.elrondspringbootstarterreactive.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * API response when querying for address nonce
 *
 * @author carlo_stanciu
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = AddressNonce.AddressNonceBuilder.class)
public final class AddressNonce {
    @JsonProperty("nonce")
    private final Long nonce;

    AddressNonce(final Long nonce) {
        this.nonce = nonce;
    }


    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    public static class AddressNonceBuilder {
        private Long nonce;

        AddressNonceBuilder() {
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("nonce")
        public AddressNonce.AddressNonceBuilder nonce(final Long nonce) {
            this.nonce = nonce;
            return this;
        }

        public AddressNonce build() {
            return new AddressNonce(this.nonce);
        }

        @Override
        public String toString() {
            return "AddressNonce.AddressNonceBuilder(nonce=" + this.nonce + ")";
        }
    }

    public static AddressNonce.AddressNonceBuilder builder() {
        return new AddressNonce.AddressNonceBuilder();
    }

    public Long getNonce() {
        return this.nonce;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof AddressNonce)) return false;
        final AddressNonce other = (AddressNonce) o;
        final Object this$nonce = this.getNonce();
        final Object other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $nonce = this.getNonce();
        result = result * PRIME + ($nonce == null ? 43 : $nonce.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AddressNonce(nonce=" + this.getNonce() + ")";
    }
}
