/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.wallet;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import lombok.Generated;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.util.encoders.Hex;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.Signable;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.Signature;
import software.crldev.elrondspringbootstarterreactive.error.exception.CannotCreateSignatureException;
import software.crldev.elrondspringbootstarterreactive.error.exception.CannotSignTransactionException;
import software.crldev.elrondspringbootstarterreactive.error.exception.PrivateKeyHexSizeException;

public final class Wallet {
    private final byte[] publicKey;
    private final byte[] privateKey;

    private Wallet(byte[] publicKey, byte[] privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public static Wallet fromPrivateKeyBuffer(byte[] privateKey) {
        Ed25519PrivateKeyParameters privateKeyParameters = new Ed25519PrivateKeyParameters(privateKey, 0);
        Ed25519PublicKeyParameters publicKeyParameters = privateKeyParameters.generatePublicKey();
        return new Wallet(publicKeyParameters.getEncoded(), privateKey);
    }

    public static Wallet fromPrivateKeyHex(String privateKeyHex) {
        if (privateKeyHex.length() == 64) {
            return Wallet.fromPrivateKeyBuffer(Hex.decode((String)privateKeyHex));
        }
        throw new PrivateKeyHexSizeException(privateKeyHex.length());
    }

    public void sign(Signable signable) {
        try {
            byte[] data = signable.serializeForSigning();
            Ed25519Signer signer = this.createEd25519Signer();
            signer.update(data, 0, data.length);
            signable.applySignature(Signature.fromBuffer(signer.generateSignature()));
        }
        catch (JsonProcessingException | CannotCreateSignatureException e) {
            throw new CannotSignTransactionException(e);
        }
    }

    public String getPublicKeyHex() {
        return Hex.toHexString((byte[])this.publicKey);
    }

    private Ed25519Signer createEd25519Signer() {
        Ed25519PrivateKeyParameters parameters = new Ed25519PrivateKeyParameters(this.privateKey, 0);
        Ed25519Signer signer = new Ed25519Signer();
        signer.init(true, (CipherParameters)parameters);
        return signer;
    }

    @Generated
    public byte[] getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Wallet)) {
            return false;
        }
        Wallet other = (Wallet)o;
        if (!Arrays.equals(this.getPublicKey(), other.getPublicKey())) {
            return false;
        }
        return Arrays.equals(this.getPrivateKey(), other.getPrivateKey());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getPublicKey());
        result = result * 59 + Arrays.hashCode(this.getPrivateKey());
        return result;
    }

    @Generated
    public String toString() {
        return "Wallet(publicKey=" + Arrays.toString(this.getPublicKey()) + ", privateKey=" + Arrays.toString(this.getPrivateKey()) + ")";
    }
}

