/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.config;

import io.netty.channel.ChannelHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;
import software.crldev.elrondspringbootstarterreactive.properties.ErdClientProperties;

public class ErdClientConfig {
    private final String gatewayUrl;
    private final WebClient.Builder erdClientBuilder;

    public ErdClientConfig(ErdClientProperties clientProperties) {
        this.gatewayUrl = clientProperties.getGateway();
        HttpClient httpClient = (HttpClient)HttpClient.create().doOnConnected(conn -> conn.addHandler((ChannelHandler)new ReadTimeoutHandler(clientProperties.getReadTimeoutMillis(), TimeUnit.MILLISECONDS)).addHandler((ChannelHandler)new WriteTimeoutHandler(clientProperties.getWriteTimeoutMillis(), TimeUnit.MILLISECONDS)));
        this.erdClientBuilder = WebClient.builder().baseUrl(this.gatewayUrl).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient));
    }

    @Generated
    public String getGatewayUrl() {
        return this.gatewayUrl;
    }

    @Generated
    public WebClient.Builder getErdClientBuilder() {
        return this.erdClientBuilder;
    }
}

