/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigInteger;
import lombok.Generated;
import software.crldev.elrondspringbootstarterreactive.domain.ApiModelToDomainConvertible;
import software.crldev.elrondspringbootstarterreactive.domain.account.Account;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.common.Nonce;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=AccountOnNetworkBuilder.class)
public final class AccountOnNetwork
implements ApiModelToDomainConvertible<Account> {
    @JsonProperty(value="address")
    private final String address;
    @JsonProperty(value="balance")
    private final BigInteger balance;
    @JsonProperty(value="developerReward")
    private final BigInteger developerReward;
    @JsonProperty(value="nonce")
    private final Long nonce;
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="code")
    private final String code;
    @JsonProperty(value="codeHash")
    private final String codeHash;
    @JsonProperty(value="codeMetadata")
    private final String codeMetadata;
    @JsonProperty(value="ownerAddress")
    private final String ownerAddress;
    @JsonProperty(value="rootHash")
    private final String rootHash;

    @Override
    public Account toDomainObject() {
        Account account = new Account();
        account.setAddress(Address.fromBech32(this.getAddress()));
        account.setNonce(Nonce.fromLong(this.getNonce()));
        account.setBalance(Balance.fromNumber(this.getBalance()));
        account.setCode(this.getCode());
        account.setUsername(this.getUsername());
        return account;
    }

    @Generated
    AccountOnNetwork(String address, BigInteger balance, BigInteger developerReward, Long nonce, String username, String code, String codeHash, String codeMetadata, String ownerAddress, String rootHash) {
        this.address = address;
        this.balance = balance;
        this.developerReward = developerReward;
        this.nonce = nonce;
        this.username = username;
        this.code = code;
        this.codeHash = codeHash;
        this.codeMetadata = codeMetadata;
        this.ownerAddress = ownerAddress;
        this.rootHash = rootHash;
    }

    @Generated
    public static AccountOnNetworkBuilder builder() {
        return new AccountOnNetworkBuilder();
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public BigInteger getBalance() {
        return this.balance;
    }

    @Generated
    public BigInteger getDeveloperReward() {
        return this.developerReward;
    }

    @Generated
    public Long getNonce() {
        return this.nonce;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getCodeHash() {
        return this.codeHash;
    }

    @Generated
    public String getCodeMetadata() {
        return this.codeMetadata;
    }

    @Generated
    public String getOwnerAddress() {
        return this.ownerAddress;
    }

    @Generated
    public String getRootHash() {
        return this.rootHash;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountOnNetwork)) {
            return false;
        }
        AccountOnNetwork other = (AccountOnNetwork)o;
        Long this$nonce = this.getNonce();
        Long other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !((Object)this$nonce).equals(other$nonce)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        BigInteger this$balance = this.getBalance();
        BigInteger other$balance = other.getBalance();
        if (this$balance == null ? other$balance != null : !((Object)this$balance).equals(other$balance)) {
            return false;
        }
        BigInteger this$developerReward = this.getDeveloperReward();
        BigInteger other$developerReward = other.getDeveloperReward();
        if (this$developerReward == null ? other$developerReward != null : !((Object)this$developerReward).equals(other$developerReward)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$codeHash = this.getCodeHash();
        String other$codeHash = other.getCodeHash();
        if (this$codeHash == null ? other$codeHash != null : !this$codeHash.equals(other$codeHash)) {
            return false;
        }
        String this$codeMetadata = this.getCodeMetadata();
        String other$codeMetadata = other.getCodeMetadata();
        if (this$codeMetadata == null ? other$codeMetadata != null : !this$codeMetadata.equals(other$codeMetadata)) {
            return false;
        }
        String this$ownerAddress = this.getOwnerAddress();
        String other$ownerAddress = other.getOwnerAddress();
        if (this$ownerAddress == null ? other$ownerAddress != null : !this$ownerAddress.equals(other$ownerAddress)) {
            return false;
        }
        String this$rootHash = this.getRootHash();
        String other$rootHash = other.getRootHash();
        return !(this$rootHash == null ? other$rootHash != null : !this$rootHash.equals(other$rootHash));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : ((Object)$nonce).hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        BigInteger $balance = this.getBalance();
        result = result * 59 + ($balance == null ? 43 : ((Object)$balance).hashCode());
        BigInteger $developerReward = this.getDeveloperReward();
        result = result * 59 + ($developerReward == null ? 43 : ((Object)$developerReward).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $codeHash = this.getCodeHash();
        result = result * 59 + ($codeHash == null ? 43 : $codeHash.hashCode());
        String $codeMetadata = this.getCodeMetadata();
        result = result * 59 + ($codeMetadata == null ? 43 : $codeMetadata.hashCode());
        String $ownerAddress = this.getOwnerAddress();
        result = result * 59 + ($ownerAddress == null ? 43 : $ownerAddress.hashCode());
        String $rootHash = this.getRootHash();
        result = result * 59 + ($rootHash == null ? 43 : $rootHash.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AccountOnNetwork(address=" + this.getAddress() + ", balance=" + this.getBalance() + ", developerReward=" + this.getDeveloperReward() + ", nonce=" + this.getNonce() + ", username=" + this.getUsername() + ", code=" + this.getCode() + ", codeHash=" + this.getCodeHash() + ", codeMetadata=" + this.getCodeMetadata() + ", ownerAddress=" + this.getOwnerAddress() + ", rootHash=" + this.getRootHash() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class AccountOnNetworkBuilder {
        @Generated
        private String address;
        @Generated
        private BigInteger balance;
        @Generated
        private BigInteger developerReward;
        @Generated
        private Long nonce;
        @Generated
        private String username;
        @Generated
        private String code;
        @Generated
        private String codeHash;
        @Generated
        private String codeMetadata;
        @Generated
        private String ownerAddress;
        @Generated
        private String rootHash;

        @Generated
        AccountOnNetworkBuilder() {
        }

        @JsonProperty(value="address")
        @Generated
        public AccountOnNetworkBuilder address(String address) {
            this.address = address;
            return this;
        }

        @JsonProperty(value="balance")
        @Generated
        public AccountOnNetworkBuilder balance(BigInteger balance) {
            this.balance = balance;
            return this;
        }

        @JsonProperty(value="developerReward")
        @Generated
        public AccountOnNetworkBuilder developerReward(BigInteger developerReward) {
            this.developerReward = developerReward;
            return this;
        }

        @JsonProperty(value="nonce")
        @Generated
        public AccountOnNetworkBuilder nonce(Long nonce) {
            this.nonce = nonce;
            return this;
        }

        @JsonProperty(value="username")
        @Generated
        public AccountOnNetworkBuilder username(String username) {
            this.username = username;
            return this;
        }

        @JsonProperty(value="code")
        @Generated
        public AccountOnNetworkBuilder code(String code) {
            this.code = code;
            return this;
        }

        @JsonProperty(value="codeHash")
        @Generated
        public AccountOnNetworkBuilder codeHash(String codeHash) {
            this.codeHash = codeHash;
            return this;
        }

        @JsonProperty(value="codeMetadata")
        @Generated
        public AccountOnNetworkBuilder codeMetadata(String codeMetadata) {
            this.codeMetadata = codeMetadata;
            return this;
        }

        @JsonProperty(value="ownerAddress")
        @Generated
        public AccountOnNetworkBuilder ownerAddress(String ownerAddress) {
            this.ownerAddress = ownerAddress;
            return this;
        }

        @JsonProperty(value="rootHash")
        @Generated
        public AccountOnNetworkBuilder rootHash(String rootHash) {
            this.rootHash = rootHash;
            return this;
        }

        @Generated
        public AccountOnNetwork build() {
            return new AccountOnNetwork(this.address, this.balance, this.developerReward, this.nonce, this.username, this.code, this.codeHash, this.codeMetadata, this.ownerAddress, this.rootHash);
        }

        @Generated
        public String toString() {
            return "AccountOnNetwork.AccountOnNetworkBuilder(address=" + this.address + ", balance=" + this.balance + ", developerReward=" + this.developerReward + ", nonce=" + this.nonce + ", username=" + this.username + ", code=" + this.code + ", codeHash=" + this.codeHash + ", codeMetadata=" + this.codeMetadata + ", ownerAddress=" + this.ownerAddress + ", rootHash=" + this.rootHash + ")";
        }
    }
}

