package software.crldev.elrondspringbootstarterreactive.interactor.transaction;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;

/**
 * This class represents a Transaction in a sendable format
 * user for the TransactionInteractor
 */
public final class SendableTransaction {
    @JsonProperty("nonce")
    private final Long nonce;
    @JsonProperty("value")
    private final String value;
    @JsonProperty("receiver")
    private final String receiver;
    @JsonProperty("sender")
    private final String sender;
    @JsonProperty("gasPrice")
    private final BigInteger gasPrice;
    @JsonProperty("gasLimit")
    private final BigInteger gasLimit;
    @JsonProperty("data")
    private final String data;
    @JsonProperty("chainID")
    private final String chainId;
    @JsonProperty("signature")
    private final String signature;
    @JsonProperty("version")
    private final Integer version;

    SendableTransaction(final Long nonce, final String value, final String receiver, final String sender, final BigInteger gasPrice, final BigInteger gasLimit, final String data, final String chainId, final String signature, final Integer version) {
        this.nonce = nonce;
        this.value = value;
        this.receiver = receiver;
        this.sender = sender;
        this.gasPrice = gasPrice;
        this.gasLimit = gasLimit;
        this.data = data;
        this.chainId = chainId;
        this.signature = signature;
        this.version = version;
    }


    public static class SendableTransactionBuilder {
        private Long nonce;
        private String value;
        private String receiver;
        private String sender;
        private BigInteger gasPrice;
        private BigInteger gasLimit;
        private String data;
        private String chainId;
        private String signature;
        private Integer version;

        SendableTransactionBuilder() {
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("nonce")
        public SendableTransaction.SendableTransactionBuilder nonce(final Long nonce) {
            this.nonce = nonce;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("value")
        public SendableTransaction.SendableTransactionBuilder value(final String value) {
            this.value = value;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("receiver")
        public SendableTransaction.SendableTransactionBuilder receiver(final String receiver) {
            this.receiver = receiver;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("sender")
        public SendableTransaction.SendableTransactionBuilder sender(final String sender) {
            this.sender = sender;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("gasPrice")
        public SendableTransaction.SendableTransactionBuilder gasPrice(final BigInteger gasPrice) {
            this.gasPrice = gasPrice;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("gasLimit")
        public SendableTransaction.SendableTransactionBuilder gasLimit(final BigInteger gasLimit) {
            this.gasLimit = gasLimit;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("data")
        public SendableTransaction.SendableTransactionBuilder data(final String data) {
            this.data = data;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("chainID")
        public SendableTransaction.SendableTransactionBuilder chainId(final String chainId) {
            this.chainId = chainId;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("signature")
        public SendableTransaction.SendableTransactionBuilder signature(final String signature) {
            this.signature = signature;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("version")
        public SendableTransaction.SendableTransactionBuilder version(final Integer version) {
            this.version = version;
            return this;
        }

        public SendableTransaction build() {
            return new SendableTransaction(this.nonce, this.value, this.receiver, this.sender, this.gasPrice, this.gasLimit, this.data, this.chainId, this.signature, this.version);
        }

        @Override
        public String toString() {
            return "SendableTransaction.SendableTransactionBuilder(nonce=" + this.nonce + ", value=" + this.value + ", receiver=" + this.receiver + ", sender=" + this.sender + ", gasPrice=" + this.gasPrice + ", gasLimit=" + this.gasLimit + ", data=" + this.data + ", chainId=" + this.chainId + ", signature=" + this.signature + ", version=" + this.version + ")";
        }
    }

    public static SendableTransaction.SendableTransactionBuilder builder() {
        return new SendableTransaction.SendableTransactionBuilder();
    }

    public Long getNonce() {
        return this.nonce;
    }

    public String getValue() {
        return this.value;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public String getSender() {
        return this.sender;
    }

    public BigInteger getGasPrice() {
        return this.gasPrice;
    }

    public BigInteger getGasLimit() {
        return this.gasLimit;
    }

    public String getData() {
        return this.data;
    }

    public String getChainId() {
        return this.chainId;
    }

    public String getSignature() {
        return this.signature;
    }

    public Integer getVersion() {
        return this.version;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof SendableTransaction)) return false;
        final SendableTransaction other = (SendableTransaction) o;
        final Object this$nonce = this.getNonce();
        final Object other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce)) return false;
        final Object this$version = this.getVersion();
        final Object other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) return false;
        final Object this$value = this.getValue();
        final Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
        final Object this$receiver = this.getReceiver();
        final Object other$receiver = other.getReceiver();
        if (this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver)) return false;
        final Object this$sender = this.getSender();
        final Object other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) return false;
        final Object this$gasPrice = this.getGasPrice();
        final Object other$gasPrice = other.getGasPrice();
        if (this$gasPrice == null ? other$gasPrice != null : !this$gasPrice.equals(other$gasPrice)) return false;
        final Object this$gasLimit = this.getGasLimit();
        final Object other$gasLimit = other.getGasLimit();
        if (this$gasLimit == null ? other$gasLimit != null : !this$gasLimit.equals(other$gasLimit)) return false;
        final Object this$data = this.getData();
        final Object other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) return false;
        final Object this$chainId = this.getChainId();
        final Object other$chainId = other.getChainId();
        if (this$chainId == null ? other$chainId != null : !this$chainId.equals(other$chainId)) return false;
        final Object this$signature = this.getSignature();
        final Object other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $nonce = this.getNonce();
        result = result * PRIME + ($nonce == null ? 43 : $nonce.hashCode());
        final Object $version = this.getVersion();
        result = result * PRIME + ($version == null ? 43 : $version.hashCode());
        final Object $value = this.getValue();
        result = result * PRIME + ($value == null ? 43 : $value.hashCode());
        final Object $receiver = this.getReceiver();
        result = result * PRIME + ($receiver == null ? 43 : $receiver.hashCode());
        final Object $sender = this.getSender();
        result = result * PRIME + ($sender == null ? 43 : $sender.hashCode());
        final Object $gasPrice = this.getGasPrice();
        result = result * PRIME + ($gasPrice == null ? 43 : $gasPrice.hashCode());
        final Object $gasLimit = this.getGasLimit();
        result = result * PRIME + ($gasLimit == null ? 43 : $gasLimit.hashCode());
        final Object $data = this.getData();
        result = result * PRIME + ($data == null ? 43 : $data.hashCode());
        final Object $chainId = this.getChainId();
        result = result * PRIME + ($chainId == null ? 43 : $chainId.hashCode());
        final Object $signature = this.getSignature();
        result = result * PRIME + ($signature == null ? 43 : $signature.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SendableTransaction(nonce=" + this.getNonce() + ", value=" + this.getValue() + ", receiver=" + this.getReceiver() + ", sender=" + this.getSender() + ", gasPrice=" + this.getGasPrice() + ", gasLimit=" + this.getGasLimit() + ", data=" + this.getData() + ", chainId=" + this.getChainId() + ", signature=" + this.getSignature() + ", version=" + this.getVersion() + ")";
    }
}
