package software.crldev.elrondspringbootstarterreactive.interactor;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import software.crldev.elrondspringbootstarterreactive.api.model.*;
import java.util.List;
import java.util.Map;

public class WrappedResponses {

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder = GetAccountTransactionsWrapper.GetAccountTransactionsWrapperBuilder.class)
    public static class GetAccountTransactionsWrapper {
        @JsonProperty("transactions")
        private final List<TransactionForAddress> list;

        GetAccountTransactionsWrapper(final List<TransactionForAddress> list) {
            this.list = list;
        }


        public static class GetAccountTransactionsWrapperBuilder {
            private List<TransactionForAddress> list;

            GetAccountTransactionsWrapperBuilder() {
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("transactions")
            public WrappedResponses.GetAccountTransactionsWrapper.GetAccountTransactionsWrapperBuilder list(final List<TransactionForAddress> list) {
                this.list = list;
                return this;
            }

            public WrappedResponses.GetAccountTransactionsWrapper build() {
                return new WrappedResponses.GetAccountTransactionsWrapper(this.list);
            }

            @Override
            public String toString() {
                return "WrappedResponses.GetAccountTransactionsWrapper.GetAccountTransactionsWrapperBuilder(list=" + this.list + ")";
            }
        }

        public static WrappedResponses.GetAccountTransactionsWrapper.GetAccountTransactionsWrapperBuilder builder() {
            return new WrappedResponses.GetAccountTransactionsWrapper.GetAccountTransactionsWrapperBuilder();
        }

        public List<TransactionForAddress> getList() {
            return this.list;
        }
    }


    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder = GetAccountWrapper.GetAccountWrapperBuilder.class)
    public static class GetAccountWrapper {
        @JsonProperty("account")
        private final AccountOnNetwork account;

        GetAccountWrapper(final AccountOnNetwork account) {
            this.account = account;
        }


        public static class GetAccountWrapperBuilder {
            private AccountOnNetwork account;

            GetAccountWrapperBuilder() {
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("account")
            public WrappedResponses.GetAccountWrapper.GetAccountWrapperBuilder account(final AccountOnNetwork account) {
                this.account = account;
                return this;
            }

            public WrappedResponses.GetAccountWrapper build() {
                return new WrappedResponses.GetAccountWrapper(this.account);
            }

            @Override
            public String toString() {
                return "WrappedResponses.GetAccountWrapper.GetAccountWrapperBuilder(account=" + this.account + ")";
            }
        }

        public static WrappedResponses.GetAccountWrapper.GetAccountWrapperBuilder builder() {
            return new WrappedResponses.GetAccountWrapper.GetAccountWrapperBuilder();
        }

        public AccountOnNetwork getAccount() {
            return this.account;
        }
    }


    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder = GetAllAccountStorageWrapper.GetAllAccountStorageWrapperBuilder.class)
    public static class GetAllAccountStorageWrapper {
        @JsonProperty("pairs")
        private final Map<String, String> pairs;

        GetAllAccountStorageWrapper(final Map<String, String> pairs) {
            this.pairs = pairs;
        }


        public static class GetAllAccountStorageWrapperBuilder {
            private Map<String, String> pairs;

            GetAllAccountStorageWrapperBuilder() {
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("pairs")
            public WrappedResponses.GetAllAccountStorageWrapper.GetAllAccountStorageWrapperBuilder pairs(final Map<String, String> pairs) {
                this.pairs = pairs;
                return this;
            }

            public WrappedResponses.GetAllAccountStorageWrapper build() {
                return new WrappedResponses.GetAllAccountStorageWrapper(this.pairs);
            }

            @Override
            public String toString() {
                return "WrappedResponses.GetAllAccountStorageWrapper.GetAllAccountStorageWrapperBuilder(pairs=" + this.pairs + ")";
            }
        }

        public static WrappedResponses.GetAllAccountStorageWrapper.GetAllAccountStorageWrapperBuilder builder() {
            return new WrappedResponses.GetAllAccountStorageWrapper.GetAllAccountStorageWrapperBuilder();
        }

        public Map<String, String> getPairs() {
            return this.pairs;
        }
    }


    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder = QueryHyperblock.QueryHyperblockBuilder.class)
    public static class QueryHyperblock {
        @JsonProperty("hyperblock")
        private final Hyperblock hyperblock;

        QueryHyperblock(final Hyperblock hyperblock) {
            this.hyperblock = hyperblock;
        }


        public static class QueryHyperblockBuilder {
            private Hyperblock hyperblock;

            QueryHyperblockBuilder() {
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("hyperblock")
            public WrappedResponses.QueryHyperblock.QueryHyperblockBuilder hyperblock(final Hyperblock hyperblock) {
                this.hyperblock = hyperblock;
                return this;
            }

            public WrappedResponses.QueryHyperblock build() {
                return new WrappedResponses.QueryHyperblock(this.hyperblock);
            }

            @Override
            public String toString() {
                return "WrappedResponses.QueryHyperblock.QueryHyperblockBuilder(hyperblock=" + this.hyperblock + ")";
            }
        }

        public static WrappedResponses.QueryHyperblock.QueryHyperblockBuilder builder() {
            return new WrappedResponses.QueryHyperblock.QueryHyperblockBuilder();
        }

        public Hyperblock getHyperblock() {
            return this.hyperblock;
        }
    }


    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder = QueryBlock.QueryBlockBuilder.class)
    public static class QueryBlock {
        @JsonProperty("block")
        private final ShardBlock block;

        QueryBlock(final ShardBlock block) {
            this.block = block;
        }


        public static class QueryBlockBuilder {
            private ShardBlock block;

            QueryBlockBuilder() {
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("block")
            public WrappedResponses.QueryBlock.QueryBlockBuilder block(final ShardBlock block) {
                this.block = block;
                return this;
            }

            public WrappedResponses.QueryBlock build() {
                return new WrappedResponses.QueryBlock(this.block);
            }

            @Override
            public String toString() {
                return "WrappedResponses.QueryBlock.QueryBlockBuilder(block=" + this.block + ")";
            }
        }

        public static WrappedResponses.QueryBlock.QueryBlockBuilder builder() {
            return new WrappedResponses.QueryBlock.QueryBlockBuilder();
        }

        public ShardBlock getBlock() {
            return this.block;
        }
    }


    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder = GetNetworkConfigResponse.GetNetworkConfigResponseBuilder.class)
    public static class GetNetworkConfigResponse {
        @JsonProperty("config")
        private final NetworkConfig networkConfig;

        GetNetworkConfigResponse(final NetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
        }


        public static class GetNetworkConfigResponseBuilder {
            private NetworkConfig networkConfig;

            GetNetworkConfigResponseBuilder() {
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("config")
            public WrappedResponses.GetNetworkConfigResponse.GetNetworkConfigResponseBuilder networkConfig(final NetworkConfig networkConfig) {
                this.networkConfig = networkConfig;
                return this;
            }

            public WrappedResponses.GetNetworkConfigResponse build() {
                return new WrappedResponses.GetNetworkConfigResponse(this.networkConfig);
            }

            @Override
            public String toString() {
                return "WrappedResponses.GetNetworkConfigResponse.GetNetworkConfigResponseBuilder(networkConfig=" + this.networkConfig + ")";
            }
        }

        public static WrappedResponses.GetNetworkConfigResponse.GetNetworkConfigResponseBuilder builder() {
            return new WrappedResponses.GetNetworkConfigResponse.GetNetworkConfigResponseBuilder();
        }

        public NetworkConfig getNetworkConfig() {
            return this.networkConfig;
        }
    }


    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder = GetShardStatusResponse.GetShardStatusResponseBuilder.class)
    public static class GetShardStatusResponse {
        @JsonProperty("status")
        private final ShardStatus shardStatus;

        GetShardStatusResponse(final ShardStatus shardStatus) {
            this.shardStatus = shardStatus;
        }


        public static class GetShardStatusResponseBuilder {
            private ShardStatus shardStatus;

            GetShardStatusResponseBuilder() {
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("status")
            public WrappedResponses.GetShardStatusResponse.GetShardStatusResponseBuilder shardStatus(final ShardStatus shardStatus) {
                this.shardStatus = shardStatus;
                return this;
            }

            public WrappedResponses.GetShardStatusResponse build() {
                return new WrappedResponses.GetShardStatusResponse(this.shardStatus);
            }

            @Override
            public String toString() {
                return "WrappedResponses.GetShardStatusResponse.GetShardStatusResponseBuilder(shardStatus=" + this.shardStatus + ")";
            }
        }

        public static WrappedResponses.GetShardStatusResponse.GetShardStatusResponseBuilder builder() {
            return new WrappedResponses.GetShardStatusResponse.GetShardStatusResponseBuilder();
        }

        public ShardStatus getShardStatus() {
            return this.shardStatus;
        }
    }


    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder = GetNodeHeartbeatStatusResponse.GetNodeHeartbeatStatusResponseBuilder.class)
    public static class GetNodeHeartbeatStatusResponse {
        @JsonProperty("heartbeats")
        private final List<NodeHeartbeatStatus> heartbeatstatus;

        GetNodeHeartbeatStatusResponse(final List<NodeHeartbeatStatus> heartbeatstatus) {
            this.heartbeatstatus = heartbeatstatus;
        }


        public static class GetNodeHeartbeatStatusResponseBuilder {
            private List<NodeHeartbeatStatus> heartbeatstatus;

            GetNodeHeartbeatStatusResponseBuilder() {
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("heartbeats")
            public WrappedResponses.GetNodeHeartbeatStatusResponse.GetNodeHeartbeatStatusResponseBuilder heartbeatstatus(final List<NodeHeartbeatStatus> heartbeatstatus) {
                this.heartbeatstatus = heartbeatstatus;
                return this;
            }

            public WrappedResponses.GetNodeHeartbeatStatusResponse build() {
                return new WrappedResponses.GetNodeHeartbeatStatusResponse(this.heartbeatstatus);
            }

            @Override
            public String toString() {
                return "WrappedResponses.GetNodeHeartbeatStatusResponse.GetNodeHeartbeatStatusResponseBuilder(heartbeatstatus=" + this.heartbeatstatus + ")";
            }
        }

        public static WrappedResponses.GetNodeHeartbeatStatusResponse.GetNodeHeartbeatStatusResponseBuilder builder() {
            return new WrappedResponses.GetNodeHeartbeatStatusResponse.GetNodeHeartbeatStatusResponseBuilder();
        }

        public List<NodeHeartbeatStatus> getHeartbeatstatus() {
            return this.heartbeatstatus;
        }
    }


    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder = QueryTransactionResponse.QueryTransactionResponseBuilder.class)
    public static class QueryTransactionResponse {
        @JsonProperty("transaction")
        private final TransactionOnNetwork transaction;

        QueryTransactionResponse(final TransactionOnNetwork transaction) {
            this.transaction = transaction;
        }


        public static class QueryTransactionResponseBuilder {
            private TransactionOnNetwork transaction;

            QueryTransactionResponseBuilder() {
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("transaction")
            public WrappedResponses.QueryTransactionResponse.QueryTransactionResponseBuilder transaction(final TransactionOnNetwork transaction) {
                this.transaction = transaction;
                return this;
            }

            public WrappedResponses.QueryTransactionResponse build() {
                return new WrappedResponses.QueryTransactionResponse(this.transaction);
            }

            @Override
            public String toString() {
                return "WrappedResponses.QueryTransactionResponse.QueryTransactionResponseBuilder(transaction=" + this.transaction + ")";
            }
        }

        public static WrappedResponses.QueryTransactionResponse.QueryTransactionResponseBuilder builder() {
            return new WrappedResponses.QueryTransactionResponse.QueryTransactionResponseBuilder();
        }

        public TransactionOnNetwork getTransaction() {
            return this.transaction;
        }
    }


    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonDeserialize(builder = SimulateTransactionResponse.SimulateTransactionResponseBuilder.class)
    public static class SimulateTransactionResponse {
        @JsonProperty("result")
        private final SimulationResults result;

        SimulateTransactionResponse(final SimulationResults result) {
            this.result = result;
        }


        public static class SimulateTransactionResponseBuilder {
            private SimulationResults result;

            SimulateTransactionResponseBuilder() {
            }

            /**
             * @return {@code this}.
             */
            @JsonProperty("result")
            public WrappedResponses.SimulateTransactionResponse.SimulateTransactionResponseBuilder result(final SimulationResults result) {
                this.result = result;
                return this;
            }

            public WrappedResponses.SimulateTransactionResponse build() {
                return new WrappedResponses.SimulateTransactionResponse(this.result);
            }

            @Override
            public String toString() {
                return "WrappedResponses.SimulateTransactionResponse.SimulateTransactionResponseBuilder(result=" + this.result + ")";
            }
        }

        public static WrappedResponses.SimulateTransactionResponse.SimulateTransactionResponseBuilder builder() {
            return new WrappedResponses.SimulateTransactionResponse.SimulateTransactionResponseBuilder();
        }

        public SimulationResults getResult() {
            return this.result;
        }
    }
}
