package software.crldev.elrondspringbootstarterreactive.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * API response when querying for transactions status
 *
 * @author carlo_stanciu
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = TransactionStatus.TransactionStatusBuilder.class)
public final class TransactionStatus {
    @JsonProperty("status")
    private final String status;

    TransactionStatus(final String status) {
        this.status = status;
    }


    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    public static class TransactionStatusBuilder {
        private String status;

        TransactionStatusBuilder() {
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("status")
        public TransactionStatus.TransactionStatusBuilder status(final String status) {
            this.status = status;
            return this;
        }

        public TransactionStatus build() {
            return new TransactionStatus(this.status);
        }

        @Override
        public String toString() {
            return "TransactionStatus.TransactionStatusBuilder(status=" + this.status + ")";
        }
    }

    public static TransactionStatus.TransactionStatusBuilder builder() {
        return new TransactionStatus.TransactionStatusBuilder();
    }

    public String getStatus() {
        return this.status;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof TransactionStatus)) return false;
        final TransactionStatus other = (TransactionStatus) o;
        final Object this$status = this.getStatus();
        final Object other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $status = this.getStatus();
        result = result * PRIME + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "TransactionStatus(status=" + this.getStatus() + ")";
    }
}
