package software.crldev.elrondspringbootstarterreactive.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * API response when querying for hyperblock shard data
 *
 * @author carlo_stanciu
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = ShardFromHyperblock.ShardFromHyperblockBuilder.class)
public final class ShardFromHyperblock {
    @JsonProperty("hash")
    private final String hash;
    @JsonProperty("nonce")
    private final Long nonce;
    @JsonProperty("round")
    private final Long round;
    @JsonProperty("shard")
    private final Integer shard;

    ShardFromHyperblock(final String hash, final Long nonce, final Long round, final Integer shard) {
        this.hash = hash;
        this.nonce = nonce;
        this.round = round;
        this.shard = shard;
    }


    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    public static class ShardFromHyperblockBuilder {
        private String hash;
        private Long nonce;
        private Long round;
        private Integer shard;

        ShardFromHyperblockBuilder() {
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("hash")
        public ShardFromHyperblock.ShardFromHyperblockBuilder hash(final String hash) {
            this.hash = hash;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("nonce")
        public ShardFromHyperblock.ShardFromHyperblockBuilder nonce(final Long nonce) {
            this.nonce = nonce;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("round")
        public ShardFromHyperblock.ShardFromHyperblockBuilder round(final Long round) {
            this.round = round;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("shard")
        public ShardFromHyperblock.ShardFromHyperblockBuilder shard(final Integer shard) {
            this.shard = shard;
            return this;
        }

        public ShardFromHyperblock build() {
            return new ShardFromHyperblock(this.hash, this.nonce, this.round, this.shard);
        }

        @Override
        public String toString() {
            return "ShardFromHyperblock.ShardFromHyperblockBuilder(hash=" + this.hash + ", nonce=" + this.nonce + ", round=" + this.round + ", shard=" + this.shard + ")";
        }
    }

    public static ShardFromHyperblock.ShardFromHyperblockBuilder builder() {
        return new ShardFromHyperblock.ShardFromHyperblockBuilder();
    }

    public String getHash() {
        return this.hash;
    }

    public Long getNonce() {
        return this.nonce;
    }

    public Long getRound() {
        return this.round;
    }

    public Integer getShard() {
        return this.shard;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof ShardFromHyperblock)) return false;
        final ShardFromHyperblock other = (ShardFromHyperblock) o;
        final Object this$nonce = this.getNonce();
        final Object other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce)) return false;
        final Object this$round = this.getRound();
        final Object other$round = other.getRound();
        if (this$round == null ? other$round != null : !this$round.equals(other$round)) return false;
        final Object this$shard = this.getShard();
        final Object other$shard = other.getShard();
        if (this$shard == null ? other$shard != null : !this$shard.equals(other$shard)) return false;
        final Object this$hash = this.getHash();
        final Object other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $nonce = this.getNonce();
        result = result * PRIME + ($nonce == null ? 43 : $nonce.hashCode());
        final Object $round = this.getRound();
        result = result * PRIME + ($round == null ? 43 : $round.hashCode());
        final Object $shard = this.getShard();
        result = result * PRIME + ($shard == null ? 43 : $shard.hashCode());
        final Object $hash = this.getHash();
        result = result * PRIME + ($hash == null ? 43 : $hash.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ShardFromHyperblock(hash=" + this.getHash() + ", nonce=" + this.getNonce() + ", round=" + this.getRound() + ", shard=" + this.getShard() + ")";
    }
}
