package software.crldev.elrondspringbootstarterreactive.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * API response when querying for address storage value
 *
 * @author carlo_stanciu
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = AddressStorageValue.AddressStorageValueBuilder.class)
public final class AddressStorageValue {
    @JsonProperty("value")
    private final String value;

    AddressStorageValue(final String value) {
        this.value = value;
    }


    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    public static class AddressStorageValueBuilder {
        private String value;

        AddressStorageValueBuilder() {
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("value")
        public AddressStorageValue.AddressStorageValueBuilder value(final String value) {
            this.value = value;
            return this;
        }

        public AddressStorageValue build() {
            return new AddressStorageValue(this.value);
        }

        @Override
        public String toString() {
            return "AddressStorageValue.AddressStorageValueBuilder(value=" + this.value + ")";
        }
    }

    public static AddressStorageValue.AddressStorageValueBuilder builder() {
        return new AddressStorageValue.AddressStorageValueBuilder();
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof AddressStorageValue)) return false;
        final AddressStorageValue other = (AddressStorageValue) o;
        final Object this$value = this.getValue();
        final Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $value = this.getValue();
        result = result * PRIME + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AddressStorageValue(value=" + this.getValue() + ")";
    }
}
