package software.crldev.elrondspringbootstarterreactive.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;

/**
 * API response when querying for address balance
 *
 * @author carlo_stanciu
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = AddressBalance.AddressBalanceBuilder.class)
public final class AddressBalance {
    @JsonProperty("balance")
    private final BigInteger balance;

    AddressBalance(final BigInteger balance) {
        this.balance = balance;
    }


    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    public static class AddressBalanceBuilder {
        private BigInteger balance;

        AddressBalanceBuilder() {
        }

        /**
         * @return {@code this}.
         */
        @JsonProperty("balance")
        public AddressBalance.AddressBalanceBuilder balance(final BigInteger balance) {
            this.balance = balance;
            return this;
        }

        public AddressBalance build() {
            return new AddressBalance(this.balance);
        }

        @Override
        public String toString() {
            return "AddressBalance.AddressBalanceBuilder(balance=" + this.balance + ")";
        }
    }

    public static AddressBalance.AddressBalanceBuilder builder() {
        return new AddressBalance.AddressBalanceBuilder();
    }

    public BigInteger getBalance() {
        return this.balance;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof AddressBalance)) return false;
        final AddressBalance other = (AddressBalance) o;
        final Object this$balance = this.getBalance();
        final Object other$balance = other.getBalance();
        if (this$balance == null ? other$balance != null : !this$balance.equals(other$balance)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object $balance = this.getBalance();
        result = result * PRIME + ($balance == null ? 43 : $balance.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AddressBalance(balance=" + this.getBalance() + ")";
    }
}
