/*
 * Decompiled with CFR 0.152.
 */
package software.betamax.junit;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import software.betamax.ComposedMatchRule;
import software.betamax.Configuration;
import software.betamax.MatchRule;
import software.betamax.Recorder;
import software.betamax.TapeMode;
import software.betamax.junit.Betamax;

public class RecorderRule
extends Recorder
implements TestRule {
    private final Logger log = Logger.getLogger(RecorderRule.class.getName());

    public RecorderRule() {
    }

    public RecorderRule(Configuration configuration) {
        super(configuration);
    }

    public Statement apply(final Statement statement, final Description description) {
        final Betamax annotation = (Betamax)description.getAnnotation(Betamax.class);
        if (annotation != null) {
            this.log.fine(String.format("found @Betamax annotation on '%s'", description.getDisplayName()));
            return new Statement(){

                public void evaluate() throws Throwable {
                    try {
                        String tapeName = annotation.tape();
                        if (Strings.isNullOrEmpty((String)tapeName)) {
                            tapeName = RecorderRule.this.defaultTapeName(description);
                        }
                        TapeMode tapeMode = annotation.mode();
                        MatchRule matchRule = ComposedMatchRule.of((MatchRule[])annotation.match());
                        RecorderRule.this.start(tapeName, tapeMode, matchRule);
                        statement.evaluate();
                    }
                    catch (Exception e) {
                        RecorderRule.this.log.log(Level.SEVERE, "Caught exception starting Betamax", e);
                        throw e;
                    }
                    finally {
                        RecorderRule.this.stop();
                    }
                }
            };
        }
        this.log.fine(String.format("no @Betamax annotation on '%s'", description.getDisplayName()));
        return statement;
    }

    private String defaultTapeName(Description description) {
        String name = description.getMethodName() != null ? CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, description.getMethodName()) : CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, description.getTestClass().getSimpleName());
        return name.replace('_', ' ');
    }
}

