/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.snapstart;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.classfile.Global;
import java.util.Objects;
import org.apache.bcel.classfile.JavaClass;
import software.amazon.lambda.snapstart.ByteCodeIntrospector;
import software.amazon.lambda.snapstart.LambdaHandlerParentsDatabase;

public class CacheLambdaHandlerParentClasses
implements Detector {
    private final ByteCodeIntrospector introspector = new ByteCodeIntrospector();
    private ClassContext classContext;
    private XClass xClass;
    private final LambdaHandlerParentsDatabase database = new LambdaHandlerParentsDatabase();

    public CacheLambdaHandlerParentClasses(BugReporter bugReporter) {
        Global.getAnalysisCache().eagerlyPutDatabase(LambdaHandlerParentsDatabase.class, (Object)this.database);
    }

    public void visitClassContext(ClassContext classContext) {
        this.classContext = classContext;
        this.xClass = classContext.getXClass();
        if (this.introspector.isLambdaHandler(this.xClass)) {
            JavaClass[] parentClasses = null;
            try {
                parentClasses = classContext.getJavaClass().getSuperClasses();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (Objects.nonNull(parentClasses)) {
                for (JavaClass parentClass : parentClasses) {
                    if (parentClass.getClassName().equals("java.lang.Object")) continue;
                    this.database.addLambdaParentClass(parentClass.getClassName().replace(".", "/"));
                }
            }
        }
    }

    public void report() {
    }
}

