/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.snapstart;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.FieldOrMethodDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import org.apache.bcel.classfile.Field;
import software.amazon.lambda.snapstart.ByteCodeIntrospector;
import software.amazon.lambda.snapstart.LambdaHandlerFieldsDatabase;

public class CacheLambdaHandlerFields
implements Detector {
    private final ByteCodeIntrospector introspector = new ByteCodeIntrospector();
    private ClassContext classContext;
    private XClass xClass;
    private final LambdaHandlerFieldsDatabase database = new LambdaHandlerFieldsDatabase();

    public CacheLambdaHandlerFields(BugReporter reporter) {
        Global.getAnalysisCache().eagerlyPutDatabase(LambdaHandlerFieldsDatabase.class, (Object)this.database);
    }

    public void visitClassContext(ClassContext classContext) {
        this.classContext = classContext;
        this.xClass = classContext.getXClass();
        if (this.introspector.isLambdaHandler(this.xClass)) {
            Field[] fields;
            for (Field field : fields = classContext.getJavaClass().getFields()) {
                FieldDescriptor fieldDescriptor = DescriptorFactory.instance().getFieldDescriptor(this.xClass.toString().replace(".", "/"), field);
                this.database.setProperty((FieldOrMethodDescriptor)fieldDescriptor, true);
            }
        }
    }

    public void report() {
    }
}

