/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.snapstart;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.ca.Call;
import edu.umd.cs.findbugs.ba.ca.CallList;
import edu.umd.cs.findbugs.ba.ca.CallListDataflow;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.FieldOrMethodDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.log.Profiler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.ReturnInstruction;
import software.amazon.lambda.snapstart.ByteCodeIntrospector;
import software.amazon.lambda.snapstart.CallGraph;
import software.amazon.lambda.snapstart.ReturnValueRandomnessPropertyDatabase;

public class BuildRandomReturningMethodsDatabase
implements Detector {
    private final BugReporter bugReporter;
    private final BugAccumulator bugAccumulator;
    private final ReturnValueRandomnessPropertyDatabase database;
    private final ByteCodeIntrospector introspector;
    private ClassContext classContext;
    private Method method;
    private MethodDescriptor methodDescriptor;
    private CallListDataflow callListDataflow;
    private Map<Call, MethodDescriptor> callMethodDescriptorMap;
    private CallGraph callGraph;

    public BuildRandomReturningMethodsDatabase(BugReporter reporter) {
        this.bugReporter = reporter;
        this.bugAccumulator = new BugAccumulator(reporter);
        this.database = new ReturnValueRandomnessPropertyDatabase();
        Global.getAnalysisCache().eagerlyPutDatabase(ReturnValueRandomnessPropertyDatabase.class, (Object)this.database);
        this.callGraph = new CallGraph();
        this.callMethodDescriptorMap = new HashMap<Call, MethodDescriptor>();
        this.introspector = new ByteCodeIntrospector();
    }

    public void visitClassContext(ClassContext classContext) {
        this.classContext = classContext;
        String currentMethod = null;
        List methodsInCallOrder = classContext.getMethodsInCallOrder();
        for (Method method : methodsInCallOrder) {
            try {
                if (method.isAbstract() || method.isNative() || method.getCode() == null) continue;
                currentMethod = SignatureConverter.convertMethodSignature((JavaClass)classContext.getJavaClass(), (Method)method);
                this.analyzeMethod(method);
            }
            catch (MissingClassException e) {
                this.bugReporter.reportMissingClass(e.getClassNotFoundException());
            }
            catch (CFGBuilderException | DataflowAnalysisException e) {
                this.bugReporter.logError("While analyzing " + currentMethod + ": BuildRandomReturningMethodsDatabase caught an exception", e);
            }
            this.bugAccumulator.reportAccumulatedBugs();
        }
    }

    private void analyzeMethod(Method method) throws DataflowAnalysisException, CFGBuilderException {
        if ((method.getAccessFlags() & 0x40) != 0) {
            return;
        }
        this.method = method;
        this.methodDescriptor = DescriptorFactory.instance().getMethodDescriptor(this.classContext.getJavaClass(), method);
        this.callListDataflow = this.classContext.getCallListDataflow(method);
        this.checkInvokeAndReturnInstructions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInvokeAndReturnInstructions() {
        Profiler profiler = Global.getAnalysisCache().getProfiler();
        profiler.start(BuildRandomReturningMethodsDatabase.class);
        try {
            Iterator i = this.classContext.getCFG(this.method).locationIterator();
            while (i.hasNext()) {
                Location location = (Location)i.next();
                Instruction ins = location.getHandle().getInstruction();
                if (ins instanceof ReturnInstruction) {
                    this.examineReturnInstruction(location);
                    continue;
                }
                if (!(ins instanceof InvokeInstruction)) continue;
                this.examineInvokeInstruction((InvokeInstruction)ins);
            }
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError((String)"error:", (Exception)((Object)e));
        }
        finally {
            profiler.end(BuildRandomReturningMethodsDatabase.class);
        }
    }

    private void examineInvokeInstruction(InvokeInstruction inv) {
        ConstantPoolGen cpg = this.classContext.getConstantPoolGen();
        MethodDescriptor md = new MethodDescriptor(inv, this.classContext.getConstantPoolGen());
        Call call = new Call(inv.getClassName(cpg), inv.getName(cpg), inv.getSignature(cpg));
        this.callMethodDescriptorMap.put(call, md);
    }

    private void examineReturnInstruction(Location location) throws DataflowAnalysisException {
        CallList callList = (CallList)this.callListDataflow.getFactAtLocation(location);
        if (!callList.isValid()) {
            return;
        }
        Iterator callIterator = callList.callIterator();
        while (callIterator.hasNext()) {
            Call call = (Call)callIterator.next();
            MethodDescriptor caller = this.methodDescriptor;
            MethodDescriptor called = this.callMethodDescriptorMap.get(call);
            if (called == null) continue;
            this.recordCalledMethod(caller, called);
        }
    }

    private void recordCalledMethod(MethodDescriptor caller, MethodDescriptor called) {
        Boolean returnsRandom = (Boolean)this.database.getProperty((FieldOrMethodDescriptor)called);
        if (returnsRandom != null && returnsRandom.booleanValue()) {
            this.callGraph.flushCallersToDatabase(caller, this.database, true);
        } else if (this.callGraph.isInCallGraph(caller) || this.isLambdaHandlerInitMethod()) {
            this.callGraph.record(caller, called);
        }
    }

    private boolean isLambdaHandlerInitMethod() {
        if (this.introspector.isLambdaHandler(this.classContext.getXClass())) {
            return "<clinit>".equals(this.method.getName()) || "<init>".equals(this.method.getName());
        }
        return false;
    }

    public void report() {
    }
}

