package software.amazon.awscdk.services.sns.subscriptions;

/**
 * Properties for an SQS subscription.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.16.0 (build 98909b5)", date = "2019-09-06T01:08:13.360Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SqsSubscriptionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.sns.subscriptions.SubscriptionProps {
    /**
     * The message to the queue is the same as it was sent to the topic.
     * 
     * If false, the message will be wrapped in an SNS envelope.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getRawMessageDelivery();

    /**
     * @return a {@link Builder} of {@link SqsSubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link SqsSubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.Boolean rawMessageDelivery;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy;

        /**
         * Sets the value of RawMessageDelivery
         * @param rawMessageDelivery The message to the queue is the same as it was sent to the topic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rawMessageDelivery(java.lang.Boolean rawMessageDelivery) {
            this.rawMessageDelivery = rawMessageDelivery;
            return this;
        }

        /**
         * Sets the value of FilterPolicy
         * @param filterPolicy The filter policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPolicy(java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy) {
            this.filterPolicy = filterPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SqsSubscriptionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public SqsSubscriptionProps build() {
            return new Jsii$Proxy(rawMessageDelivery, filterPolicy);
        }

    }

    /**
     * An implementation for {@link SqsSubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SqsSubscriptionProps {
        private final java.lang.Boolean rawMessageDelivery;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.rawMessageDelivery = this.jsiiGet("rawMessageDelivery", java.lang.Boolean.class);
            this.filterPolicy = this.jsiiGet("filterPolicy", java.util.Map.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Boolean rawMessageDelivery, java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.rawMessageDelivery = rawMessageDelivery;
            this.filterPolicy = filterPolicy;
        }

        @Override
        public java.lang.Boolean getRawMessageDelivery() {
            return this.rawMessageDelivery;
        }

        @Override
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> getFilterPolicy() {
            return this.filterPolicy;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getRawMessageDelivery() != null) {
                obj.set("rawMessageDelivery", om.valueToTree(this.getRawMessageDelivery()));
            }
            if (this.getFilterPolicy() != null) {
                obj.set("filterPolicy", om.valueToTree(this.getFilterPolicy()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SqsSubscriptionProps.Jsii$Proxy that = (SqsSubscriptionProps.Jsii$Proxy) o;

            if (this.rawMessageDelivery != null ? !this.rawMessageDelivery.equals(that.rawMessageDelivery) : that.rawMessageDelivery != null) return false;
            return this.filterPolicy != null ? this.filterPolicy.equals(that.filterPolicy) : that.filterPolicy == null;
        }

        @Override
        public int hashCode() {
            int result = this.rawMessageDelivery != null ? this.rawMessageDelivery.hashCode() : 0;
            result = 31 * result + (this.filterPolicy != null ? this.filterPolicy.hashCode() : 0);
            return result;
        }

    }
}
