package software.amazon.awscdk.services.sns.subscriptions;

/**
 * Options for URL subscriptions.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.2 (build e881f16)", date = "2019-07-19T19:10:39.876Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UrlSubscriptionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.sns.subscriptions.SubscriptionProps {
    /**
     * The subscription's protocol.
     * 
     * Default: - Protocol is derived from url
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.sns.SubscriptionProtocol getProtocol();
    /**
     * The message to the queue is the same as it was sent to the topic.
     * 
     * If false, the message will be wrapped in an SNS envelope.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getRawMessageDelivery();

    /**
     * @return a {@link Builder} of {@link UrlSubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link UrlSubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.sns.SubscriptionProtocol _protocol;
        @javax.annotation.Nullable
        private java.lang.Boolean _rawMessageDelivery;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> _filterPolicy;

        /**
         * Sets the value of Protocol
         * @param value The subscription's protocol.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.sns.SubscriptionProtocol value) {
            this._protocol = value;
            return this;
        }
        /**
         * Sets the value of RawMessageDelivery
         * @param value The message to the queue is the same as it was sent to the topic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withRawMessageDelivery(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._rawMessageDelivery = value;
            return this;
        }
        /**
         * Sets the value of FilterPolicy
         * @param value The filter policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withFilterPolicy(@javax.annotation.Nullable final java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> value) {
            this._filterPolicy = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UrlSubscriptionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public UrlSubscriptionProps build() {
            return new UrlSubscriptionProps() {
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.sns.SubscriptionProtocol $protocol = _protocol;
                @javax.annotation.Nullable
                private final java.lang.Boolean $rawMessageDelivery = _rawMessageDelivery;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> $filterPolicy = _filterPolicy;

                @Override
                public software.amazon.awscdk.services.sns.SubscriptionProtocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public java.lang.Boolean getRawMessageDelivery() {
                    return this.$rawMessageDelivery;
                }

                @Override
                public java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> getFilterPolicy() {
                    return this.$filterPolicy;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getProtocol() != null) {
                        obj.set("protocol", om.valueToTree(this.getProtocol()));
                    }
                    if (this.getRawMessageDelivery() != null) {
                        obj.set("rawMessageDelivery", om.valueToTree(this.getRawMessageDelivery()));
                    }
                    if (this.getFilterPolicy() != null) {
                        obj.set("filterPolicy", om.valueToTree(this.getFilterPolicy()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.sns.subscriptions.UrlSubscriptionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The subscription's protocol.
         * 
         * Default: - Protocol is derived from url
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.sns.SubscriptionProtocol getProtocol() {
            return this.jsiiGet("protocol", software.amazon.awscdk.services.sns.SubscriptionProtocol.class);
        }

        /**
         * The message to the queue is the same as it was sent to the topic.
         * 
         * If false, the message will be wrapped in an SNS envelope.
         * 
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getRawMessageDelivery() {
            return this.jsiiGet("rawMessageDelivery", java.lang.Boolean.class);
        }

        /**
         * The filter policy.
         * 
         * Default: - all messages are delivered
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> getFilterPolicy() {
            return this.jsiiGet("filterPolicy", java.util.Map.class);
        }
    }
}
