package software.amazon.awscdk.services.servicecatalogappregistry.alpha;

/**
 * (experimental) A Service Catalog AppRegistry Application.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Application application = Application.Builder.create(this, "MyFirstApplication")
 *         .applicationName("MyFirstApplicationName")
 *         .description("description for my application")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-02-03T19:59:44.401Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalogappregistry.alpha.$Module.class, fqn = "@aws-cdk/aws-servicecatalogappregistry-alpha.Application")
public class Application extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.servicecatalogappregistry.alpha.IApplication {

    protected Application(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Application(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Application(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalogappregistry.alpha.ApplicationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Imports an Application construct that represents an external application.
     * <p>
     * @param scope The parent creating construct (usually `this`). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param applicationArn the Amazon Resource Name of the existing AppRegistry Application. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalogappregistry.alpha.IApplication fromApplicationArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String applicationArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.servicecatalogappregistry.alpha.Application.class, "fromApplicationArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalogappregistry.alpha.IApplication.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(applicationArn, "applicationArn is required") });
    }

    /**
     * (experimental) Associate all stacks present in construct's aspect with application.
     * <p>
     * NOTE: This method won't automatically register stacks under pipeline stages,
     * and requires association of each pipeline stage by calling this method with stage Construct.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void associateAllStacksInScope(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
        software.amazon.jsii.Kernel.call(this, "associateAllStacksInScope", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * (experimental) Associate stack with the application in the stack passed as parameter.
     * <p>
     * A stack can only be associated with one application.
     * <p>
     * @param stack This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void associateApplicationWithStack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack) {
        software.amazon.jsii.Kernel.call(this, "associateApplicationWithStack", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * (experimental) Associate an attribute group with application If the attribute group is already associated, it will ignore duplicate request.
     * <p>
     * @param attributeGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void associateAttributeGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalogappregistry.alpha.IAttributeGroup attributeGroup) {
        software.amazon.jsii.Kernel.call(this, "associateAttributeGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(attributeGroup, "attributeGroup is required") });
    }

    /**
     * (deprecated) Associate a stack with the application If the resource is already associated, it will ignore duplicate request.
     * <p>
     * A stack can only be associated with one application.
     * <p>
     * @deprecated Use `associateApplicationWithStack` instead.
     * @param stack This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    @Override
    public void associateStack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack) {
        software.amazon.jsii.Kernel.call(this, "associateStack", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * (experimental) Create a unique id.
     * <p>
     * @param resourceAddress This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull java.lang.String generateUniqueHash(final @org.jetbrains.annotations.NotNull java.lang.String resourceAddress) {
        return software.amazon.jsii.Kernel.call(this, "generateUniqueHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resourceAddress, "resourceAddress is required") });
    }

    /**
     * (experimental) Share an application with accounts, organizations and OUs, and IAM roles and users.
     * <p>
     * The application will become available to end users within those principals.
     * <p>
     * @param shareOptions The options for the share. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void shareApplication(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalogappregistry.alpha.ShareOptions shareOptions) {
        software.amazon.jsii.Kernel.call(this, "shareApplication", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(shareOptions, "shareOptions is required") });
    }

    /**
     * (experimental) The ARN of the application.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationArn() {
        return software.amazon.jsii.Kernel.get(this, "applicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The ID of the application.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationId() {
        return software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Application manager URL for the Application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.CfnOutput getApplicationManagerUrl() {
        return software.amazon.jsii.Kernel.get(this, "applicationManagerUrl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnOutput.class));
    }

    /**
     * (experimental) The name of the application.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getApplicationName() {
        return software.amazon.jsii.Kernel.get(this, "applicationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.servicecatalogappregistry.alpha.Application}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.servicecatalogappregistry.alpha.Application> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.servicecatalogappregistry.alpha.ApplicationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.servicecatalogappregistry.alpha.ApplicationProps.Builder();
        }

        /**
         * (experimental) Enforces a particular physical application name.
         * <p>
         * @return {@code this}
         * @param applicationName Enforces a particular physical application name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder applicationName(final java.lang.String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        /**
         * (experimental) Description for application.
         * <p>
         * Default: - No description provided
         * <p>
         * @return {@code this}
         * @param description Description for application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.servicecatalogappregistry.alpha.Application}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.servicecatalogappregistry.alpha.Application build() {
            return new software.amazon.awscdk.services.servicecatalogappregistry.alpha.Application(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
