package software.amazon.awscdk.services.servicecatalogappregistry.alpha;

/**
 * (experimental) An AppRegistry construct to automatically create an application with the given name and description.
 * <p>
 * The application name must be unique at the account level and it's immutable.
 * This construct will automatically associate all stacks in the given scope, however
 * in case of a <code>Pipeline</code> stack, stage underneath the pipeline will not automatically be associated and
 * needs to be associated separately.
 * <p>
 * If cross account stack is detected, then this construct will automatically share the application to consumer accounts.
 * Cross account feature will only work for non environment agnostic stacks.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App app = new App();
 * ApplicationAssociator associatedApp = ApplicationAssociator.Builder.create(app, "AssociatedApplication")
 *         .applications(List.of(TargetApplication.createApplicationStack(CreateTargetApplicationOptions.builder()
 *                 .applicationName("MyAssociatedApplication")
 *                 // 'Application containing stacks deployed via CDK.' is the default
 *                 .applicationDescription("Associated Application description")
 *                 .stackName("MyAssociatedApplicationStack")
 *                 // AWS Account and Region that are implied by the current CLI configuration is the default
 *                 .env(Environment.builder().account("123456789012").region("us-east-1").build())
 *                 .build())))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.73.0 (build 6faeda3)", date = "2023-01-19T00:05:58.913Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalogappregistry.alpha.$Module.class, fqn = "@aws-cdk/aws-servicecatalogappregistry-alpha.ApplicationAssociator")
public class ApplicationAssociator extends software.constructs.Construct {

    protected ApplicationAssociator(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApplicationAssociator(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ApplicationAssociator(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.App scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalogappregistry.alpha.ApplicationAssociatorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Get the AppRegistry application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalogappregistry.alpha.IApplication appRegistryApplication() {
        return software.amazon.jsii.Kernel.call(this, "appRegistryApplication", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalogappregistry.alpha.IApplication.class));
    }

    /**
     * (experimental) Associate this application with the given stage.
     * <p>
     * @param stage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stage associateStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stage stage) {
        return software.amazon.jsii.Kernel.call(this, "associateStage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stage.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required") });
    }

    /**
     * (experimental) Validates if a stage is already associated to the application.
     * <p>
     * @param stage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean isStageAssociated(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stage stage) {
        return software.amazon.jsii.Kernel.call(this, "isStageAssociated", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(stage, "stage is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.servicecatalogappregistry.alpha.ApplicationAssociator}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.servicecatalogappregistry.alpha.ApplicationAssociator> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.App scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.App scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.servicecatalogappregistry.alpha.ApplicationAssociatorProps.Builder props;

        private Builder(final software.amazon.awscdk.App scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.servicecatalogappregistry.alpha.ApplicationAssociatorProps.Builder();
        }

        /**
         * (experimental) Application associator properties.
         * <p>
         * Default: - Empty array.
         * <p>
         * @return {@code this}
         * @param applications Application associator properties. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder applications(final java.util.List<? extends software.amazon.awscdk.services.servicecatalogappregistry.alpha.TargetApplication> applications) {
            this.props.applications(applications);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.servicecatalogappregistry.alpha.ApplicationAssociator}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.servicecatalogappregistry.alpha.ApplicationAssociator build() {
            return new software.amazon.awscdk.services.servicecatalogappregistry.alpha.ApplicationAssociator(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
