package software.amazon.awscdk.services.servicecatalogappregistry.alpha;

/**
 * (experimental) Properties for a Service Catalog AppRegistry Attribute Group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AttributeGroup attributeGroup = AttributeGroup.Builder.create(this, "MyFirstAttributeGroup")
 *         .attributeGroupName("MyFirstAttributeGroupName")
 *         .description("description for my attribute group") // the description is optional,
 *         .attributes(Map.of(
 *                 "project", "foo",
 *                 "team", List.of("member1", "member2", "member3"),
 *                 "public", false,
 *                 "stages", Map.of(
 *                         "alpha", "complete",
 *                         "beta", "incomplete",
 *                         "release", "not started")))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2023-01-03T15:29:20.049Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalogappregistry.alpha.$Module.class, fqn = "@aws-cdk/aws-servicecatalogappregistry-alpha.AttributeGroupProps")
@software.amazon.jsii.Jsii.Proxy(AttributeGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AttributeGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Enforces a particular physical attribute group name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getAttributeGroupName();

    /**
     * (experimental) A JSON of nested key-value pairs that represent the attributes in the group.
     * <p>
     * Attributes maybe an empty JSON '{}', but must be explicitly stated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getAttributes();

    /**
     * (experimental) Description for attribute group.
     * <p>
     * Default: - No description provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AttributeGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AttributeGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AttributeGroupProps> {
        java.lang.String attributeGroupName;
        java.util.Map<java.lang.String, java.lang.Object> attributes;
        java.lang.String description;

        /**
         * Sets the value of {@link AttributeGroupProps#getAttributeGroupName}
         * @param attributeGroupName Enforces a particular physical attribute group name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder attributeGroupName(java.lang.String attributeGroupName) {
            this.attributeGroupName = attributeGroupName;
            return this;
        }

        /**
         * Sets the value of {@link AttributeGroupProps#getAttributes}
         * @param attributes A JSON of nested key-value pairs that represent the attributes in the group. This parameter is required.
         *                   Attributes maybe an empty JSON '{}', but must be explicitly stated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder attributes(java.util.Map<java.lang.String, ? extends java.lang.Object> attributes) {
            this.attributes = (java.util.Map<java.lang.String, java.lang.Object>)attributes;
            return this;
        }

        /**
         * Sets the value of {@link AttributeGroupProps#getDescription}
         * @param description Description for attribute group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AttributeGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AttributeGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AttributeGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttributeGroupProps {
        private final java.lang.String attributeGroupName;
        private final java.util.Map<java.lang.String, java.lang.Object> attributes;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.attributeGroupName = software.amazon.jsii.Kernel.get(this, "attributeGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.attributeGroupName = java.util.Objects.requireNonNull(builder.attributeGroupName, "attributeGroupName is required");
            this.attributes = (java.util.Map<java.lang.String, java.lang.Object>)java.util.Objects.requireNonNull(builder.attributes, "attributes is required");
            this.description = builder.description;
        }

        @Override
        public final java.lang.String getAttributeGroupName() {
            return this.attributeGroupName;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAttributes() {
            return this.attributes;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("attributeGroupName", om.valueToTree(this.getAttributeGroupName()));
            data.set("attributes", om.valueToTree(this.getAttributes()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicecatalogappregistry-alpha.AttributeGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AttributeGroupProps.Jsii$Proxy that = (AttributeGroupProps.Jsii$Proxy) o;

            if (!attributeGroupName.equals(that.attributeGroupName)) return false;
            if (!attributes.equals(that.attributes)) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public final int hashCode() {
            int result = this.attributeGroupName.hashCode();
            result = 31 * result + (this.attributes.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
