/**
 * <h1>AWS ServiceCatalogAppRegistry Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Experimental" src="https://img.shields.io/badge/cdk--constructs-experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * The APIs of higher level constructs in this module are experimental and under active development.
 * They are subject to non-backward compatible changes or removal in any future version. These are
 * not subject to the <a href="https://semver.org/">Semantic Versioning</a> model and breaking changes will be
 * announced in the release notes. This means that while you may use them, you may need to update
 * your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/appregistry.html">AWS Service Catalog App Registry</a>
 * enables organizations to create and manage repositories of applications and associated resources.
 * <p>
 * <h2>Table Of Contents</h2>
 * <p>
 * <ul>
 * <li><a href="#application">Application</a></li>
 * <li><a href="#application-associator">Application-Associator</a></li>
 * <li><a href="#attribute-group">Attribute-Group</a></li>
 * <li><a href="#associations">Associations</a>
 * <p>
 * <ul>
 * <li><a href="#attribute-group-association">Associating application with an attribute group</a></li>
 * <li><a href="#resource-association">Associating application with a stack</a></li>
 * </ul></li>
 * <li><a href="#sharing">Sharing</a>
 * <p>
 * <ul>
 * <li><a href="#sharing-an-application">Sharing an application</a></li>
 * <li><a href="#sharing-an-attribute-group">Sharing an attribute group</a></li>
 * </ul></li>
 * </ul>
 * <p>
 * The <code>&#64;aws-cdk/aws-servicecatalogappregistry</code> package contains resources that enable users to automate governance and management of their AWS resources at scale.
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.servicecatalogappregistry.alpha.*;
 * </pre></blockquote>
 * <p>
 * <h2>Application</h2>
 * <p>
 * An AppRegistry application enables you to define your applications and associated resources.
 * The application name must be unique at the account level and it's immutable.
 * <p>
 * <blockquote><pre>
 * Application application = Application.Builder.create(this, "MyFirstApplication")
 *         .applicationName("MyFirstApplicationName")
 *         .description("description for my application")
 *         .build();
 * </pre></blockquote>
 * <p>
 * An application that has been created outside of the stack can be imported into your CDK app.
 * Applications can be imported by their ARN via the <code>Application.fromApplicationArn()</code> API:
 * <p>
 * <blockquote><pre>
 * IApplication importedApplication = Application.fromApplicationArn(this, "MyImportedApplication", "arn:aws:servicecatalog:us-east-1:012345678910:/applications/0aqmvxvgmry0ecc4mjhwypun6i");
 * </pre></blockquote>
 * <p>
 * <h2>Application-Associator</h2>
 * <p>
 * If you want to create an Application named <code>MyAssociatedApplication</code> in account <code>123456789012</code> and region <code>us-east-1</code>
 * and want to associate all stacks in the <code>App</code> scope to <code>MyAssociatedApplication</code>, then use as shown in the example below:
 * <p>
 * <blockquote><pre>
 * App app = new App();
 * ApplicationAssociator associatedApp = ApplicationAssociator.Builder.create(app, "AssociatedApplication")
 *         .applications(List.of(TargetApplication.createApplicationStack(CreateTargetApplicationOptions.builder()
 *                 .applicationName("MyAssociatedApplication")
 *                 // 'Application containing stacks deployed via CDK.' is the default
 *                 .applicationDescription("Associated Application description")
 *                 .stackName("MyAssociatedApplicationStack")
 *                 // AWS Account and Region that are implied by the current CLI configuration is the default
 *                 .env(Environment.builder().account("123456789012").region("us-east-1").build())
 *                 .build())))
 *         .build();
 * </pre></blockquote>
 * <p>
 * This will create an application <code>MyAssociatedApplication</code> with the <code>TagKey</code> as <code>managedBy</code> and <code>TagValue</code> as <code>CDK_Application_Associator</code>.
 * <p>
 * If you want to re-use an existing Application with ARN: <code>arn:aws:servicecatalog:us-east-1:123456789012:/applications/applicationId</code>
 * and want to associate all stacks in the <code>App</code> scope to your imported application, then use as shown in the example below:
 * <p>
 * <blockquote><pre>
 * App app = new App();
 * ApplicationAssociator associatedApp = ApplicationAssociator.Builder.create(app, "AssociatedApplication")
 *         .applications(List.of(TargetApplication.existingApplicationFromArn(ExistingTargetApplicationOptions.builder()
 *                 .applicationArnValue("arn:aws:servicecatalog:us-east-1:123456789012:/applications/applicationId")
 *                 .stackName("MyAssociatedApplicationStack")
 *                 .build())))
 *         .build();
 * </pre></blockquote>
 * <p>
 * If you are using CDK Pipelines to deploy your application, the application stacks will be inside Stages, and
 * ApplicationAssociator will not be able to find them. Call <code>associateStage</code> on each Stage object before adding it to the
 * Pipeline, as shown in the example below:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.pipelines.*;
 * import software.amazon.awscdk.services.codecommit.*;
 * Repository repo;
 * CodePipeline pipeline;
 * Stage beta;
 * 
 * public class ApplicationPipelineStack extends Stack {
 *     public ApplicationPipelineStack(App scope, String id, ApplicationPipelineStackProps props) {
 *         super(scope, id, props);
 * 
 *         //associate the stage to application associator.
 *         props.application.associateStage(beta);
 *         pipeline.addStage(beta);
 *     }
 * }
 * 
 * public class ApplicationPipelineStackProps extends StackProps {
 *     private ApplicationAssociator application;
 *     public ApplicationAssociator getApplication() {
 *         return this.application;
 *     }
 *     public ApplicationPipelineStackProps application(ApplicationAssociator application) {
 *         this.application = application;
 *         return this;
 *     }
 * }
 * 
 * App app = new App();
 * ApplicationAssociator associatedApp = ApplicationAssociator.Builder.create(app, "AssociatedApplication")
 *         .applications(List.of(TargetApplication.createApplicationStack(CreateTargetApplicationOptions.builder()
 *                 .applicationName("MyPipelineAssociatedApplication")
 *                 .stackName("MyPipelineAssociatedApplicationStack")
 *                 .env(Environment.builder().account("123456789012").region("us-east-1").build())
 *                 .build())))
 *         .build();
 * 
 * ApplicationPipelineStack cdkPipeline = new ApplicationPipelineStack(app, "CDKApplicationPipelineStack", new ApplicationPipelineStackProps()
 *         .application(associatedApp)
 *         .env(Environment.builder().account("123456789012").region("us-east-1").build())
 *         );
 * </pre></blockquote>
 * <p>
 * <h2>Attribute Group</h2>
 * <p>
 * An AppRegistry attribute group acts as a container for user-defined attributes for an application.
 * Metadata is attached in a machine-readable format to integrate with automated workflows and tools.
 * <p>
 * <blockquote><pre>
 * AttributeGroup attributeGroup = AttributeGroup.Builder.create(this, "MyFirstAttributeGroup")
 *         .attributeGroupName("MyFirstAttributeGroupName")
 *         .description("description for my attribute group") // the description is optional,
 *         .attributes(Map.of(
 *                 "project", "foo",
 *                 "team", List.of("member1", "member2", "member3"),
 *                 "public", false,
 *                 "stages", Map.of(
 *                         "alpha", "complete",
 *                         "beta", "incomplete",
 *                         "release", "not started")))
 *         .build();
 * </pre></blockquote>
 * <p>
 * An attribute group that has been created outside of the stack can be imported into your CDK app.
 * Attribute groups can be imported by their ARN via the <code>AttributeGroup.fromAttributeGroupArn()</code> API:
 * <p>
 * <blockquote><pre>
 * IAttributeGroup importedAttributeGroup = AttributeGroup.fromAttributeGroupArn(this, "MyImportedAttrGroup", "arn:aws:servicecatalog:us-east-1:012345678910:/attribute-groups/0aqmvxvgmry0ecc4mjhwypun6i");
 * </pre></blockquote>
 * <p>
 * <h2>Associations</h2>
 * <p>
 * You can associate your appregistry application with attribute groups and resources.
 * Resources are CloudFormation stacks that you can associate with an application to group relevant
 * stacks together to enable metadata rich insights into your applications and resources.
 * A Cloudformation stack can only be associated with one appregistry application.
 * If a stack is associated with multiple applications in your app or is already associated with one,
 * CDK will fail at deploy time.
 * <p>
 * <h3>Associating application with an attribute group</h3>
 * <p>
 * You can associate an attribute group with an application with the <code>associateAttributeGroup()</code> API:
 * <p>
 * <blockquote><pre>
 * Application application;
 * AttributeGroup attributeGroup;
 * 
 * application.associateAttributeGroup(attributeGroup);
 * </pre></blockquote>
 * <p>
 * <h3>Associating application with a Stack</h3>
 * <p>
 * You can associate a stack with an application with the <code>associateStack()</code> API:
 * <p>
 * <blockquote><pre>
 * Application application;
 * App app = new App();
 * Stack myStack = new Stack(app, "MyStack");
 * application.associateStack(myStack);
 * </pre></blockquote>
 * <p>
 * <h2>Sharing</h2>
 * <p>
 * You can share your AppRegistry applications and attribute groups with AWS Organizations, Organizational Units (OUs), AWS accounts within an organization, as well as IAM roles and users. AppRegistry requires that AWS Organizations is enabled in an account before deploying a share of an application or attribute group.
 * <p>
 * <h3>Sharing an application</h3>
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.iam.*;
 * Application application;
 * IRole myRole;
 * IUser myUser;
 * 
 * application.shareApplication(ShareOptions.builder()
 *         .accounts(List.of("123456789012"))
 *         .organizationArns(List.of("arn:aws:organizations::123456789012:organization/o-my-org-id"))
 *         .roles(List.of(myRole))
 *         .users(List.of(myUser))
 *         .build());
 * </pre></blockquote>
 * <p>
 * E.g., sharing an application with multiple accounts and allowing the accounts to associate resources to the application.
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.iam.*;
 * Application application;
 * 
 * application.shareApplication(ShareOptions.builder()
 *         .accounts(List.of("123456789012", "234567890123"))
 *         .sharePermission(SharePermission.ALLOW_ACCESS)
 *         .build());
 * </pre></blockquote>
 * <p>
 * <h3>Sharing an attribute group</h3>
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.iam.*;
 * AttributeGroup attributeGroup;
 * IRole myRole;
 * IUser myUser;
 * 
 * attributeGroup.shareAttributeGroup(ShareOptions.builder()
 *         .accounts(List.of("123456789012"))
 *         .organizationArns(List.of("arn:aws:organizations::123456789012:organization/o-my-org-id"))
 *         .roles(List.of(myRole))
 *         .users(List.of(myUser))
 *         .build());
 * </pre></blockquote>
 * <p>
 * E.g., sharing an application with multiple accounts and allowing the accounts to associate applications to the attribute group.
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.iam.*;
 * AttributeGroup attributeGroup;
 * 
 * attributeGroup.shareAttributeGroup(ShareOptions.builder()
 *         .accounts(List.of("123456789012", "234567890123"))
 *         .sharePermission(SharePermission.ALLOW_ACCESS)
 *         .build());
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.servicecatalogappregistry.alpha;
