package software.amazon.awscdk.services.servicecatalogappregistry.alpha;

/**
 * (experimental) Properties used to define targetapplication.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicecatalogappregistry.alpha.*;
 * import software.amazon.awscdk.*;
 * PermissionsBoundary permissionsBoundary;
 * StackSynthesizer stackSynthesizer;
 * TargetApplicationCommonOptions targetApplicationCommonOptions = TargetApplicationCommonOptions.builder()
 *         .analyticsReporting(false)
 *         .crossRegionReferences(false)
 *         .description("description")
 *         .env(Environment.builder()
 *                 .account("account")
 *                 .region("region")
 *                 .build())
 *         .permissionsBoundary(permissionsBoundary)
 *         .stackId("stackId")
 *         .stackName("stackName")
 *         .synthesizer(stackSynthesizer)
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .terminationProtection(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-14T20:14:31.390Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalogappregistry.alpha.$Module.class, fqn = "@aws-cdk/aws-servicecatalogappregistry-alpha.TargetApplicationCommonOptions")
@software.amazon.jsii.Jsii.Proxy(TargetApplicationCommonOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface TargetApplicationCommonOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.StackProps {

    /**
     * (experimental) Stack ID in which application will be created or imported.
     * <p>
     * The id of a stack is also the identifier that you use to
     * refer to it in the {&#64;link https://docs.aws.amazon.com/cdk/v2/guide/cli.html | AWS CDK Toolkit (cdk command)}.
     * <p>
     * Default: - ApplicationAssociatorStack
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getStackId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TargetApplicationCommonOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TargetApplicationCommonOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<TargetApplicationCommonOptions> {
        java.lang.String stackId;
        java.lang.Boolean analyticsReporting;
        java.lang.Boolean crossRegionReferences;
        java.lang.String description;
        software.amazon.awscdk.Environment env;
        software.amazon.awscdk.PermissionsBoundary permissionsBoundary;
        java.lang.String stackName;
        software.amazon.awscdk.IStackSynthesizer synthesizer;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.Boolean terminationProtection;

        /**
         * Sets the value of {@link TargetApplicationCommonOptions#getStackId}
         * @param stackId Stack ID in which application will be created or imported.
         *                The id of a stack is also the identifier that you use to
         *                refer to it in the {&#64;link https://docs.aws.amazon.com/cdk/v2/guide/cli.html | AWS CDK Toolkit (cdk command)}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stackId(java.lang.String stackId) {
            this.stackId = stackId;
            return this;
        }

        /**
         * Sets the value of {@link TargetApplicationCommonOptions#getAnalyticsReporting}
         * @param analyticsReporting Include runtime versioning information in this Stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsReporting(java.lang.Boolean analyticsReporting) {
            this.analyticsReporting = analyticsReporting;
            return this;
        }

        /**
         * Sets the value of {@link TargetApplicationCommonOptions#getCrossRegionReferences}
         * @param crossRegionReferences Enable this flag to allow native cross region stack references.
         *                              Enabling this will create a CloudFormation custom resource
         *                              in both the producing stack and consuming stack in order to perform the export/import
         *                              <p>
         *                              This feature is currently experimental
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossRegionReferences(java.lang.Boolean crossRegionReferences) {
            this.crossRegionReferences = crossRegionReferences;
            return this;
        }

        /**
         * Sets the value of {@link TargetApplicationCommonOptions#getDescription}
         * @param description A description of the stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link TargetApplicationCommonOptions#getEnv}
         * @param env The AWS environment (account/region) where this stack will be deployed.
         *            Set the <code>region</code>/<code>account</code> fields of <code>env</code> to either a concrete value to
         *            select the indicated environment (recommended for production stacks), or to
         *            the values of environment variables
         *            <code>CDK_DEFAULT_REGION</code>/<code>CDK_DEFAULT_ACCOUNT</code> to let the target environment
         *            depend on the AWS credentials/configuration that the CDK CLI is executed
         *            under (recommended for development stacks).
         *            <p>
         *            If the <code>Stack</code> is instantiated inside a <code>Stage</code>, any undefined
         *            <code>region</code>/<code>account</code> fields from <code>env</code> will default to the same field on the
         *            encompassing <code>Stage</code>, if configured there.
         *            <p>
         *            If either <code>region</code> or <code>account</code> are not set nor inherited from <code>Stage</code>, the
         *            Stack will be considered "<em>environment-agnostic</em>"". Environment-agnostic
         *            stacks can be deployed to any environment but may not be able to take
         *            advantage of all features of the CDK. For example, they will not be able to
         *            use environmental context lookups such as <code>ec2.Vpc.fromLookup</code> and will not
         *            automatically translate Service Principals to the right format based on the
         *            environment's AWS partition, and other such enhancements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(software.amazon.awscdk.Environment env) {
            this.env = env;
            return this;
        }

        /**
         * Sets the value of {@link TargetApplicationCommonOptions#getPermissionsBoundary}
         * @param permissionsBoundary Options for applying a permissions boundary to all IAM Roles and Users created within this Stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsBoundary(software.amazon.awscdk.PermissionsBoundary permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        /**
         * Sets the value of {@link TargetApplicationCommonOptions#getStackName}
         * @param stackName Name to deploy the stack with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackName(java.lang.String stackName) {
            this.stackName = stackName;
            return this;
        }

        /**
         * Sets the value of {@link TargetApplicationCommonOptions#getSynthesizer}
         * @param synthesizer Synthesis method to use while deploying this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder synthesizer(software.amazon.awscdk.IStackSynthesizer synthesizer) {
            this.synthesizer = synthesizer;
            return this;
        }

        /**
         * Sets the value of {@link TargetApplicationCommonOptions#getTags}
         * @param tags Stack tags that will be applied to all the taggable resources and the stack itself.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link TargetApplicationCommonOptions#getTerminationProtection}
         * @param terminationProtection Whether to enable termination protection for this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtection(java.lang.Boolean terminationProtection) {
            this.terminationProtection = terminationProtection;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TargetApplicationCommonOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public TargetApplicationCommonOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TargetApplicationCommonOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetApplicationCommonOptions {
        private final java.lang.String stackId;
        private final java.lang.Boolean analyticsReporting;
        private final java.lang.Boolean crossRegionReferences;
        private final java.lang.String description;
        private final software.amazon.awscdk.Environment env;
        private final software.amazon.awscdk.PermissionsBoundary permissionsBoundary;
        private final java.lang.String stackName;
        private final software.amazon.awscdk.IStackSynthesizer synthesizer;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Boolean terminationProtection;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stackId = software.amazon.jsii.Kernel.get(this, "stackId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.analyticsReporting = software.amazon.jsii.Kernel.get(this, "analyticsReporting", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.crossRegionReferences = software.amazon.jsii.Kernel.get(this, "crossRegionReferences", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Environment.class));
            this.permissionsBoundary = software.amazon.jsii.Kernel.get(this, "permissionsBoundary", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.PermissionsBoundary.class));
            this.stackName = software.amazon.jsii.Kernel.get(this, "stackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.synthesizer = software.amazon.jsii.Kernel.get(this, "synthesizer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IStackSynthesizer.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.terminationProtection = software.amazon.jsii.Kernel.get(this, "terminationProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stackId = builder.stackId;
            this.analyticsReporting = builder.analyticsReporting;
            this.crossRegionReferences = builder.crossRegionReferences;
            this.description = builder.description;
            this.env = builder.env;
            this.permissionsBoundary = builder.permissionsBoundary;
            this.stackName = builder.stackName;
            this.synthesizer = builder.synthesizer;
            this.tags = builder.tags;
            this.terminationProtection = builder.terminationProtection;
        }

        @Override
        public final java.lang.String getStackId() {
            return this.stackId;
        }

        @Override
        public final java.lang.Boolean getAnalyticsReporting() {
            return this.analyticsReporting;
        }

        @Override
        public final java.lang.Boolean getCrossRegionReferences() {
            return this.crossRegionReferences;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.Environment getEnv() {
            return this.env;
        }

        @Override
        public final software.amazon.awscdk.PermissionsBoundary getPermissionsBoundary() {
            return this.permissionsBoundary;
        }

        @Override
        public final java.lang.String getStackName() {
            return this.stackName;
        }

        @Override
        public final software.amazon.awscdk.IStackSynthesizer getSynthesizer() {
            return this.synthesizer;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Boolean getTerminationProtection() {
            return this.terminationProtection;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getStackId() != null) {
                data.set("stackId", om.valueToTree(this.getStackId()));
            }
            if (this.getAnalyticsReporting() != null) {
                data.set("analyticsReporting", om.valueToTree(this.getAnalyticsReporting()));
            }
            if (this.getCrossRegionReferences() != null) {
                data.set("crossRegionReferences", om.valueToTree(this.getCrossRegionReferences()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getPermissionsBoundary() != null) {
                data.set("permissionsBoundary", om.valueToTree(this.getPermissionsBoundary()));
            }
            if (this.getStackName() != null) {
                data.set("stackName", om.valueToTree(this.getStackName()));
            }
            if (this.getSynthesizer() != null) {
                data.set("synthesizer", om.valueToTree(this.getSynthesizer()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTerminationProtection() != null) {
                data.set("terminationProtection", om.valueToTree(this.getTerminationProtection()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicecatalogappregistry-alpha.TargetApplicationCommonOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TargetApplicationCommonOptions.Jsii$Proxy that = (TargetApplicationCommonOptions.Jsii$Proxy) o;

            if (this.stackId != null ? !this.stackId.equals(that.stackId) : that.stackId != null) return false;
            if (this.analyticsReporting != null ? !this.analyticsReporting.equals(that.analyticsReporting) : that.analyticsReporting != null) return false;
            if (this.crossRegionReferences != null ? !this.crossRegionReferences.equals(that.crossRegionReferences) : that.crossRegionReferences != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.permissionsBoundary != null ? !this.permissionsBoundary.equals(that.permissionsBoundary) : that.permissionsBoundary != null) return false;
            if (this.stackName != null ? !this.stackName.equals(that.stackName) : that.stackName != null) return false;
            if (this.synthesizer != null ? !this.synthesizer.equals(that.synthesizer) : that.synthesizer != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.terminationProtection != null ? this.terminationProtection.equals(that.terminationProtection) : that.terminationProtection == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stackId != null ? this.stackId.hashCode() : 0;
            result = 31 * result + (this.analyticsReporting != null ? this.analyticsReporting.hashCode() : 0);
            result = 31 * result + (this.crossRegionReferences != null ? this.crossRegionReferences.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
            result = 31 * result + (this.permissionsBoundary != null ? this.permissionsBoundary.hashCode() : 0);
            result = 31 * result + (this.stackName != null ? this.stackName.hashCode() : 0);
            result = 31 * result + (this.synthesizer != null ? this.synthesizer.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.terminationProtection != null ? this.terminationProtection.hashCode() : 0);
            return result;
        }
    }
}
