package software.amazon.awscdk.services.servicecatalogappregistry.alpha;

/**
 * (experimental) The options that are passed into a share of an Application or Attribute Group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.iam.*;
 * Application application;
 * IRole myRole;
 * IUser myUser;
 * application.shareApplication(ShareOptions.builder()
 *         .accounts(List.of("123456789012"))
 *         .organizationArns(List.of("arn:aws:organizations::123456789012:organization/o-my-org-id"))
 *         .roles(List.of(myRole))
 *         .users(List.of(myUser))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-29T04:51:28.556Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalogappregistry.alpha.$Module.class, fqn = "@aws-cdk/aws-servicecatalogappregistry-alpha.ShareOptions")
@software.amazon.jsii.Jsii.Proxy(ShareOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ShareOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) A list of AWS accounts that the application will be shared with.
     * <p>
     * Default: - No accounts specified for share
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAccounts() {
        return null;
    }

    /**
     * (experimental) A list of AWS Organization or Organizational Units (OUs) ARNs that the application will be shared with.
     * <p>
     * Default: - No AWS Organizations or OUs specified for share
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOrganizationArns() {
        return null;
    }

    /**
     * (experimental) A list of AWS IAM roles that the application will be shared with.
     * <p>
     * Default: - No IAM roles specified for share
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.IRole> getRoles() {
        return null;
    }

    /**
     * (experimental) An option to manage access to the application or attribute group.
     * <p>
     * Default: - Principals will be assigned read only permissions on the application or attribute group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSharePermission() {
        return null;
    }

    /**
     * (experimental) A list of AWS IAM users that the application will be shared with.
     * <p>
     * Default: - No IAM Users specified for share
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.IUser> getUsers() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ShareOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ShareOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ShareOptions> {
        java.util.List<java.lang.String> accounts;
        java.util.List<java.lang.String> organizationArns;
        java.util.List<software.amazon.awscdk.services.iam.IRole> roles;
        java.lang.Object sharePermission;
        java.util.List<software.amazon.awscdk.services.iam.IUser> users;

        /**
         * Sets the value of {@link ShareOptions#getAccounts}
         * @param accounts A list of AWS accounts that the application will be shared with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accounts(java.util.List<java.lang.String> accounts) {
            this.accounts = accounts;
            return this;
        }

        /**
         * Sets the value of {@link ShareOptions#getOrganizationArns}
         * @param organizationArns A list of AWS Organization or Organizational Units (OUs) ARNs that the application will be shared with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder organizationArns(java.util.List<java.lang.String> organizationArns) {
            this.organizationArns = organizationArns;
            return this;
        }

        /**
         * Sets the value of {@link ShareOptions#getRoles}
         * @param roles A list of AWS IAM roles that the application will be shared with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder roles(java.util.List<? extends software.amazon.awscdk.services.iam.IRole> roles) {
            this.roles = (java.util.List<software.amazon.awscdk.services.iam.IRole>)roles;
            return this;
        }

        /**
         * Sets the value of {@link ShareOptions#getSharePermission}
         * @param sharePermission An option to manage access to the application or attribute group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sharePermission(java.lang.String sharePermission) {
            this.sharePermission = sharePermission;
            return this;
        }

        /**
         * Sets the value of {@link ShareOptions#getSharePermission}
         * @param sharePermission An option to manage access to the application or attribute group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sharePermission(software.amazon.awscdk.services.servicecatalogappregistry.alpha.SharePermission sharePermission) {
            this.sharePermission = sharePermission;
            return this;
        }

        /**
         * Sets the value of {@link ShareOptions#getUsers}
         * @param users A list of AWS IAM users that the application will be shared with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder users(java.util.List<? extends software.amazon.awscdk.services.iam.IUser> users) {
            this.users = (java.util.List<software.amazon.awscdk.services.iam.IUser>)users;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ShareOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ShareOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ShareOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ShareOptions {
        private final java.util.List<java.lang.String> accounts;
        private final java.util.List<java.lang.String> organizationArns;
        private final java.util.List<software.amazon.awscdk.services.iam.IRole> roles;
        private final java.lang.Object sharePermission;
        private final java.util.List<software.amazon.awscdk.services.iam.IUser> users;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accounts = software.amazon.jsii.Kernel.get(this, "accounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.organizationArns = software.amazon.jsii.Kernel.get(this, "organizationArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.roles = software.amazon.jsii.Kernel.get(this, "roles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class)));
            this.sharePermission = software.amazon.jsii.Kernel.get(this, "sharePermission", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.users = software.amazon.jsii.Kernel.get(this, "users", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IUser.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accounts = builder.accounts;
            this.organizationArns = builder.organizationArns;
            this.roles = (java.util.List<software.amazon.awscdk.services.iam.IRole>)builder.roles;
            this.sharePermission = builder.sharePermission;
            this.users = (java.util.List<software.amazon.awscdk.services.iam.IUser>)builder.users;
        }

        @Override
        public final java.util.List<java.lang.String> getAccounts() {
            return this.accounts;
        }

        @Override
        public final java.util.List<java.lang.String> getOrganizationArns() {
            return this.organizationArns;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.IRole> getRoles() {
            return this.roles;
        }

        @Override
        public final java.lang.Object getSharePermission() {
            return this.sharePermission;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.IUser> getUsers() {
            return this.users;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccounts() != null) {
                data.set("accounts", om.valueToTree(this.getAccounts()));
            }
            if (this.getOrganizationArns() != null) {
                data.set("organizationArns", om.valueToTree(this.getOrganizationArns()));
            }
            if (this.getRoles() != null) {
                data.set("roles", om.valueToTree(this.getRoles()));
            }
            if (this.getSharePermission() != null) {
                data.set("sharePermission", om.valueToTree(this.getSharePermission()));
            }
            if (this.getUsers() != null) {
                data.set("users", om.valueToTree(this.getUsers()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicecatalogappregistry-alpha.ShareOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ShareOptions.Jsii$Proxy that = (ShareOptions.Jsii$Proxy) o;

            if (this.accounts != null ? !this.accounts.equals(that.accounts) : that.accounts != null) return false;
            if (this.organizationArns != null ? !this.organizationArns.equals(that.organizationArns) : that.organizationArns != null) return false;
            if (this.roles != null ? !this.roles.equals(that.roles) : that.roles != null) return false;
            if (this.sharePermission != null ? !this.sharePermission.equals(that.sharePermission) : that.sharePermission != null) return false;
            return this.users != null ? this.users.equals(that.users) : that.users == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accounts != null ? this.accounts.hashCode() : 0;
            result = 31 * result + (this.organizationArns != null ? this.organizationArns.hashCode() : 0);
            result = 31 * result + (this.roles != null ? this.roles.hashCode() : 0);
            result = 31 * result + (this.sharePermission != null ? this.sharePermission.hashCode() : 0);
            result = 31 * result + (this.users != null ? this.users.hashCode() : 0);
            return result;
        }
    }
}
