package software.amazon.awscdk.services.servicecatalogappregistry.alpha;

/**
 * (experimental) Properties for Service Catalog AppRegistry Application Associator.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App app = new App();
 * ApplicationAssociator associatedApp = ApplicationAssociator.Builder.create(app, "AssociatedApplication")
 *         .applications(List.of(TargetApplication.createApplicationStack(CreateTargetApplicationOptions.builder()
 *                 .applicationName("MyAssociatedApplication")
 *                 // 'Application containing stacks deployed via CDK.' is the default
 *                 .applicationDescription("Associated Application description")
 *                 .stackName("MyAssociatedApplicationStack")
 *                 // AWS Account and Region that are implied by the current CLI configuration is the default
 *                 .env(Environment.builder().account("123456789012").region("us-east-1").build())
 *                 .build())))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-29T04:51:28.552Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalogappregistry.alpha.$Module.class, fqn = "@aws-cdk/aws-servicecatalogappregistry-alpha.ApplicationAssociatorProps")
@software.amazon.jsii.Jsii.Proxy(ApplicationAssociatorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ApplicationAssociatorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Application associator properties.
     * <p>
     * Default: - Empty array.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.servicecatalogappregistry.alpha.TargetApplication> getApplications();

    /**
     * @return a {@link Builder} of {@link ApplicationAssociatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationAssociatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ApplicationAssociatorProps> {
        java.util.List<software.amazon.awscdk.services.servicecatalogappregistry.alpha.TargetApplication> applications;

        /**
         * Sets the value of {@link ApplicationAssociatorProps#getApplications}
         * @param applications Application associator properties. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder applications(java.util.List<? extends software.amazon.awscdk.services.servicecatalogappregistry.alpha.TargetApplication> applications) {
            this.applications = (java.util.List<software.amazon.awscdk.services.servicecatalogappregistry.alpha.TargetApplication>)applications;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationAssociatorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ApplicationAssociatorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApplicationAssociatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationAssociatorProps {
        private final java.util.List<software.amazon.awscdk.services.servicecatalogappregistry.alpha.TargetApplication> applications;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applications = software.amazon.jsii.Kernel.get(this, "applications", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalogappregistry.alpha.TargetApplication.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applications = (java.util.List<software.amazon.awscdk.services.servicecatalogappregistry.alpha.TargetApplication>)java.util.Objects.requireNonNull(builder.applications, "applications is required");
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.servicecatalogappregistry.alpha.TargetApplication> getApplications() {
            return this.applications;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applications", om.valueToTree(this.getApplications()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicecatalogappregistry-alpha.ApplicationAssociatorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationAssociatorProps.Jsii$Proxy that = (ApplicationAssociatorProps.Jsii$Proxy) o;

            return this.applications.equals(that.applications);
        }

        @Override
        public final int hashCode() {
            int result = this.applications.hashCode();
            return result;
        }
    }
}
