package software.amazon.awscdk.services.servicecatalogappregistry.alpha;

/**
 * (experimental) Properties for a Service Catalog AppRegistry AutoApplication.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App app = new App();
 * ApplicationAssociator associatedApp = ApplicationAssociator.Builder.create(app, "AssociatedApplication")
 *         .applicationName("MyAssociatedApplication")
 *         .description("Testing associated application")
 *         .stackProps(StackProps.builder()
 *                 .stackName("MyAssociatedApplicationStack")
 *                 .env(Environment.builder().account("123456789012").region("us-east-1").build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.69.0 (build f656c31)", date = "2022-11-01T11:35:07.229Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.servicecatalogappregistry.alpha.$Module.class, fqn = "@aws-cdk/aws-servicecatalogappregistry-alpha.ApplicationAssociatorProps")
@software.amazon.jsii.Jsii.Proxy(ApplicationAssociatorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ApplicationAssociatorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Stack properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.StackProps getStackProps();

    /**
     * (experimental) Enforces a particular application arn.
     * <p>
     * Default: - No application arn.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getApplicationArnValue() {
        return null;
    }

    /**
     * (experimental) Enforces a particular physical application name.
     * <p>
     * Default: - No name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getApplicationName() {
        return null;
    }

    /**
     * (experimental) Application description.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApplicationAssociatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationAssociatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ApplicationAssociatorProps> {
        software.amazon.awscdk.StackProps stackProps;
        java.lang.String applicationArnValue;
        java.lang.String applicationName;
        java.lang.String description;

        /**
         * Sets the value of {@link ApplicationAssociatorProps#getStackProps}
         * @param stackProps Stack properties. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stackProps(software.amazon.awscdk.StackProps stackProps) {
            this.stackProps = stackProps;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationAssociatorProps#getApplicationArnValue}
         * @param applicationArnValue Enforces a particular application arn.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder applicationArnValue(java.lang.String applicationArnValue) {
            this.applicationArnValue = applicationArnValue;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationAssociatorProps#getApplicationName}
         * @param applicationName Enforces a particular physical application name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder applicationName(java.lang.String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationAssociatorProps#getDescription}
         * @param description Application description.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationAssociatorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ApplicationAssociatorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApplicationAssociatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationAssociatorProps {
        private final software.amazon.awscdk.StackProps stackProps;
        private final java.lang.String applicationArnValue;
        private final java.lang.String applicationName;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stackProps = software.amazon.jsii.Kernel.get(this, "stackProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.StackProps.class));
            this.applicationArnValue = software.amazon.jsii.Kernel.get(this, "applicationArnValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.applicationName = software.amazon.jsii.Kernel.get(this, "applicationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stackProps = java.util.Objects.requireNonNull(builder.stackProps, "stackProps is required");
            this.applicationArnValue = builder.applicationArnValue;
            this.applicationName = builder.applicationName;
            this.description = builder.description;
        }

        @Override
        public final software.amazon.awscdk.StackProps getStackProps() {
            return this.stackProps;
        }

        @Override
        public final java.lang.String getApplicationArnValue() {
            return this.applicationArnValue;
        }

        @Override
        public final java.lang.String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stackProps", om.valueToTree(this.getStackProps()));
            if (this.getApplicationArnValue() != null) {
                data.set("applicationArnValue", om.valueToTree(this.getApplicationArnValue()));
            }
            if (this.getApplicationName() != null) {
                data.set("applicationName", om.valueToTree(this.getApplicationName()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-servicecatalogappregistry-alpha.ApplicationAssociatorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationAssociatorProps.Jsii$Proxy that = (ApplicationAssociatorProps.Jsii$Proxy) o;

            if (!stackProps.equals(that.stackProps)) return false;
            if (this.applicationArnValue != null ? !this.applicationArnValue.equals(that.applicationArnValue) : that.applicationArnValue != null) return false;
            if (this.applicationName != null ? !this.applicationName.equals(that.applicationName) : that.applicationName != null) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stackProps.hashCode();
            result = 31 * result + (this.applicationArnValue != null ? this.applicationArnValue.hashCode() : 0);
            result = 31 * result + (this.applicationName != null ? this.applicationName.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
