/**
 * <h1>AWS ServiceCatalogAppRegistry Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Experimental" src="https://img.shields.io/badge/cdk--constructs-experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * The APIs of higher level constructs in this module are experimental and under active development.
 * They are subject to non-backward compatible changes or removal in any future version. These are
 * not subject to the <a href="https://semver.org/">Semantic Versioning</a> model and breaking changes will be
 * announced in the release notes. This means that while you may use them, you may need to update
 * your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/appregistry.html">AWS Service Catalog App Registry</a>
 * enables organizations to create and manage repositores of applications and associated resources.
 * <p>
 * <h2>Table Of Contents</h2>
 * <p>
 * <ul>
 * <li><a href="#application">Application</a></li>
 * <li><a href="#attribute-group">Attribute-Group</a></li>
 * <li><a href="#associations">Associations</a>
 * <p>
 * <ul>
 * <li><a href="#attribute-group-association">Associating application with an attribute group</a></li>
 * <li><a href="#resource-association">Associating application with a stack</a></li>
 * </ul></li>
 * </ul>
 * <p>
 * The <code>&#64;aws-cdk/aws-servicecatalogappregistry</code> package contains resources that enable users to automate governance and management of their AWS resources at scale.
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.servicecatalogappregistry.alpha.*;
 * </pre></blockquote>
 * <p>
 * <h2>Application</h2>
 * <p>
 * An AppRegistry application enables you to define your applications and associated resources.
 * The application name must be unique at the account level, but is mutable.
 * <p>
 * <blockquote><pre>
 * Application application = Application.Builder.create(this, "MyFirstApplication")
 *         .applicationName("MyFirstApplicationName")
 *         .description("description for my application")
 *         .build();
 * </pre></blockquote>
 * <p>
 * An application that has been created outside of the stack can be imported into your CDK app.
 * Applications can be imported by their ARN via the <code>Application.fromApplicationArn()</code> API:
 * <p>
 * <blockquote><pre>
 * IApplication importedApplication = Application.fromApplicationArn(this, "MyImportedApplication", "arn:aws:servicecatalog:us-east-1:012345678910:/applications/0aqmvxvgmry0ecc4mjhwypun6i");
 * </pre></blockquote>
 * <p>
 * <h2>Attribute Group</h2>
 * <p>
 * An AppRegistry attribute group acts as a container for user-defined attributes for an application.
 * Metadata is attached in a machine-readble format to integrate with automated workflows and tools.
 * <p>
 * <blockquote><pre>
 * AttributeGroup attributeGroup = AttributeGroup.Builder.create(this, "MyFirstAttributeGroup")
 *         .attributeGroupName("MyFirstAttributeGroupName")
 *         .description("description for my attribute group") // the description is optional,
 *         .attributes(Map.of(
 *                 "project", "foo",
 *                 "team", List.of("member1", "member2", "member3"),
 *                 "public", false,
 *                 "stages", Map.of(
 *                         "alpha", "complete",
 *                         "beta", "incomplete",
 *                         "release", "not started")))
 *         .build();
 * </pre></blockquote>
 * <p>
 * An attribute group that has been created outside of the stack can be imported into your CDK app.
 * Attribute groups can be imported by their ARN via the <code>AttributeGroup.fromAttributeGroupArn()</code> API:
 * <p>
 * <blockquote><pre>
 * IAttributeGroup importedAttributeGroup = AttributeGroup.fromAttributeGroupArn(this, "MyImportedAttrGroup", "arn:aws:servicecatalog:us-east-1:012345678910:/attribute-groups/0aqmvxvgmry0ecc4mjhwypun6i");
 * </pre></blockquote>
 * <p>
 * <h2>Associations</h2>
 * <p>
 * You can associate your appregistry application with attribute groups and resources.
 * Resources are CloudFormation stacks that you can associate with an application to group relevant
 * stacks together to enable metadata rich insights into your applications and resources.
 * A Cloudformation stack can only be associated with one appregistry application.
 * If a stack is associated with multiple applications in your app or is already associated with one,
 * CDK will fail at deploy time.
 * <p>
 * <h3>Associating application with an attribute group</h3>
 * <p>
 * You can associate an attribute group with an application with the <code>associateAttributeGroup()</code> API:
 * <p>
 * <blockquote><pre>
 * Application application;
 * AttributeGroup attributeGroup;
 * 
 * application.associateAttributeGroup(attributeGroup);
 * </pre></blockquote>
 * <p>
 * <h3>Associating application with a Stack</h3>
 * <p>
 * You can associate a stack with an application with the <code>associateStack()</code> API:
 * <p>
 * <blockquote><pre>
 * Application application;
 * App app = new App();
 * Stack myStack = new Stack(app, "MyStack");
 * application.associateStack(myStack);
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.servicecatalogappregistry.alpha;
