/**
 * <h1>Route53 Patterns for the CDK Route53 Library</h1>
 * <!-- raw HTML omitted -->
 * <hr />
 * <p><img src="https://img.shields.io/badge/stability-Experimental-important.svg?style=for-the-badge" alt="Stability: Experimental" /></p>
 * <blockquote>
 * <p><strong>This is a <em>developer preview</em> (public beta) module. Releases might lack important features and might have
 * future breaking changes.</strong></p>
 * <p>This API is still under active development and subject to non-backward
 * compatible changes or removal in any future version. Use of the API is not recommended in production
 * environments. Experimental APIs are not subject to the Semantic Versioning model.</p>
 * </blockquote>
 * <hr />
 * <!-- raw HTML omitted -->
 * <p>This library contains commonly used patterns for Route53.</p>
 * <h2>HTTPS Redirect</h2>
 * <p>This construct allows creating a simple domainA -&gt; domainB redirect using CloudFront and S3. You can specify multiple domains to be redirected.</p>
 * <pre><code class="language-ts">new HttpsRedirect(stack, 'Redirect', {
 *   recordNames: ['foo.example.com'],
 *   targetDomain: 'bar.example.com',
 *   zone: HostedZone.fromHostedZoneAttributes(stack, 'HostedZone', {
 *     hostedZoneId: 'ID',
 *     zoneName: 'example.com',
 *   })
 * });
 * </code></pre>
 * <p>See the documentation of <code>@aws-cdk/aws-route53-patterns</code> for more information.</p>
 * 
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.route53.patterns;
