package software.amazon.awscdk.services.kinesisanalytics;

/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationOutput`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.4 (build 96d89e1)", date = "2019-11-12T11:54:40.537Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesisanalytics.$Module.class, fqn = "@aws-cdk/aws-kinesisanalytics.CfnApplicationOutput")
public class CfnApplicationOutput extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnApplicationOutput(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplicationOutput(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::KinesisAnalytics::ApplicationOutput`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnApplicationOutput(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutputProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * 
     * EXPERIMENTAL
     * 
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", Void.class, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::KinesisAnalytics::ApplicationOutput.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html#cfn-kinesisanalytics-applicationoutput-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getApplicationName() {
        return this.jsiiGet("applicationName", java.lang.String.class);
    }

    /**
     * `AWS::KinesisAnalytics::ApplicationOutput.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html#cfn-kinesisanalytics-applicationoutput-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApplicationName(final java.lang.String value) {
        this.jsiiSet("applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
    }

    /**
     * `AWS::KinesisAnalytics::ApplicationOutput.Output`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html#cfn-kinesisanalytics-applicationoutput-output
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getOutput() {
        return this.jsiiGet("output", java.lang.Object.class);
    }

    /**
     * `AWS::KinesisAnalytics::ApplicationOutput.Output`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html#cfn-kinesisanalytics-applicationoutput-output
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setOutput(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("output", java.util.Objects.requireNonNull(value, "output is required"));
    }

    /**
     * `AWS::KinesisAnalytics::ApplicationOutput.Output`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html#cfn-kinesisanalytics-applicationoutput-output
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setOutput(final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput.OutputProperty value) {
        this.jsiiSet("output", java.util.Objects.requireNonNull(value, "output is required"));
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-destinationschema.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesisanalytics.$Module.class, fqn = "@aws-cdk/aws-kinesisanalytics.CfnApplicationOutput.DestinationSchemaProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationSchemaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface DestinationSchemaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationOutput.DestinationSchemaProperty.RecordFormatType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-destinationschema.html#cfn-kinesisanalytics-applicationoutput-destinationschema-recordformattype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getRecordFormatType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DestinationSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String recordFormatType;

            /**
             * Sets the value of RecordFormatType
             * @param recordFormatType `CfnApplicationOutput.DestinationSchemaProperty.RecordFormatType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder recordFormatType(java.lang.String recordFormatType) {
                this.recordFormatType = recordFormatType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationSchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public DestinationSchemaProperty build() {
                return new Jsii$Proxy(recordFormatType);
            }
        }

        /**
         * An implementation for {@link DestinationSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationSchemaProperty {
            private final java.lang.String recordFormatType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recordFormatType = this.jsiiGet("recordFormatType", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String recordFormatType) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordFormatType = recordFormatType;
            }

            @Override
            public java.lang.String getRecordFormatType() {
                return this.recordFormatType;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRecordFormatType() != null) {
                    data.set("recordFormatType", om.valueToTree(this.getRecordFormatType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-kinesisanalytics.CfnApplicationOutput.DestinationSchemaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationSchemaProperty.Jsii$Proxy that = (DestinationSchemaProperty.Jsii$Proxy) o;

                return this.recordFormatType != null ? this.recordFormatType.equals(that.recordFormatType) : that.recordFormatType == null;
            }

            @Override
            public int hashCode() {
                int result = this.recordFormatType != null ? this.recordFormatType.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-kinesisfirehoseoutput.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesisanalytics.$Module.class, fqn = "@aws-cdk/aws-kinesisanalytics.CfnApplicationOutput.KinesisFirehoseOutputProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisFirehoseOutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface KinesisFirehoseOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationOutput.KinesisFirehoseOutputProperty.ResourceARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-kinesisfirehoseoutput.html#cfn-kinesisanalytics-applicationoutput-kinesisfirehoseoutput-resourcearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getResourceArn();

        /**
         * `CfnApplicationOutput.KinesisFirehoseOutputProperty.RoleARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-kinesisfirehoseoutput.html#cfn-kinesisanalytics-applicationoutput-kinesisfirehoseoutput-rolearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link KinesisFirehoseOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisFirehoseOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String resourceArn;
            private java.lang.String roleArn;

            /**
             * Sets the value of ResourceArn
             * @param resourceArn `CfnApplicationOutput.KinesisFirehoseOutputProperty.ResourceARN`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Sets the value of RoleArn
             * @param roleArn `CfnApplicationOutput.KinesisFirehoseOutputProperty.RoleARN`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisFirehoseOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public KinesisFirehoseOutputProperty build() {
                return new Jsii$Proxy(resourceArn, roleArn);
            }
        }

        /**
         * An implementation for {@link KinesisFirehoseOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisFirehoseOutputProperty {
            private final java.lang.String resourceArn;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceArn = this.jsiiGet("resourceArn", java.lang.String.class);
                this.roleArn = this.jsiiGet("roleArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String resourceArn, final java.lang.String roleArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceArn = java.util.Objects.requireNonNull(resourceArn, "resourceArn is required");
                this.roleArn = java.util.Objects.requireNonNull(roleArn, "roleArn is required");
            }

            @Override
            public java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            public java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceArn", om.valueToTree(this.getResourceArn()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-kinesisanalytics.CfnApplicationOutput.KinesisFirehoseOutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisFirehoseOutputProperty.Jsii$Proxy that = (KinesisFirehoseOutputProperty.Jsii$Proxy) o;

                if (!resourceArn.equals(that.resourceArn)) return false;
                return this.roleArn.equals(that.roleArn);
            }

            @Override
            public int hashCode() {
                int result = this.resourceArn.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-kinesisstreamsoutput.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesisanalytics.$Module.class, fqn = "@aws-cdk/aws-kinesisanalytics.CfnApplicationOutput.KinesisStreamsOutputProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisStreamsOutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface KinesisStreamsOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationOutput.KinesisStreamsOutputProperty.ResourceARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-kinesisstreamsoutput.html#cfn-kinesisanalytics-applicationoutput-kinesisstreamsoutput-resourcearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getResourceArn();

        /**
         * `CfnApplicationOutput.KinesisStreamsOutputProperty.RoleARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-kinesisstreamsoutput.html#cfn-kinesisanalytics-applicationoutput-kinesisstreamsoutput-rolearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link KinesisStreamsOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisStreamsOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String resourceArn;
            private java.lang.String roleArn;

            /**
             * Sets the value of ResourceArn
             * @param resourceArn `CfnApplicationOutput.KinesisStreamsOutputProperty.ResourceARN`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Sets the value of RoleArn
             * @param roleArn `CfnApplicationOutput.KinesisStreamsOutputProperty.RoleARN`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisStreamsOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public KinesisStreamsOutputProperty build() {
                return new Jsii$Proxy(resourceArn, roleArn);
            }
        }

        /**
         * An implementation for {@link KinesisStreamsOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisStreamsOutputProperty {
            private final java.lang.String resourceArn;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceArn = this.jsiiGet("resourceArn", java.lang.String.class);
                this.roleArn = this.jsiiGet("roleArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String resourceArn, final java.lang.String roleArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceArn = java.util.Objects.requireNonNull(resourceArn, "resourceArn is required");
                this.roleArn = java.util.Objects.requireNonNull(roleArn, "roleArn is required");
            }

            @Override
            public java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            public java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceArn", om.valueToTree(this.getResourceArn()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-kinesisanalytics.CfnApplicationOutput.KinesisStreamsOutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisStreamsOutputProperty.Jsii$Proxy that = (KinesisStreamsOutputProperty.Jsii$Proxy) o;

                if (!resourceArn.equals(that.resourceArn)) return false;
                return this.roleArn.equals(that.roleArn);
            }

            @Override
            public int hashCode() {
                int result = this.resourceArn.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-lambdaoutput.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesisanalytics.$Module.class, fqn = "@aws-cdk/aws-kinesisanalytics.CfnApplicationOutput.LambdaOutputProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaOutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LambdaOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationOutput.LambdaOutputProperty.ResourceARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-lambdaoutput.html#cfn-kinesisanalytics-applicationoutput-lambdaoutput-resourcearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getResourceArn();

        /**
         * `CfnApplicationOutput.LambdaOutputProperty.RoleARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-lambdaoutput.html#cfn-kinesisanalytics-applicationoutput-lambdaoutput-rolearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link LambdaOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String resourceArn;
            private java.lang.String roleArn;

            /**
             * Sets the value of ResourceArn
             * @param resourceArn `CfnApplicationOutput.LambdaOutputProperty.ResourceARN`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Sets the value of RoleArn
             * @param roleArn `CfnApplicationOutput.LambdaOutputProperty.RoleARN`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LambdaOutputProperty build() {
                return new Jsii$Proxy(resourceArn, roleArn);
            }
        }

        /**
         * An implementation for {@link LambdaOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaOutputProperty {
            private final java.lang.String resourceArn;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceArn = this.jsiiGet("resourceArn", java.lang.String.class);
                this.roleArn = this.jsiiGet("roleArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String resourceArn, final java.lang.String roleArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceArn = java.util.Objects.requireNonNull(resourceArn, "resourceArn is required");
                this.roleArn = java.util.Objects.requireNonNull(roleArn, "roleArn is required");
            }

            @Override
            public java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            public java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceArn", om.valueToTree(this.getResourceArn()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-kinesisanalytics.CfnApplicationOutput.LambdaOutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaOutputProperty.Jsii$Proxy that = (LambdaOutputProperty.Jsii$Proxy) o;

                if (!resourceArn.equals(that.resourceArn)) return false;
                return this.roleArn.equals(that.roleArn);
            }

            @Override
            public int hashCode() {
                int result = this.resourceArn.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-output.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesisanalytics.$Module.class, fqn = "@aws-cdk/aws-kinesisanalytics.CfnApplicationOutput.OutputProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface OutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationOutput.OutputProperty.DestinationSchema`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-output.html#cfn-kinesisanalytics-applicationoutput-output-destinationschema
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDestinationSchema();

        /**
         * `CfnApplicationOutput.OutputProperty.KinesisFirehoseOutput`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-output.html#cfn-kinesisanalytics-applicationoutput-output-kinesisfirehoseoutput
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getKinesisFirehoseOutput() {
            return null;
        }

        /**
         * `CfnApplicationOutput.OutputProperty.KinesisStreamsOutput`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-output.html#cfn-kinesisanalytics-applicationoutput-output-kinesisstreamsoutput
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getKinesisStreamsOutput() {
            return null;
        }

        /**
         * `CfnApplicationOutput.OutputProperty.LambdaOutput`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-output.html#cfn-kinesisanalytics-applicationoutput-output-lambdaoutput
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getLambdaOutput() {
            return null;
        }

        /**
         * `CfnApplicationOutput.OutputProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-output.html#cfn-kinesisanalytics-applicationoutput-output-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object destinationSchema;
            private java.lang.Object kinesisFirehoseOutput;
            private java.lang.Object kinesisStreamsOutput;
            private java.lang.Object lambdaOutput;
            private java.lang.String name;

            /**
             * Sets the value of DestinationSchema
             * @param destinationSchema `CfnApplicationOutput.OutputProperty.DestinationSchema`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder destinationSchema(software.amazon.awscdk.core.IResolvable destinationSchema) {
                this.destinationSchema = destinationSchema;
                return this;
            }

            /**
             * Sets the value of DestinationSchema
             * @param destinationSchema `CfnApplicationOutput.OutputProperty.DestinationSchema`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder destinationSchema(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput.DestinationSchemaProperty destinationSchema) {
                this.destinationSchema = destinationSchema;
                return this;
            }

            /**
             * Sets the value of KinesisFirehoseOutput
             * @param kinesisFirehoseOutput `CfnApplicationOutput.OutputProperty.KinesisFirehoseOutput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kinesisFirehoseOutput(software.amazon.awscdk.core.IResolvable kinesisFirehoseOutput) {
                this.kinesisFirehoseOutput = kinesisFirehoseOutput;
                return this;
            }

            /**
             * Sets the value of KinesisFirehoseOutput
             * @param kinesisFirehoseOutput `CfnApplicationOutput.OutputProperty.KinesisFirehoseOutput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kinesisFirehoseOutput(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput.KinesisFirehoseOutputProperty kinesisFirehoseOutput) {
                this.kinesisFirehoseOutput = kinesisFirehoseOutput;
                return this;
            }

            /**
             * Sets the value of KinesisStreamsOutput
             * @param kinesisStreamsOutput `CfnApplicationOutput.OutputProperty.KinesisStreamsOutput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kinesisStreamsOutput(software.amazon.awscdk.core.IResolvable kinesisStreamsOutput) {
                this.kinesisStreamsOutput = kinesisStreamsOutput;
                return this;
            }

            /**
             * Sets the value of KinesisStreamsOutput
             * @param kinesisStreamsOutput `CfnApplicationOutput.OutputProperty.KinesisStreamsOutput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kinesisStreamsOutput(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput.KinesisStreamsOutputProperty kinesisStreamsOutput) {
                this.kinesisStreamsOutput = kinesisStreamsOutput;
                return this;
            }

            /**
             * Sets the value of LambdaOutput
             * @param lambdaOutput `CfnApplicationOutput.OutputProperty.LambdaOutput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder lambdaOutput(software.amazon.awscdk.core.IResolvable lambdaOutput) {
                this.lambdaOutput = lambdaOutput;
                return this;
            }

            /**
             * Sets the value of LambdaOutput
             * @param lambdaOutput `CfnApplicationOutput.OutputProperty.LambdaOutput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder lambdaOutput(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput.LambdaOutputProperty lambdaOutput) {
                this.lambdaOutput = lambdaOutput;
                return this;
            }

            /**
             * Sets the value of Name
             * @param name `CfnApplicationOutput.OutputProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public OutputProperty build() {
                return new Jsii$Proxy(destinationSchema, kinesisFirehoseOutput, kinesisStreamsOutput, lambdaOutput, name);
            }
        }

        /**
         * An implementation for {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputProperty {
            private final java.lang.Object destinationSchema;
            private final java.lang.Object kinesisFirehoseOutput;
            private final java.lang.Object kinesisStreamsOutput;
            private final java.lang.Object lambdaOutput;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationSchema = this.jsiiGet("destinationSchema", java.lang.Object.class);
                this.kinesisFirehoseOutput = this.jsiiGet("kinesisFirehoseOutput", java.lang.Object.class);
                this.kinesisStreamsOutput = this.jsiiGet("kinesisStreamsOutput", java.lang.Object.class);
                this.lambdaOutput = this.jsiiGet("lambdaOutput", java.lang.Object.class);
                this.name = this.jsiiGet("name", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object destinationSchema, final java.lang.Object kinesisFirehoseOutput, final java.lang.Object kinesisStreamsOutput, final java.lang.Object lambdaOutput, final java.lang.String name) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationSchema = java.util.Objects.requireNonNull(destinationSchema, "destinationSchema is required");
                this.kinesisFirehoseOutput = kinesisFirehoseOutput;
                this.kinesisStreamsOutput = kinesisStreamsOutput;
                this.lambdaOutput = lambdaOutput;
                this.name = name;
            }

            @Override
            public java.lang.Object getDestinationSchema() {
                return this.destinationSchema;
            }

            @Override
            public java.lang.Object getKinesisFirehoseOutput() {
                return this.kinesisFirehoseOutput;
            }

            @Override
            public java.lang.Object getKinesisStreamsOutput() {
                return this.kinesisStreamsOutput;
            }

            @Override
            public java.lang.Object getLambdaOutput() {
                return this.lambdaOutput;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinationSchema", om.valueToTree(this.getDestinationSchema()));
                if (this.getKinesisFirehoseOutput() != null) {
                    data.set("kinesisFirehoseOutput", om.valueToTree(this.getKinesisFirehoseOutput()));
                }
                if (this.getKinesisStreamsOutput() != null) {
                    data.set("kinesisStreamsOutput", om.valueToTree(this.getKinesisStreamsOutput()));
                }
                if (this.getLambdaOutput() != null) {
                    data.set("lambdaOutput", om.valueToTree(this.getLambdaOutput()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-kinesisanalytics.CfnApplicationOutput.OutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputProperty.Jsii$Proxy that = (OutputProperty.Jsii$Proxy) o;

                if (!destinationSchema.equals(that.destinationSchema)) return false;
                if (this.kinesisFirehoseOutput != null ? !this.kinesisFirehoseOutput.equals(that.kinesisFirehoseOutput) : that.kinesisFirehoseOutput != null) return false;
                if (this.kinesisStreamsOutput != null ? !this.kinesisStreamsOutput.equals(that.kinesisStreamsOutput) : that.kinesisStreamsOutput != null) return false;
                if (this.lambdaOutput != null ? !this.lambdaOutput.equals(that.lambdaOutput) : that.lambdaOutput != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public int hashCode() {
                int result = this.destinationSchema.hashCode();
                result = 31 * result + (this.kinesisFirehoseOutput != null ? this.kinesisFirehoseOutput.hashCode() : 0);
                result = 31 * result + (this.kinesisStreamsOutput != null ? this.kinesisStreamsOutput.hashCode() : 0);
                result = 31 * result + (this.lambdaOutput != null ? this.lambdaOutput.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutputProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutputProps.Builder();
        }

        /**
         * @return {@code this}
         * @param applicationName `AWS::KinesisAnalytics::ApplicationOutput.ApplicationName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder applicationName(final java.lang.String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        /**
         * @return {@code this}
         * @param output `AWS::KinesisAnalytics::ApplicationOutput.Output`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder output(final software.amazon.awscdk.core.IResolvable output) {
            this.props.output(output);
            return this;
        }
        /**
         * @return {@code this}
         * @param output `AWS::KinesisAnalytics::ApplicationOutput.Output`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder output(final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput.OutputProperty output) {
            this.props.output(output);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput build() {
            return new software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutput(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
