package software.amazon.awscdk.services.kinesisanalytics;

/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.18.0 (build f29d29c)", date = "2019-10-07T15:34:59.233Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesisanalytics.$Module.class, fqn = "@aws-cdk/aws-kinesisanalytics.CfnApplicationV2")
public class CfnApplicationV2 extends software.amazon.awscdk.core.CfnResource {

    protected CfnApplicationV2(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplicationV2(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::KinesisAnalyticsV2::Application`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnApplicationV2(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2Props props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.RuntimeEnvironment`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-runtimeenvironment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getRuntimeEnvironment() {
        return this.jsiiGet("runtimeEnvironment", java.lang.String.class);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.RuntimeEnvironment`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-runtimeenvironment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRuntimeEnvironment(final java.lang.String value) {
        this.jsiiSet("runtimeEnvironment", java.util.Objects.requireNonNull(value, "runtimeEnvironment is required"));
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ServiceExecutionRole`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-serviceexecutionrole
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getServiceExecutionRole() {
        return this.jsiiGet("serviceExecutionRole", java.lang.String.class);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ServiceExecutionRole`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-serviceexecutionrole
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setServiceExecutionRole(final java.lang.String value) {
        this.jsiiSet("serviceExecutionRole", java.util.Objects.requireNonNull(value, "serviceExecutionRole is required"));
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getApplicationConfiguration() {
        return this.jsiiGet("applicationConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApplicationConfiguration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("applicationConfiguration", value);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApplicationConfiguration(final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ApplicationConfigurationProperty value) {
        this.jsiiSet("applicationConfiguration", value);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationDescription`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationdescription
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getApplicationDescription() {
        return this.jsiiGet("applicationDescription", java.lang.String.class);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationDescription`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationdescription
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApplicationDescription(final java.lang.String value) {
        this.jsiiSet("applicationDescription", value);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getApplicationName() {
        return this.jsiiGet("applicationName", java.lang.String.class);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApplicationName(final java.lang.String value) {
        this.jsiiSet("applicationName", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationcodeconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ApplicationCodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.ApplicationCodeConfigurationProperty.CodeContent`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationcodeconfiguration.html#cfn-kinesisanalyticsv2-application-applicationcodeconfiguration-codecontent
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getCodeContent();

        /**
         * `CfnApplicationV2.ApplicationCodeConfigurationProperty.CodeContentType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationcodeconfiguration.html#cfn-kinesisanalyticsv2-application-applicationcodeconfiguration-codecontenttype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCodeContentType();

        /**
         * @return a {@link Builder} of {@link ApplicationCodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApplicationCodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object codeContent;
            private java.lang.String codeContentType;

            /**
             * Sets the value of CodeContent
             * @param codeContent `CfnApplicationV2.ApplicationCodeConfigurationProperty.CodeContent`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder codeContent(software.amazon.awscdk.core.IResolvable codeContent) {
                this.codeContent = codeContent;
                return this;
            }

            /**
             * Sets the value of CodeContent
             * @param codeContent `CfnApplicationV2.ApplicationCodeConfigurationProperty.CodeContent`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder codeContent(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.CodeContentProperty codeContent) {
                this.codeContent = codeContent;
                return this;
            }

            /**
             * Sets the value of CodeContentType
             * @param codeContentType `CfnApplicationV2.ApplicationCodeConfigurationProperty.CodeContentType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder codeContentType(java.lang.String codeContentType) {
                this.codeContentType = codeContentType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationCodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ApplicationCodeConfigurationProperty build() {
                return new Jsii$Proxy(codeContent, codeContentType);
            }
        }

        /**
         * An implementation for {@link ApplicationCodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationCodeConfigurationProperty {
            private final java.lang.Object codeContent;
            private final java.lang.String codeContentType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.codeContent = this.jsiiGet("codeContent", java.lang.Object.class);
                this.codeContentType = this.jsiiGet("codeContentType", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object codeContent, java.lang.String codeContentType) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.codeContent = java.util.Objects.requireNonNull(codeContent, "codeContent is required");
                this.codeContentType = java.util.Objects.requireNonNull(codeContentType, "codeContentType is required");
            }

            @Override
            public java.lang.Object getCodeContent() {
                return this.codeContent;
            }

            @Override
            public java.lang.String getCodeContentType() {
                return this.codeContentType;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("codeContent", om.valueToTree(this.getCodeContent()));
                obj.set("codeContentType", om.valueToTree(this.getCodeContentType()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApplicationCodeConfigurationProperty.Jsii$Proxy that = (ApplicationCodeConfigurationProperty.Jsii$Proxy) o;

                if (!codeContent.equals(that.codeContent)) return false;
                return this.codeContentType.equals(that.codeContentType);
            }

            @Override
            public int hashCode() {
                int result = this.codeContent.hashCode();
                result = 31 * result + (this.codeContentType.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ApplicationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.ApplicationConfigurationProperty.ApplicationCodeConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html#cfn-kinesisanalyticsv2-application-applicationconfiguration-applicationcodeconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getApplicationCodeConfiguration();

        /**
         * `CfnApplicationV2.ApplicationConfigurationProperty.ApplicationSnapshotConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html#cfn-kinesisanalyticsv2-application-applicationconfiguration-applicationsnapshotconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getApplicationSnapshotConfiguration();

        /**
         * `CfnApplicationV2.ApplicationConfigurationProperty.EnvironmentProperties`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html#cfn-kinesisanalyticsv2-application-applicationconfiguration-environmentproperties
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEnvironmentProperties();

        /**
         * `CfnApplicationV2.ApplicationConfigurationProperty.FlinkApplicationConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html#cfn-kinesisanalyticsv2-application-applicationconfiguration-flinkapplicationconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getFlinkApplicationConfiguration();

        /**
         * `CfnApplicationV2.ApplicationConfigurationProperty.SqlApplicationConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html#cfn-kinesisanalyticsv2-application-applicationconfiguration-sqlapplicationconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSqlApplicationConfiguration();

        /**
         * @return a {@link Builder} of {@link ApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object applicationCodeConfiguration;
            private java.lang.Object applicationSnapshotConfiguration;
            private java.lang.Object environmentProperties;
            private java.lang.Object flinkApplicationConfiguration;
            private java.lang.Object sqlApplicationConfiguration;

            /**
             * Sets the value of ApplicationCodeConfiguration
             * @param applicationCodeConfiguration `CfnApplicationV2.ApplicationConfigurationProperty.ApplicationCodeConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder applicationCodeConfiguration(software.amazon.awscdk.core.IResolvable applicationCodeConfiguration) {
                this.applicationCodeConfiguration = applicationCodeConfiguration;
                return this;
            }

            /**
             * Sets the value of ApplicationCodeConfiguration
             * @param applicationCodeConfiguration `CfnApplicationV2.ApplicationConfigurationProperty.ApplicationCodeConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder applicationCodeConfiguration(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ApplicationCodeConfigurationProperty applicationCodeConfiguration) {
                this.applicationCodeConfiguration = applicationCodeConfiguration;
                return this;
            }

            /**
             * Sets the value of ApplicationSnapshotConfiguration
             * @param applicationSnapshotConfiguration `CfnApplicationV2.ApplicationConfigurationProperty.ApplicationSnapshotConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder applicationSnapshotConfiguration(software.amazon.awscdk.core.IResolvable applicationSnapshotConfiguration) {
                this.applicationSnapshotConfiguration = applicationSnapshotConfiguration;
                return this;
            }

            /**
             * Sets the value of ApplicationSnapshotConfiguration
             * @param applicationSnapshotConfiguration `CfnApplicationV2.ApplicationConfigurationProperty.ApplicationSnapshotConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder applicationSnapshotConfiguration(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ApplicationSnapshotConfigurationProperty applicationSnapshotConfiguration) {
                this.applicationSnapshotConfiguration = applicationSnapshotConfiguration;
                return this;
            }

            /**
             * Sets the value of EnvironmentProperties
             * @param environmentProperties `CfnApplicationV2.ApplicationConfigurationProperty.EnvironmentProperties`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder environmentProperties(software.amazon.awscdk.core.IResolvable environmentProperties) {
                this.environmentProperties = environmentProperties;
                return this;
            }

            /**
             * Sets the value of EnvironmentProperties
             * @param environmentProperties `CfnApplicationV2.ApplicationConfigurationProperty.EnvironmentProperties`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder environmentProperties(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.EnvironmentPropertiesProperty environmentProperties) {
                this.environmentProperties = environmentProperties;
                return this;
            }

            /**
             * Sets the value of FlinkApplicationConfiguration
             * @param flinkApplicationConfiguration `CfnApplicationV2.ApplicationConfigurationProperty.FlinkApplicationConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder flinkApplicationConfiguration(software.amazon.awscdk.core.IResolvable flinkApplicationConfiguration) {
                this.flinkApplicationConfiguration = flinkApplicationConfiguration;
                return this;
            }

            /**
             * Sets the value of FlinkApplicationConfiguration
             * @param flinkApplicationConfiguration `CfnApplicationV2.ApplicationConfigurationProperty.FlinkApplicationConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder flinkApplicationConfiguration(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.FlinkApplicationConfigurationProperty flinkApplicationConfiguration) {
                this.flinkApplicationConfiguration = flinkApplicationConfiguration;
                return this;
            }

            /**
             * Sets the value of SqlApplicationConfiguration
             * @param sqlApplicationConfiguration `CfnApplicationV2.ApplicationConfigurationProperty.SqlApplicationConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sqlApplicationConfiguration(software.amazon.awscdk.core.IResolvable sqlApplicationConfiguration) {
                this.sqlApplicationConfiguration = sqlApplicationConfiguration;
                return this;
            }

            /**
             * Sets the value of SqlApplicationConfiguration
             * @param sqlApplicationConfiguration `CfnApplicationV2.ApplicationConfigurationProperty.SqlApplicationConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sqlApplicationConfiguration(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.SqlApplicationConfigurationProperty sqlApplicationConfiguration) {
                this.sqlApplicationConfiguration = sqlApplicationConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ApplicationConfigurationProperty build() {
                return new Jsii$Proxy(applicationCodeConfiguration, applicationSnapshotConfiguration, environmentProperties, flinkApplicationConfiguration, sqlApplicationConfiguration);
            }
        }

        /**
         * An implementation for {@link ApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationConfigurationProperty {
            private final java.lang.Object applicationCodeConfiguration;
            private final java.lang.Object applicationSnapshotConfiguration;
            private final java.lang.Object environmentProperties;
            private final java.lang.Object flinkApplicationConfiguration;
            private final java.lang.Object sqlApplicationConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.applicationCodeConfiguration = this.jsiiGet("applicationCodeConfiguration", java.lang.Object.class);
                this.applicationSnapshotConfiguration = this.jsiiGet("applicationSnapshotConfiguration", java.lang.Object.class);
                this.environmentProperties = this.jsiiGet("environmentProperties", java.lang.Object.class);
                this.flinkApplicationConfiguration = this.jsiiGet("flinkApplicationConfiguration", java.lang.Object.class);
                this.sqlApplicationConfiguration = this.jsiiGet("sqlApplicationConfiguration", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object applicationCodeConfiguration, java.lang.Object applicationSnapshotConfiguration, java.lang.Object environmentProperties, java.lang.Object flinkApplicationConfiguration, java.lang.Object sqlApplicationConfiguration) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applicationCodeConfiguration = applicationCodeConfiguration;
                this.applicationSnapshotConfiguration = applicationSnapshotConfiguration;
                this.environmentProperties = environmentProperties;
                this.flinkApplicationConfiguration = flinkApplicationConfiguration;
                this.sqlApplicationConfiguration = sqlApplicationConfiguration;
            }

            @Override
            public java.lang.Object getApplicationCodeConfiguration() {
                return this.applicationCodeConfiguration;
            }

            @Override
            public java.lang.Object getApplicationSnapshotConfiguration() {
                return this.applicationSnapshotConfiguration;
            }

            @Override
            public java.lang.Object getEnvironmentProperties() {
                return this.environmentProperties;
            }

            @Override
            public java.lang.Object getFlinkApplicationConfiguration() {
                return this.flinkApplicationConfiguration;
            }

            @Override
            public java.lang.Object getSqlApplicationConfiguration() {
                return this.sqlApplicationConfiguration;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getApplicationCodeConfiguration() != null) {
                    obj.set("applicationCodeConfiguration", om.valueToTree(this.getApplicationCodeConfiguration()));
                }
                if (this.getApplicationSnapshotConfiguration() != null) {
                    obj.set("applicationSnapshotConfiguration", om.valueToTree(this.getApplicationSnapshotConfiguration()));
                }
                if (this.getEnvironmentProperties() != null) {
                    obj.set("environmentProperties", om.valueToTree(this.getEnvironmentProperties()));
                }
                if (this.getFlinkApplicationConfiguration() != null) {
                    obj.set("flinkApplicationConfiguration", om.valueToTree(this.getFlinkApplicationConfiguration()));
                }
                if (this.getSqlApplicationConfiguration() != null) {
                    obj.set("sqlApplicationConfiguration", om.valueToTree(this.getSqlApplicationConfiguration()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApplicationConfigurationProperty.Jsii$Proxy that = (ApplicationConfigurationProperty.Jsii$Proxy) o;

                if (this.applicationCodeConfiguration != null ? !this.applicationCodeConfiguration.equals(that.applicationCodeConfiguration) : that.applicationCodeConfiguration != null) return false;
                if (this.applicationSnapshotConfiguration != null ? !this.applicationSnapshotConfiguration.equals(that.applicationSnapshotConfiguration) : that.applicationSnapshotConfiguration != null) return false;
                if (this.environmentProperties != null ? !this.environmentProperties.equals(that.environmentProperties) : that.environmentProperties != null) return false;
                if (this.flinkApplicationConfiguration != null ? !this.flinkApplicationConfiguration.equals(that.flinkApplicationConfiguration) : that.flinkApplicationConfiguration != null) return false;
                return this.sqlApplicationConfiguration != null ? this.sqlApplicationConfiguration.equals(that.sqlApplicationConfiguration) : that.sqlApplicationConfiguration == null;
            }

            @Override
            public int hashCode() {
                int result = this.applicationCodeConfiguration != null ? this.applicationCodeConfiguration.hashCode() : 0;
                result = 31 * result + (this.applicationSnapshotConfiguration != null ? this.applicationSnapshotConfiguration.hashCode() : 0);
                result = 31 * result + (this.environmentProperties != null ? this.environmentProperties.hashCode() : 0);
                result = 31 * result + (this.flinkApplicationConfiguration != null ? this.flinkApplicationConfiguration.hashCode() : 0);
                result = 31 * result + (this.sqlApplicationConfiguration != null ? this.sqlApplicationConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationsnapshotconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ApplicationSnapshotConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.ApplicationSnapshotConfigurationProperty.SnapshotsEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationsnapshotconfiguration.html#cfn-kinesisanalyticsv2-application-applicationsnapshotconfiguration-snapshotsenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getSnapshotsEnabled();

        /**
         * @return a {@link Builder} of {@link ApplicationSnapshotConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApplicationSnapshotConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object snapshotsEnabled;

            /**
             * Sets the value of SnapshotsEnabled
             * @param snapshotsEnabled `CfnApplicationV2.ApplicationSnapshotConfigurationProperty.SnapshotsEnabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder snapshotsEnabled(java.lang.Boolean snapshotsEnabled) {
                this.snapshotsEnabled = snapshotsEnabled;
                return this;
            }

            /**
             * Sets the value of SnapshotsEnabled
             * @param snapshotsEnabled `CfnApplicationV2.ApplicationSnapshotConfigurationProperty.SnapshotsEnabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder snapshotsEnabled(software.amazon.awscdk.core.IResolvable snapshotsEnabled) {
                this.snapshotsEnabled = snapshotsEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationSnapshotConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ApplicationSnapshotConfigurationProperty build() {
                return new Jsii$Proxy(snapshotsEnabled);
            }
        }

        /**
         * An implementation for {@link ApplicationSnapshotConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationSnapshotConfigurationProperty {
            private final java.lang.Object snapshotsEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.snapshotsEnabled = this.jsiiGet("snapshotsEnabled", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object snapshotsEnabled) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.snapshotsEnabled = java.util.Objects.requireNonNull(snapshotsEnabled, "snapshotsEnabled is required");
            }

            @Override
            public java.lang.Object getSnapshotsEnabled() {
                return this.snapshotsEnabled;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("snapshotsEnabled", om.valueToTree(this.getSnapshotsEnabled()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApplicationSnapshotConfigurationProperty.Jsii$Proxy that = (ApplicationSnapshotConfigurationProperty.Jsii$Proxy) o;

                return this.snapshotsEnabled.equals(that.snapshotsEnabled);
            }

            @Override
            public int hashCode() {
                int result = this.snapshotsEnabled.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-csvmappingparameters.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CSVMappingParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.CSVMappingParametersProperty.RecordColumnDelimiter`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-csvmappingparameters.html#cfn-kinesisanalyticsv2-application-csvmappingparameters-recordcolumndelimiter
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getRecordColumnDelimiter();

        /**
         * `CfnApplicationV2.CSVMappingParametersProperty.RecordRowDelimiter`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-csvmappingparameters.html#cfn-kinesisanalyticsv2-application-csvmappingparameters-recordrowdelimiter
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getRecordRowDelimiter();

        /**
         * @return a {@link Builder} of {@link CSVMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CSVMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String recordColumnDelimiter;
            private java.lang.String recordRowDelimiter;

            /**
             * Sets the value of RecordColumnDelimiter
             * @param recordColumnDelimiter `CfnApplicationV2.CSVMappingParametersProperty.RecordColumnDelimiter`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder recordColumnDelimiter(java.lang.String recordColumnDelimiter) {
                this.recordColumnDelimiter = recordColumnDelimiter;
                return this;
            }

            /**
             * Sets the value of RecordRowDelimiter
             * @param recordRowDelimiter `CfnApplicationV2.CSVMappingParametersProperty.RecordRowDelimiter`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder recordRowDelimiter(java.lang.String recordRowDelimiter) {
                this.recordRowDelimiter = recordRowDelimiter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CSVMappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CSVMappingParametersProperty build() {
                return new Jsii$Proxy(recordColumnDelimiter, recordRowDelimiter);
            }
        }

        /**
         * An implementation for {@link CSVMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CSVMappingParametersProperty {
            private final java.lang.String recordColumnDelimiter;
            private final java.lang.String recordRowDelimiter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.recordColumnDelimiter = this.jsiiGet("recordColumnDelimiter", java.lang.String.class);
                this.recordRowDelimiter = this.jsiiGet("recordRowDelimiter", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String recordColumnDelimiter, java.lang.String recordRowDelimiter) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordColumnDelimiter = java.util.Objects.requireNonNull(recordColumnDelimiter, "recordColumnDelimiter is required");
                this.recordRowDelimiter = java.util.Objects.requireNonNull(recordRowDelimiter, "recordRowDelimiter is required");
            }

            @Override
            public java.lang.String getRecordColumnDelimiter() {
                return this.recordColumnDelimiter;
            }

            @Override
            public java.lang.String getRecordRowDelimiter() {
                return this.recordRowDelimiter;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("recordColumnDelimiter", om.valueToTree(this.getRecordColumnDelimiter()));
                obj.set("recordRowDelimiter", om.valueToTree(this.getRecordRowDelimiter()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CSVMappingParametersProperty.Jsii$Proxy that = (CSVMappingParametersProperty.Jsii$Proxy) o;

                if (!recordColumnDelimiter.equals(that.recordColumnDelimiter)) return false;
                return this.recordRowDelimiter.equals(that.recordRowDelimiter);
            }

            @Override
            public int hashCode() {
                int result = this.recordColumnDelimiter.hashCode();
                result = 31 * result + (this.recordRowDelimiter.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-checkpointconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CheckpointConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.CheckpointConfigurationProperty.ConfigurationType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-checkpointconfiguration.html#cfn-kinesisanalyticsv2-application-checkpointconfiguration-configurationtype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getConfigurationType();

        /**
         * `CfnApplicationV2.CheckpointConfigurationProperty.CheckpointingEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-checkpointconfiguration.html#cfn-kinesisanalyticsv2-application-checkpointconfiguration-checkpointingenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getCheckpointingEnabled();

        /**
         * `CfnApplicationV2.CheckpointConfigurationProperty.CheckpointInterval`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-checkpointconfiguration.html#cfn-kinesisanalyticsv2-application-checkpointconfiguration-checkpointinterval
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getCheckpointInterval();

        /**
         * `CfnApplicationV2.CheckpointConfigurationProperty.MinPauseBetweenCheckpoints`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-checkpointconfiguration.html#cfn-kinesisanalyticsv2-application-checkpointconfiguration-minpausebetweencheckpoints
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getMinPauseBetweenCheckpoints();

        /**
         * @return a {@link Builder} of {@link CheckpointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CheckpointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String configurationType;
            private java.lang.Object checkpointingEnabled;
            private java.lang.Number checkpointInterval;
            private java.lang.Number minPauseBetweenCheckpoints;

            /**
             * Sets the value of ConfigurationType
             * @param configurationType `CfnApplicationV2.CheckpointConfigurationProperty.ConfigurationType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder configurationType(java.lang.String configurationType) {
                this.configurationType = configurationType;
                return this;
            }

            /**
             * Sets the value of CheckpointingEnabled
             * @param checkpointingEnabled `CfnApplicationV2.CheckpointConfigurationProperty.CheckpointingEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder checkpointingEnabled(java.lang.Boolean checkpointingEnabled) {
                this.checkpointingEnabled = checkpointingEnabled;
                return this;
            }

            /**
             * Sets the value of CheckpointingEnabled
             * @param checkpointingEnabled `CfnApplicationV2.CheckpointConfigurationProperty.CheckpointingEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder checkpointingEnabled(software.amazon.awscdk.core.IResolvable checkpointingEnabled) {
                this.checkpointingEnabled = checkpointingEnabled;
                return this;
            }

            /**
             * Sets the value of CheckpointInterval
             * @param checkpointInterval `CfnApplicationV2.CheckpointConfigurationProperty.CheckpointInterval`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder checkpointInterval(java.lang.Number checkpointInterval) {
                this.checkpointInterval = checkpointInterval;
                return this;
            }

            /**
             * Sets the value of MinPauseBetweenCheckpoints
             * @param minPauseBetweenCheckpoints `CfnApplicationV2.CheckpointConfigurationProperty.MinPauseBetweenCheckpoints`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder minPauseBetweenCheckpoints(java.lang.Number minPauseBetweenCheckpoints) {
                this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CheckpointConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CheckpointConfigurationProperty build() {
                return new Jsii$Proxy(configurationType, checkpointingEnabled, checkpointInterval, minPauseBetweenCheckpoints);
            }
        }

        /**
         * An implementation for {@link CheckpointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CheckpointConfigurationProperty {
            private final java.lang.String configurationType;
            private final java.lang.Object checkpointingEnabled;
            private final java.lang.Number checkpointInterval;
            private final java.lang.Number minPauseBetweenCheckpoints;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.configurationType = this.jsiiGet("configurationType", java.lang.String.class);
                this.checkpointingEnabled = this.jsiiGet("checkpointingEnabled", java.lang.Object.class);
                this.checkpointInterval = this.jsiiGet("checkpointInterval", java.lang.Number.class);
                this.minPauseBetweenCheckpoints = this.jsiiGet("minPauseBetweenCheckpoints", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String configurationType, java.lang.Object checkpointingEnabled, java.lang.Number checkpointInterval, java.lang.Number minPauseBetweenCheckpoints) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configurationType = java.util.Objects.requireNonNull(configurationType, "configurationType is required");
                this.checkpointingEnabled = checkpointingEnabled;
                this.checkpointInterval = checkpointInterval;
                this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
            }

            @Override
            public java.lang.String getConfigurationType() {
                return this.configurationType;
            }

            @Override
            public java.lang.Object getCheckpointingEnabled() {
                return this.checkpointingEnabled;
            }

            @Override
            public java.lang.Number getCheckpointInterval() {
                return this.checkpointInterval;
            }

            @Override
            public java.lang.Number getMinPauseBetweenCheckpoints() {
                return this.minPauseBetweenCheckpoints;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("configurationType", om.valueToTree(this.getConfigurationType()));
                if (this.getCheckpointingEnabled() != null) {
                    obj.set("checkpointingEnabled", om.valueToTree(this.getCheckpointingEnabled()));
                }
                if (this.getCheckpointInterval() != null) {
                    obj.set("checkpointInterval", om.valueToTree(this.getCheckpointInterval()));
                }
                if (this.getMinPauseBetweenCheckpoints() != null) {
                    obj.set("minPauseBetweenCheckpoints", om.valueToTree(this.getMinPauseBetweenCheckpoints()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CheckpointConfigurationProperty.Jsii$Proxy that = (CheckpointConfigurationProperty.Jsii$Proxy) o;

                if (!configurationType.equals(that.configurationType)) return false;
                if (this.checkpointingEnabled != null ? !this.checkpointingEnabled.equals(that.checkpointingEnabled) : that.checkpointingEnabled != null) return false;
                if (this.checkpointInterval != null ? !this.checkpointInterval.equals(that.checkpointInterval) : that.checkpointInterval != null) return false;
                return this.minPauseBetweenCheckpoints != null ? this.minPauseBetweenCheckpoints.equals(that.minPauseBetweenCheckpoints) : that.minPauseBetweenCheckpoints == null;
            }

            @Override
            public int hashCode() {
                int result = this.configurationType.hashCode();
                result = 31 * result + (this.checkpointingEnabled != null ? this.checkpointingEnabled.hashCode() : 0);
                result = 31 * result + (this.checkpointInterval != null ? this.checkpointInterval.hashCode() : 0);
                result = 31 * result + (this.minPauseBetweenCheckpoints != null ? this.minPauseBetweenCheckpoints.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-codecontent.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CodeContentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.CodeContentProperty.S3ContentLocation`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-codecontent.html#cfn-kinesisanalyticsv2-application-codecontent-s3contentlocation
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getS3ContentLocation();

        /**
         * `CfnApplicationV2.CodeContentProperty.TextContent`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-codecontent.html#cfn-kinesisanalyticsv2-application-codecontent-textcontent
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTextContent();

        /**
         * `CfnApplicationV2.CodeContentProperty.ZipFileContent`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-codecontent.html#cfn-kinesisanalyticsv2-application-codecontent-zipfilecontent
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getZipFileContent();

        /**
         * @return a {@link Builder} of {@link CodeContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CodeContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object s3ContentLocation;
            private java.lang.String textContent;
            private java.lang.String zipFileContent;

            /**
             * Sets the value of S3ContentLocation
             * @param s3ContentLocation `CfnApplicationV2.CodeContentProperty.S3ContentLocation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder s3ContentLocation(software.amazon.awscdk.core.IResolvable s3ContentLocation) {
                this.s3ContentLocation = s3ContentLocation;
                return this;
            }

            /**
             * Sets the value of S3ContentLocation
             * @param s3ContentLocation `CfnApplicationV2.CodeContentProperty.S3ContentLocation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder s3ContentLocation(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.S3ContentLocationProperty s3ContentLocation) {
                this.s3ContentLocation = s3ContentLocation;
                return this;
            }

            /**
             * Sets the value of TextContent
             * @param textContent `CfnApplicationV2.CodeContentProperty.TextContent`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder textContent(java.lang.String textContent) {
                this.textContent = textContent;
                return this;
            }

            /**
             * Sets the value of ZipFileContent
             * @param zipFileContent `CfnApplicationV2.CodeContentProperty.ZipFileContent`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder zipFileContent(java.lang.String zipFileContent) {
                this.zipFileContent = zipFileContent;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeContentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CodeContentProperty build() {
                return new Jsii$Proxy(s3ContentLocation, textContent, zipFileContent);
            }
        }

        /**
         * An implementation for {@link CodeContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeContentProperty {
            private final java.lang.Object s3ContentLocation;
            private final java.lang.String textContent;
            private final java.lang.String zipFileContent;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.s3ContentLocation = this.jsiiGet("s3ContentLocation", java.lang.Object.class);
                this.textContent = this.jsiiGet("textContent", java.lang.String.class);
                this.zipFileContent = this.jsiiGet("zipFileContent", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object s3ContentLocation, java.lang.String textContent, java.lang.String zipFileContent) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3ContentLocation = s3ContentLocation;
                this.textContent = textContent;
                this.zipFileContent = zipFileContent;
            }

            @Override
            public java.lang.Object getS3ContentLocation() {
                return this.s3ContentLocation;
            }

            @Override
            public java.lang.String getTextContent() {
                return this.textContent;
            }

            @Override
            public java.lang.String getZipFileContent() {
                return this.zipFileContent;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getS3ContentLocation() != null) {
                    obj.set("s3ContentLocation", om.valueToTree(this.getS3ContentLocation()));
                }
                if (this.getTextContent() != null) {
                    obj.set("textContent", om.valueToTree(this.getTextContent()));
                }
                if (this.getZipFileContent() != null) {
                    obj.set("zipFileContent", om.valueToTree(this.getZipFileContent()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CodeContentProperty.Jsii$Proxy that = (CodeContentProperty.Jsii$Proxy) o;

                if (this.s3ContentLocation != null ? !this.s3ContentLocation.equals(that.s3ContentLocation) : that.s3ContentLocation != null) return false;
                if (this.textContent != null ? !this.textContent.equals(that.textContent) : that.textContent != null) return false;
                return this.zipFileContent != null ? this.zipFileContent.equals(that.zipFileContent) : that.zipFileContent == null;
            }

            @Override
            public int hashCode() {
                int result = this.s3ContentLocation != null ? this.s3ContentLocation.hashCode() : 0;
                result = 31 * result + (this.textContent != null ? this.textContent.hashCode() : 0);
                result = 31 * result + (this.zipFileContent != null ? this.zipFileContent.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-environmentproperties.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface EnvironmentPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.EnvironmentPropertiesProperty.PropertyGroups`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-environmentproperties.html#cfn-kinesisanalyticsv2-application-environmentproperties-propertygroups
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getPropertyGroups();

        /**
         * @return a {@link Builder} of {@link EnvironmentPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnvironmentPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object propertyGroups;

            /**
             * Sets the value of PropertyGroups
             * @param propertyGroups `CfnApplicationV2.EnvironmentPropertiesProperty.PropertyGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder propertyGroups(software.amazon.awscdk.core.IResolvable propertyGroups) {
                this.propertyGroups = propertyGroups;
                return this;
            }

            /**
             * Sets the value of PropertyGroups
             * @param propertyGroups `CfnApplicationV2.EnvironmentPropertiesProperty.PropertyGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder propertyGroups(java.util.List<java.lang.Object> propertyGroups) {
                this.propertyGroups = propertyGroups;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public EnvironmentPropertiesProperty build() {
                return new Jsii$Proxy(propertyGroups);
            }
        }

        /**
         * An implementation for {@link EnvironmentPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentPropertiesProperty {
            private final java.lang.Object propertyGroups;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.propertyGroups = this.jsiiGet("propertyGroups", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object propertyGroups) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.propertyGroups = propertyGroups;
            }

            @Override
            public java.lang.Object getPropertyGroups() {
                return this.propertyGroups;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getPropertyGroups() != null) {
                    obj.set("propertyGroups", om.valueToTree(this.getPropertyGroups()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnvironmentPropertiesProperty.Jsii$Proxy that = (EnvironmentPropertiesProperty.Jsii$Proxy) o;

                return this.propertyGroups != null ? this.propertyGroups.equals(that.propertyGroups) : that.propertyGroups == null;
            }

            @Override
            public int hashCode() {
                int result = this.propertyGroups != null ? this.propertyGroups.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-flinkapplicationconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface FlinkApplicationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.FlinkApplicationConfigurationProperty.CheckpointConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-flinkapplicationconfiguration.html#cfn-kinesisanalyticsv2-application-flinkapplicationconfiguration-checkpointconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getCheckpointConfiguration();

        /**
         * `CfnApplicationV2.FlinkApplicationConfigurationProperty.MonitoringConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-flinkapplicationconfiguration.html#cfn-kinesisanalyticsv2-application-flinkapplicationconfiguration-monitoringconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getMonitoringConfiguration();

        /**
         * `CfnApplicationV2.FlinkApplicationConfigurationProperty.ParallelismConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-flinkapplicationconfiguration.html#cfn-kinesisanalyticsv2-application-flinkapplicationconfiguration-parallelismconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getParallelismConfiguration();

        /**
         * @return a {@link Builder} of {@link FlinkApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlinkApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object checkpointConfiguration;
            private java.lang.Object monitoringConfiguration;
            private java.lang.Object parallelismConfiguration;

            /**
             * Sets the value of CheckpointConfiguration
             * @param checkpointConfiguration `CfnApplicationV2.FlinkApplicationConfigurationProperty.CheckpointConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder checkpointConfiguration(software.amazon.awscdk.core.IResolvable checkpointConfiguration) {
                this.checkpointConfiguration = checkpointConfiguration;
                return this;
            }

            /**
             * Sets the value of CheckpointConfiguration
             * @param checkpointConfiguration `CfnApplicationV2.FlinkApplicationConfigurationProperty.CheckpointConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder checkpointConfiguration(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.CheckpointConfigurationProperty checkpointConfiguration) {
                this.checkpointConfiguration = checkpointConfiguration;
                return this;
            }

            /**
             * Sets the value of MonitoringConfiguration
             * @param monitoringConfiguration `CfnApplicationV2.FlinkApplicationConfigurationProperty.MonitoringConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder monitoringConfiguration(software.amazon.awscdk.core.IResolvable monitoringConfiguration) {
                this.monitoringConfiguration = monitoringConfiguration;
                return this;
            }

            /**
             * Sets the value of MonitoringConfiguration
             * @param monitoringConfiguration `CfnApplicationV2.FlinkApplicationConfigurationProperty.MonitoringConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder monitoringConfiguration(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.MonitoringConfigurationProperty monitoringConfiguration) {
                this.monitoringConfiguration = monitoringConfiguration;
                return this;
            }

            /**
             * Sets the value of ParallelismConfiguration
             * @param parallelismConfiguration `CfnApplicationV2.FlinkApplicationConfigurationProperty.ParallelismConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder parallelismConfiguration(software.amazon.awscdk.core.IResolvable parallelismConfiguration) {
                this.parallelismConfiguration = parallelismConfiguration;
                return this;
            }

            /**
             * Sets the value of ParallelismConfiguration
             * @param parallelismConfiguration `CfnApplicationV2.FlinkApplicationConfigurationProperty.ParallelismConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder parallelismConfiguration(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ParallelismConfigurationProperty parallelismConfiguration) {
                this.parallelismConfiguration = parallelismConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlinkApplicationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public FlinkApplicationConfigurationProperty build() {
                return new Jsii$Proxy(checkpointConfiguration, monitoringConfiguration, parallelismConfiguration);
            }
        }

        /**
         * An implementation for {@link FlinkApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlinkApplicationConfigurationProperty {
            private final java.lang.Object checkpointConfiguration;
            private final java.lang.Object monitoringConfiguration;
            private final java.lang.Object parallelismConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.checkpointConfiguration = this.jsiiGet("checkpointConfiguration", java.lang.Object.class);
                this.monitoringConfiguration = this.jsiiGet("monitoringConfiguration", java.lang.Object.class);
                this.parallelismConfiguration = this.jsiiGet("parallelismConfiguration", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object checkpointConfiguration, java.lang.Object monitoringConfiguration, java.lang.Object parallelismConfiguration) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.checkpointConfiguration = checkpointConfiguration;
                this.monitoringConfiguration = monitoringConfiguration;
                this.parallelismConfiguration = parallelismConfiguration;
            }

            @Override
            public java.lang.Object getCheckpointConfiguration() {
                return this.checkpointConfiguration;
            }

            @Override
            public java.lang.Object getMonitoringConfiguration() {
                return this.monitoringConfiguration;
            }

            @Override
            public java.lang.Object getParallelismConfiguration() {
                return this.parallelismConfiguration;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getCheckpointConfiguration() != null) {
                    obj.set("checkpointConfiguration", om.valueToTree(this.getCheckpointConfiguration()));
                }
                if (this.getMonitoringConfiguration() != null) {
                    obj.set("monitoringConfiguration", om.valueToTree(this.getMonitoringConfiguration()));
                }
                if (this.getParallelismConfiguration() != null) {
                    obj.set("parallelismConfiguration", om.valueToTree(this.getParallelismConfiguration()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlinkApplicationConfigurationProperty.Jsii$Proxy that = (FlinkApplicationConfigurationProperty.Jsii$Proxy) o;

                if (this.checkpointConfiguration != null ? !this.checkpointConfiguration.equals(that.checkpointConfiguration) : that.checkpointConfiguration != null) return false;
                if (this.monitoringConfiguration != null ? !this.monitoringConfiguration.equals(that.monitoringConfiguration) : that.monitoringConfiguration != null) return false;
                return this.parallelismConfiguration != null ? this.parallelismConfiguration.equals(that.parallelismConfiguration) : that.parallelismConfiguration == null;
            }

            @Override
            public int hashCode() {
                int result = this.checkpointConfiguration != null ? this.checkpointConfiguration.hashCode() : 0;
                result = 31 * result + (this.monitoringConfiguration != null ? this.monitoringConfiguration.hashCode() : 0);
                result = 31 * result + (this.parallelismConfiguration != null ? this.parallelismConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputlambdaprocessor.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface InputLambdaProcessorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.InputLambdaProcessorProperty.ResourceARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputlambdaprocessor.html#cfn-kinesisanalyticsv2-application-inputlambdaprocessor-resourcearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getResourceArn();

        /**
         * @return a {@link Builder} of {@link InputLambdaProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputLambdaProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String resourceArn;

            /**
             * Sets the value of ResourceArn
             * @param resourceArn `CfnApplicationV2.InputLambdaProcessorProperty.ResourceARN`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputLambdaProcessorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public InputLambdaProcessorProperty build() {
                return new Jsii$Proxy(resourceArn);
            }
        }

        /**
         * An implementation for {@link InputLambdaProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputLambdaProcessorProperty {
            private final java.lang.String resourceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.resourceArn = this.jsiiGet("resourceArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String resourceArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceArn = java.util.Objects.requireNonNull(resourceArn, "resourceArn is required");
            }

            @Override
            public java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("resourceArn", om.valueToTree(this.getResourceArn()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputLambdaProcessorProperty.Jsii$Proxy that = (InputLambdaProcessorProperty.Jsii$Proxy) o;

                return this.resourceArn.equals(that.resourceArn);
            }

            @Override
            public int hashCode() {
                int result = this.resourceArn.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputparallelism.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface InputParallelismProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.InputParallelismProperty.Count`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputparallelism.html#cfn-kinesisanalyticsv2-application-inputparallelism-count
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getCount();

        /**
         * @return a {@link Builder} of {@link InputParallelismProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputParallelismProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Number count;

            /**
             * Sets the value of Count
             * @param count `CfnApplicationV2.InputParallelismProperty.Count`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder count(java.lang.Number count) {
                this.count = count;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputParallelismProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public InputParallelismProperty build() {
                return new Jsii$Proxy(count);
            }
        }

        /**
         * An implementation for {@link InputParallelismProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputParallelismProperty {
            private final java.lang.Number count;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.count = this.jsiiGet("count", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Number count) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.count = count;
            }

            @Override
            public java.lang.Number getCount() {
                return this.count;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getCount() != null) {
                    obj.set("count", om.valueToTree(this.getCount()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputParallelismProperty.Jsii$Proxy that = (InputParallelismProperty.Jsii$Proxy) o;

                return this.count != null ? this.count.equals(that.count) : that.count == null;
            }

            @Override
            public int hashCode() {
                int result = this.count != null ? this.count.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputprocessingconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface InputProcessingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.InputProcessingConfigurationProperty.InputLambdaProcessor`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputprocessingconfiguration.html#cfn-kinesisanalyticsv2-application-inputprocessingconfiguration-inputlambdaprocessor
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getInputLambdaProcessor();

        /**
         * @return a {@link Builder} of {@link InputProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object inputLambdaProcessor;

            /**
             * Sets the value of InputLambdaProcessor
             * @param inputLambdaProcessor `CfnApplicationV2.InputProcessingConfigurationProperty.InputLambdaProcessor`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder inputLambdaProcessor(software.amazon.awscdk.core.IResolvable inputLambdaProcessor) {
                this.inputLambdaProcessor = inputLambdaProcessor;
                return this;
            }

            /**
             * Sets the value of InputLambdaProcessor
             * @param inputLambdaProcessor `CfnApplicationV2.InputProcessingConfigurationProperty.InputLambdaProcessor`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder inputLambdaProcessor(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.InputLambdaProcessorProperty inputLambdaProcessor) {
                this.inputLambdaProcessor = inputLambdaProcessor;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputProcessingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public InputProcessingConfigurationProperty build() {
                return new Jsii$Proxy(inputLambdaProcessor);
            }
        }

        /**
         * An implementation for {@link InputProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputProcessingConfigurationProperty {
            private final java.lang.Object inputLambdaProcessor;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.inputLambdaProcessor = this.jsiiGet("inputLambdaProcessor", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object inputLambdaProcessor) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputLambdaProcessor = inputLambdaProcessor;
            }

            @Override
            public java.lang.Object getInputLambdaProcessor() {
                return this.inputLambdaProcessor;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getInputLambdaProcessor() != null) {
                    obj.set("inputLambdaProcessor", om.valueToTree(this.getInputLambdaProcessor()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputProcessingConfigurationProperty.Jsii$Proxy that = (InputProcessingConfigurationProperty.Jsii$Proxy) o;

                return this.inputLambdaProcessor != null ? this.inputLambdaProcessor.equals(that.inputLambdaProcessor) : that.inputLambdaProcessor == null;
            }

            @Override
            public int hashCode() {
                int result = this.inputLambdaProcessor != null ? this.inputLambdaProcessor.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface InputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.InputProperty.InputSchema`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-inputschema
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getInputSchema();

        /**
         * `CfnApplicationV2.InputProperty.NamePrefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-nameprefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getNamePrefix();

        /**
         * `CfnApplicationV2.InputProperty.InputParallelism`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-inputparallelism
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getInputParallelism();

        /**
         * `CfnApplicationV2.InputProperty.InputProcessingConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-inputprocessingconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getInputProcessingConfiguration();

        /**
         * `CfnApplicationV2.InputProperty.KinesisFirehoseInput`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-kinesisfirehoseinput
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getKinesisFirehoseInput();

        /**
         * `CfnApplicationV2.InputProperty.KinesisStreamsInput`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-kinesisstreamsinput
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getKinesisStreamsInput();

        /**
         * @return a {@link Builder} of {@link InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object inputSchema;
            private java.lang.String namePrefix;
            private java.lang.Object inputParallelism;
            private java.lang.Object inputProcessingConfiguration;
            private java.lang.Object kinesisFirehoseInput;
            private java.lang.Object kinesisStreamsInput;

            /**
             * Sets the value of InputSchema
             * @param inputSchema `CfnApplicationV2.InputProperty.InputSchema`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder inputSchema(software.amazon.awscdk.core.IResolvable inputSchema) {
                this.inputSchema = inputSchema;
                return this;
            }

            /**
             * Sets the value of InputSchema
             * @param inputSchema `CfnApplicationV2.InputProperty.InputSchema`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder inputSchema(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.InputSchemaProperty inputSchema) {
                this.inputSchema = inputSchema;
                return this;
            }

            /**
             * Sets the value of NamePrefix
             * @param namePrefix `CfnApplicationV2.InputProperty.NamePrefix`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder namePrefix(java.lang.String namePrefix) {
                this.namePrefix = namePrefix;
                return this;
            }

            /**
             * Sets the value of InputParallelism
             * @param inputParallelism `CfnApplicationV2.InputProperty.InputParallelism`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder inputParallelism(software.amazon.awscdk.core.IResolvable inputParallelism) {
                this.inputParallelism = inputParallelism;
                return this;
            }

            /**
             * Sets the value of InputParallelism
             * @param inputParallelism `CfnApplicationV2.InputProperty.InputParallelism`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder inputParallelism(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.InputParallelismProperty inputParallelism) {
                this.inputParallelism = inputParallelism;
                return this;
            }

            /**
             * Sets the value of InputProcessingConfiguration
             * @param inputProcessingConfiguration `CfnApplicationV2.InputProperty.InputProcessingConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder inputProcessingConfiguration(software.amazon.awscdk.core.IResolvable inputProcessingConfiguration) {
                this.inputProcessingConfiguration = inputProcessingConfiguration;
                return this;
            }

            /**
             * Sets the value of InputProcessingConfiguration
             * @param inputProcessingConfiguration `CfnApplicationV2.InputProperty.InputProcessingConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder inputProcessingConfiguration(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.InputProcessingConfigurationProperty inputProcessingConfiguration) {
                this.inputProcessingConfiguration = inputProcessingConfiguration;
                return this;
            }

            /**
             * Sets the value of KinesisFirehoseInput
             * @param kinesisFirehoseInput `CfnApplicationV2.InputProperty.KinesisFirehoseInput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kinesisFirehoseInput(software.amazon.awscdk.core.IResolvable kinesisFirehoseInput) {
                this.kinesisFirehoseInput = kinesisFirehoseInput;
                return this;
            }

            /**
             * Sets the value of KinesisFirehoseInput
             * @param kinesisFirehoseInput `CfnApplicationV2.InputProperty.KinesisFirehoseInput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kinesisFirehoseInput(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.KinesisFirehoseInputProperty kinesisFirehoseInput) {
                this.kinesisFirehoseInput = kinesisFirehoseInput;
                return this;
            }

            /**
             * Sets the value of KinesisStreamsInput
             * @param kinesisStreamsInput `CfnApplicationV2.InputProperty.KinesisStreamsInput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kinesisStreamsInput(software.amazon.awscdk.core.IResolvable kinesisStreamsInput) {
                this.kinesisStreamsInput = kinesisStreamsInput;
                return this;
            }

            /**
             * Sets the value of KinesisStreamsInput
             * @param kinesisStreamsInput `CfnApplicationV2.InputProperty.KinesisStreamsInput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kinesisStreamsInput(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.KinesisStreamsInputProperty kinesisStreamsInput) {
                this.kinesisStreamsInput = kinesisStreamsInput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public InputProperty build() {
                return new Jsii$Proxy(inputSchema, namePrefix, inputParallelism, inputProcessingConfiguration, kinesisFirehoseInput, kinesisStreamsInput);
            }
        }

        /**
         * An implementation for {@link InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputProperty {
            private final java.lang.Object inputSchema;
            private final java.lang.String namePrefix;
            private final java.lang.Object inputParallelism;
            private final java.lang.Object inputProcessingConfiguration;
            private final java.lang.Object kinesisFirehoseInput;
            private final java.lang.Object kinesisStreamsInput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.inputSchema = this.jsiiGet("inputSchema", java.lang.Object.class);
                this.namePrefix = this.jsiiGet("namePrefix", java.lang.String.class);
                this.inputParallelism = this.jsiiGet("inputParallelism", java.lang.Object.class);
                this.inputProcessingConfiguration = this.jsiiGet("inputProcessingConfiguration", java.lang.Object.class);
                this.kinesisFirehoseInput = this.jsiiGet("kinesisFirehoseInput", java.lang.Object.class);
                this.kinesisStreamsInput = this.jsiiGet("kinesisStreamsInput", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object inputSchema, java.lang.String namePrefix, java.lang.Object inputParallelism, java.lang.Object inputProcessingConfiguration, java.lang.Object kinesisFirehoseInput, java.lang.Object kinesisStreamsInput) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputSchema = java.util.Objects.requireNonNull(inputSchema, "inputSchema is required");
                this.namePrefix = java.util.Objects.requireNonNull(namePrefix, "namePrefix is required");
                this.inputParallelism = inputParallelism;
                this.inputProcessingConfiguration = inputProcessingConfiguration;
                this.kinesisFirehoseInput = kinesisFirehoseInput;
                this.kinesisStreamsInput = kinesisStreamsInput;
            }

            @Override
            public java.lang.Object getInputSchema() {
                return this.inputSchema;
            }

            @Override
            public java.lang.String getNamePrefix() {
                return this.namePrefix;
            }

            @Override
            public java.lang.Object getInputParallelism() {
                return this.inputParallelism;
            }

            @Override
            public java.lang.Object getInputProcessingConfiguration() {
                return this.inputProcessingConfiguration;
            }

            @Override
            public java.lang.Object getKinesisFirehoseInput() {
                return this.kinesisFirehoseInput;
            }

            @Override
            public java.lang.Object getKinesisStreamsInput() {
                return this.kinesisStreamsInput;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("inputSchema", om.valueToTree(this.getInputSchema()));
                obj.set("namePrefix", om.valueToTree(this.getNamePrefix()));
                if (this.getInputParallelism() != null) {
                    obj.set("inputParallelism", om.valueToTree(this.getInputParallelism()));
                }
                if (this.getInputProcessingConfiguration() != null) {
                    obj.set("inputProcessingConfiguration", om.valueToTree(this.getInputProcessingConfiguration()));
                }
                if (this.getKinesisFirehoseInput() != null) {
                    obj.set("kinesisFirehoseInput", om.valueToTree(this.getKinesisFirehoseInput()));
                }
                if (this.getKinesisStreamsInput() != null) {
                    obj.set("kinesisStreamsInput", om.valueToTree(this.getKinesisStreamsInput()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputProperty.Jsii$Proxy that = (InputProperty.Jsii$Proxy) o;

                if (!inputSchema.equals(that.inputSchema)) return false;
                if (!namePrefix.equals(that.namePrefix)) return false;
                if (this.inputParallelism != null ? !this.inputParallelism.equals(that.inputParallelism) : that.inputParallelism != null) return false;
                if (this.inputProcessingConfiguration != null ? !this.inputProcessingConfiguration.equals(that.inputProcessingConfiguration) : that.inputProcessingConfiguration != null) return false;
                if (this.kinesisFirehoseInput != null ? !this.kinesisFirehoseInput.equals(that.kinesisFirehoseInput) : that.kinesisFirehoseInput != null) return false;
                return this.kinesisStreamsInput != null ? this.kinesisStreamsInput.equals(that.kinesisStreamsInput) : that.kinesisStreamsInput == null;
            }

            @Override
            public int hashCode() {
                int result = this.inputSchema.hashCode();
                result = 31 * result + (this.namePrefix.hashCode());
                result = 31 * result + (this.inputParallelism != null ? this.inputParallelism.hashCode() : 0);
                result = 31 * result + (this.inputProcessingConfiguration != null ? this.inputProcessingConfiguration.hashCode() : 0);
                result = 31 * result + (this.kinesisFirehoseInput != null ? this.kinesisFirehoseInput.hashCode() : 0);
                result = 31 * result + (this.kinesisStreamsInput != null ? this.kinesisStreamsInput.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputschema.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface InputSchemaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.InputSchemaProperty.RecordColumns`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputschema.html#cfn-kinesisanalyticsv2-application-inputschema-recordcolumns
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRecordColumns();

        /**
         * `CfnApplicationV2.InputSchemaProperty.RecordFormat`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputschema.html#cfn-kinesisanalyticsv2-application-inputschema-recordformat
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRecordFormat();

        /**
         * `CfnApplicationV2.InputSchemaProperty.RecordEncoding`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputschema.html#cfn-kinesisanalyticsv2-application-inputschema-recordencoding
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getRecordEncoding();

        /**
         * @return a {@link Builder} of {@link InputSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object recordColumns;
            private java.lang.Object recordFormat;
            private java.lang.String recordEncoding;

            /**
             * Sets the value of RecordColumns
             * @param recordColumns `CfnApplicationV2.InputSchemaProperty.RecordColumns`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder recordColumns(software.amazon.awscdk.core.IResolvable recordColumns) {
                this.recordColumns = recordColumns;
                return this;
            }

            /**
             * Sets the value of RecordColumns
             * @param recordColumns `CfnApplicationV2.InputSchemaProperty.RecordColumns`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder recordColumns(java.util.List<java.lang.Object> recordColumns) {
                this.recordColumns = recordColumns;
                return this;
            }

            /**
             * Sets the value of RecordFormat
             * @param recordFormat `CfnApplicationV2.InputSchemaProperty.RecordFormat`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder recordFormat(software.amazon.awscdk.core.IResolvable recordFormat) {
                this.recordFormat = recordFormat;
                return this;
            }

            /**
             * Sets the value of RecordFormat
             * @param recordFormat `CfnApplicationV2.InputSchemaProperty.RecordFormat`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder recordFormat(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.RecordFormatProperty recordFormat) {
                this.recordFormat = recordFormat;
                return this;
            }

            /**
             * Sets the value of RecordEncoding
             * @param recordEncoding `CfnApplicationV2.InputSchemaProperty.RecordEncoding`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder recordEncoding(java.lang.String recordEncoding) {
                this.recordEncoding = recordEncoding;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputSchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public InputSchemaProperty build() {
                return new Jsii$Proxy(recordColumns, recordFormat, recordEncoding);
            }
        }

        /**
         * An implementation for {@link InputSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputSchemaProperty {
            private final java.lang.Object recordColumns;
            private final java.lang.Object recordFormat;
            private final java.lang.String recordEncoding;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.recordColumns = this.jsiiGet("recordColumns", java.lang.Object.class);
                this.recordFormat = this.jsiiGet("recordFormat", java.lang.Object.class);
                this.recordEncoding = this.jsiiGet("recordEncoding", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object recordColumns, java.lang.Object recordFormat, java.lang.String recordEncoding) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordColumns = java.util.Objects.requireNonNull(recordColumns, "recordColumns is required");
                this.recordFormat = java.util.Objects.requireNonNull(recordFormat, "recordFormat is required");
                this.recordEncoding = recordEncoding;
            }

            @Override
            public java.lang.Object getRecordColumns() {
                return this.recordColumns;
            }

            @Override
            public java.lang.Object getRecordFormat() {
                return this.recordFormat;
            }

            @Override
            public java.lang.String getRecordEncoding() {
                return this.recordEncoding;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("recordColumns", om.valueToTree(this.getRecordColumns()));
                obj.set("recordFormat", om.valueToTree(this.getRecordFormat()));
                if (this.getRecordEncoding() != null) {
                    obj.set("recordEncoding", om.valueToTree(this.getRecordEncoding()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputSchemaProperty.Jsii$Proxy that = (InputSchemaProperty.Jsii$Proxy) o;

                if (!recordColumns.equals(that.recordColumns)) return false;
                if (!recordFormat.equals(that.recordFormat)) return false;
                return this.recordEncoding != null ? this.recordEncoding.equals(that.recordEncoding) : that.recordEncoding == null;
            }

            @Override
            public int hashCode() {
                int result = this.recordColumns.hashCode();
                result = 31 * result + (this.recordFormat.hashCode());
                result = 31 * result + (this.recordEncoding != null ? this.recordEncoding.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-jsonmappingparameters.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface JSONMappingParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.JSONMappingParametersProperty.RecordRowPath`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-jsonmappingparameters.html#cfn-kinesisanalyticsv2-application-jsonmappingparameters-recordrowpath
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getRecordRowPath();

        /**
         * @return a {@link Builder} of {@link JSONMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JSONMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String recordRowPath;

            /**
             * Sets the value of RecordRowPath
             * @param recordRowPath `CfnApplicationV2.JSONMappingParametersProperty.RecordRowPath`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder recordRowPath(java.lang.String recordRowPath) {
                this.recordRowPath = recordRowPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JSONMappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public JSONMappingParametersProperty build() {
                return new Jsii$Proxy(recordRowPath);
            }
        }

        /**
         * An implementation for {@link JSONMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JSONMappingParametersProperty {
            private final java.lang.String recordRowPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.recordRowPath = this.jsiiGet("recordRowPath", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String recordRowPath) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordRowPath = java.util.Objects.requireNonNull(recordRowPath, "recordRowPath is required");
            }

            @Override
            public java.lang.String getRecordRowPath() {
                return this.recordRowPath;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("recordRowPath", om.valueToTree(this.getRecordRowPath()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JSONMappingParametersProperty.Jsii$Proxy that = (JSONMappingParametersProperty.Jsii$Proxy) o;

                return this.recordRowPath.equals(that.recordRowPath);
            }

            @Override
            public int hashCode() {
                int result = this.recordRowPath.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-kinesisfirehoseinput.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface KinesisFirehoseInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.KinesisFirehoseInputProperty.ResourceARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-kinesisfirehoseinput.html#cfn-kinesisanalyticsv2-application-kinesisfirehoseinput-resourcearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getResourceArn();

        /**
         * @return a {@link Builder} of {@link KinesisFirehoseInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisFirehoseInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String resourceArn;

            /**
             * Sets the value of ResourceArn
             * @param resourceArn `CfnApplicationV2.KinesisFirehoseInputProperty.ResourceARN`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisFirehoseInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public KinesisFirehoseInputProperty build() {
                return new Jsii$Proxy(resourceArn);
            }
        }

        /**
         * An implementation for {@link KinesisFirehoseInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisFirehoseInputProperty {
            private final java.lang.String resourceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.resourceArn = this.jsiiGet("resourceArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String resourceArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceArn = java.util.Objects.requireNonNull(resourceArn, "resourceArn is required");
            }

            @Override
            public java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("resourceArn", om.valueToTree(this.getResourceArn()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisFirehoseInputProperty.Jsii$Proxy that = (KinesisFirehoseInputProperty.Jsii$Proxy) o;

                return this.resourceArn.equals(that.resourceArn);
            }

            @Override
            public int hashCode() {
                int result = this.resourceArn.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-kinesisstreamsinput.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface KinesisStreamsInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.KinesisStreamsInputProperty.ResourceARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-kinesisstreamsinput.html#cfn-kinesisanalyticsv2-application-kinesisstreamsinput-resourcearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getResourceArn();

        /**
         * @return a {@link Builder} of {@link KinesisStreamsInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisStreamsInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String resourceArn;

            /**
             * Sets the value of ResourceArn
             * @param resourceArn `CfnApplicationV2.KinesisStreamsInputProperty.ResourceARN`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisStreamsInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public KinesisStreamsInputProperty build() {
                return new Jsii$Proxy(resourceArn);
            }
        }

        /**
         * An implementation for {@link KinesisStreamsInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisStreamsInputProperty {
            private final java.lang.String resourceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.resourceArn = this.jsiiGet("resourceArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String resourceArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceArn = java.util.Objects.requireNonNull(resourceArn, "resourceArn is required");
            }

            @Override
            public java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("resourceArn", om.valueToTree(this.getResourceArn()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisStreamsInputProperty.Jsii$Proxy that = (KinesisStreamsInputProperty.Jsii$Proxy) o;

                return this.resourceArn.equals(that.resourceArn);
            }

            @Override
            public int hashCode() {
                int result = this.resourceArn.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-mappingparameters.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface MappingParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.MappingParametersProperty.CSVMappingParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-mappingparameters.html#cfn-kinesisanalyticsv2-application-mappingparameters-csvmappingparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getCsvMappingParameters();

        /**
         * `CfnApplicationV2.MappingParametersProperty.JSONMappingParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-mappingparameters.html#cfn-kinesisanalyticsv2-application-mappingparameters-jsonmappingparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getJsonMappingParameters();

        /**
         * @return a {@link Builder} of {@link MappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object csvMappingParameters;
            private java.lang.Object jsonMappingParameters;

            /**
             * Sets the value of CsvMappingParameters
             * @param csvMappingParameters `CfnApplicationV2.MappingParametersProperty.CSVMappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder csvMappingParameters(software.amazon.awscdk.core.IResolvable csvMappingParameters) {
                this.csvMappingParameters = csvMappingParameters;
                return this;
            }

            /**
             * Sets the value of CsvMappingParameters
             * @param csvMappingParameters `CfnApplicationV2.MappingParametersProperty.CSVMappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder csvMappingParameters(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.CSVMappingParametersProperty csvMappingParameters) {
                this.csvMappingParameters = csvMappingParameters;
                return this;
            }

            /**
             * Sets the value of JsonMappingParameters
             * @param jsonMappingParameters `CfnApplicationV2.MappingParametersProperty.JSONMappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder jsonMappingParameters(software.amazon.awscdk.core.IResolvable jsonMappingParameters) {
                this.jsonMappingParameters = jsonMappingParameters;
                return this;
            }

            /**
             * Sets the value of JsonMappingParameters
             * @param jsonMappingParameters `CfnApplicationV2.MappingParametersProperty.JSONMappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder jsonMappingParameters(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.JSONMappingParametersProperty jsonMappingParameters) {
                this.jsonMappingParameters = jsonMappingParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public MappingParametersProperty build() {
                return new Jsii$Proxy(csvMappingParameters, jsonMappingParameters);
            }
        }

        /**
         * An implementation for {@link MappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MappingParametersProperty {
            private final java.lang.Object csvMappingParameters;
            private final java.lang.Object jsonMappingParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.csvMappingParameters = this.jsiiGet("csvMappingParameters", java.lang.Object.class);
                this.jsonMappingParameters = this.jsiiGet("jsonMappingParameters", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object csvMappingParameters, java.lang.Object jsonMappingParameters) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.csvMappingParameters = csvMappingParameters;
                this.jsonMappingParameters = jsonMappingParameters;
            }

            @Override
            public java.lang.Object getCsvMappingParameters() {
                return this.csvMappingParameters;
            }

            @Override
            public java.lang.Object getJsonMappingParameters() {
                return this.jsonMappingParameters;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getCsvMappingParameters() != null) {
                    obj.set("csvMappingParameters", om.valueToTree(this.getCsvMappingParameters()));
                }
                if (this.getJsonMappingParameters() != null) {
                    obj.set("jsonMappingParameters", om.valueToTree(this.getJsonMappingParameters()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MappingParametersProperty.Jsii$Proxy that = (MappingParametersProperty.Jsii$Proxy) o;

                if (this.csvMappingParameters != null ? !this.csvMappingParameters.equals(that.csvMappingParameters) : that.csvMappingParameters != null) return false;
                return this.jsonMappingParameters != null ? this.jsonMappingParameters.equals(that.jsonMappingParameters) : that.jsonMappingParameters == null;
            }

            @Override
            public int hashCode() {
                int result = this.csvMappingParameters != null ? this.csvMappingParameters.hashCode() : 0;
                result = 31 * result + (this.jsonMappingParameters != null ? this.jsonMappingParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-monitoringconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface MonitoringConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.MonitoringConfigurationProperty.ConfigurationType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-monitoringconfiguration.html#cfn-kinesisanalyticsv2-application-monitoringconfiguration-configurationtype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getConfigurationType();

        /**
         * `CfnApplicationV2.MonitoringConfigurationProperty.LogLevel`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-monitoringconfiguration.html#cfn-kinesisanalyticsv2-application-monitoringconfiguration-loglevel
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getLogLevel();

        /**
         * `CfnApplicationV2.MonitoringConfigurationProperty.MetricsLevel`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-monitoringconfiguration.html#cfn-kinesisanalyticsv2-application-monitoringconfiguration-metricslevel
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getMetricsLevel();

        /**
         * @return a {@link Builder} of {@link MonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String configurationType;
            private java.lang.String logLevel;
            private java.lang.String metricsLevel;

            /**
             * Sets the value of ConfigurationType
             * @param configurationType `CfnApplicationV2.MonitoringConfigurationProperty.ConfigurationType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder configurationType(java.lang.String configurationType) {
                this.configurationType = configurationType;
                return this;
            }

            /**
             * Sets the value of LogLevel
             * @param logLevel `CfnApplicationV2.MonitoringConfigurationProperty.LogLevel`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder logLevel(java.lang.String logLevel) {
                this.logLevel = logLevel;
                return this;
            }

            /**
             * Sets the value of MetricsLevel
             * @param metricsLevel `CfnApplicationV2.MonitoringConfigurationProperty.MetricsLevel`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder metricsLevel(java.lang.String metricsLevel) {
                this.metricsLevel = metricsLevel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public MonitoringConfigurationProperty build() {
                return new Jsii$Proxy(configurationType, logLevel, metricsLevel);
            }
        }

        /**
         * An implementation for {@link MonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringConfigurationProperty {
            private final java.lang.String configurationType;
            private final java.lang.String logLevel;
            private final java.lang.String metricsLevel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.configurationType = this.jsiiGet("configurationType", java.lang.String.class);
                this.logLevel = this.jsiiGet("logLevel", java.lang.String.class);
                this.metricsLevel = this.jsiiGet("metricsLevel", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String configurationType, java.lang.String logLevel, java.lang.String metricsLevel) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configurationType = java.util.Objects.requireNonNull(configurationType, "configurationType is required");
                this.logLevel = logLevel;
                this.metricsLevel = metricsLevel;
            }

            @Override
            public java.lang.String getConfigurationType() {
                return this.configurationType;
            }

            @Override
            public java.lang.String getLogLevel() {
                return this.logLevel;
            }

            @Override
            public java.lang.String getMetricsLevel() {
                return this.metricsLevel;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("configurationType", om.valueToTree(this.getConfigurationType()));
                if (this.getLogLevel() != null) {
                    obj.set("logLevel", om.valueToTree(this.getLogLevel()));
                }
                if (this.getMetricsLevel() != null) {
                    obj.set("metricsLevel", om.valueToTree(this.getMetricsLevel()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringConfigurationProperty.Jsii$Proxy that = (MonitoringConfigurationProperty.Jsii$Proxy) o;

                if (!configurationType.equals(that.configurationType)) return false;
                if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) return false;
                return this.metricsLevel != null ? this.metricsLevel.equals(that.metricsLevel) : that.metricsLevel == null;
            }

            @Override
            public int hashCode() {
                int result = this.configurationType.hashCode();
                result = 31 * result + (this.logLevel != null ? this.logLevel.hashCode() : 0);
                result = 31 * result + (this.metricsLevel != null ? this.metricsLevel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-parallelismconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ParallelismConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.ParallelismConfigurationProperty.ConfigurationType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-parallelismconfiguration.html#cfn-kinesisanalyticsv2-application-parallelismconfiguration-configurationtype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getConfigurationType();

        /**
         * `CfnApplicationV2.ParallelismConfigurationProperty.AutoScalingEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-parallelismconfiguration.html#cfn-kinesisanalyticsv2-application-parallelismconfiguration-autoscalingenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getAutoScalingEnabled();

        /**
         * `CfnApplicationV2.ParallelismConfigurationProperty.Parallelism`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-parallelismconfiguration.html#cfn-kinesisanalyticsv2-application-parallelismconfiguration-parallelism
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getParallelism();

        /**
         * `CfnApplicationV2.ParallelismConfigurationProperty.ParallelismPerKPU`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-parallelismconfiguration.html#cfn-kinesisanalyticsv2-application-parallelismconfiguration-parallelismperkpu
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getParallelismPerKpu();

        /**
         * @return a {@link Builder} of {@link ParallelismConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParallelismConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String configurationType;
            private java.lang.Object autoScalingEnabled;
            private java.lang.Number parallelism;
            private java.lang.Number parallelismPerKpu;

            /**
             * Sets the value of ConfigurationType
             * @param configurationType `CfnApplicationV2.ParallelismConfigurationProperty.ConfigurationType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder configurationType(java.lang.String configurationType) {
                this.configurationType = configurationType;
                return this;
            }

            /**
             * Sets the value of AutoScalingEnabled
             * @param autoScalingEnabled `CfnApplicationV2.ParallelismConfigurationProperty.AutoScalingEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder autoScalingEnabled(java.lang.Boolean autoScalingEnabled) {
                this.autoScalingEnabled = autoScalingEnabled;
                return this;
            }

            /**
             * Sets the value of AutoScalingEnabled
             * @param autoScalingEnabled `CfnApplicationV2.ParallelismConfigurationProperty.AutoScalingEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder autoScalingEnabled(software.amazon.awscdk.core.IResolvable autoScalingEnabled) {
                this.autoScalingEnabled = autoScalingEnabled;
                return this;
            }

            /**
             * Sets the value of Parallelism
             * @param parallelism `CfnApplicationV2.ParallelismConfigurationProperty.Parallelism`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder parallelism(java.lang.Number parallelism) {
                this.parallelism = parallelism;
                return this;
            }

            /**
             * Sets the value of ParallelismPerKpu
             * @param parallelismPerKpu `CfnApplicationV2.ParallelismConfigurationProperty.ParallelismPerKPU`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder parallelismPerKpu(java.lang.Number parallelismPerKpu) {
                this.parallelismPerKpu = parallelismPerKpu;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParallelismConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ParallelismConfigurationProperty build() {
                return new Jsii$Proxy(configurationType, autoScalingEnabled, parallelism, parallelismPerKpu);
            }
        }

        /**
         * An implementation for {@link ParallelismConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParallelismConfigurationProperty {
            private final java.lang.String configurationType;
            private final java.lang.Object autoScalingEnabled;
            private final java.lang.Number parallelism;
            private final java.lang.Number parallelismPerKpu;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.configurationType = this.jsiiGet("configurationType", java.lang.String.class);
                this.autoScalingEnabled = this.jsiiGet("autoScalingEnabled", java.lang.Object.class);
                this.parallelism = this.jsiiGet("parallelism", java.lang.Number.class);
                this.parallelismPerKpu = this.jsiiGet("parallelismPerKpu", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String configurationType, java.lang.Object autoScalingEnabled, java.lang.Number parallelism, java.lang.Number parallelismPerKpu) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configurationType = java.util.Objects.requireNonNull(configurationType, "configurationType is required");
                this.autoScalingEnabled = autoScalingEnabled;
                this.parallelism = parallelism;
                this.parallelismPerKpu = parallelismPerKpu;
            }

            @Override
            public java.lang.String getConfigurationType() {
                return this.configurationType;
            }

            @Override
            public java.lang.Object getAutoScalingEnabled() {
                return this.autoScalingEnabled;
            }

            @Override
            public java.lang.Number getParallelism() {
                return this.parallelism;
            }

            @Override
            public java.lang.Number getParallelismPerKpu() {
                return this.parallelismPerKpu;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("configurationType", om.valueToTree(this.getConfigurationType()));
                if (this.getAutoScalingEnabled() != null) {
                    obj.set("autoScalingEnabled", om.valueToTree(this.getAutoScalingEnabled()));
                }
                if (this.getParallelism() != null) {
                    obj.set("parallelism", om.valueToTree(this.getParallelism()));
                }
                if (this.getParallelismPerKpu() != null) {
                    obj.set("parallelismPerKpu", om.valueToTree(this.getParallelismPerKpu()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParallelismConfigurationProperty.Jsii$Proxy that = (ParallelismConfigurationProperty.Jsii$Proxy) o;

                if (!configurationType.equals(that.configurationType)) return false;
                if (this.autoScalingEnabled != null ? !this.autoScalingEnabled.equals(that.autoScalingEnabled) : that.autoScalingEnabled != null) return false;
                if (this.parallelism != null ? !this.parallelism.equals(that.parallelism) : that.parallelism != null) return false;
                return this.parallelismPerKpu != null ? this.parallelismPerKpu.equals(that.parallelismPerKpu) : that.parallelismPerKpu == null;
            }

            @Override
            public int hashCode() {
                int result = this.configurationType.hashCode();
                result = 31 * result + (this.autoScalingEnabled != null ? this.autoScalingEnabled.hashCode() : 0);
                result = 31 * result + (this.parallelism != null ? this.parallelism.hashCode() : 0);
                result = 31 * result + (this.parallelismPerKpu != null ? this.parallelismPerKpu.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-propertygroup.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface PropertyGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.PropertyGroupProperty.PropertyGroupId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-propertygroup.html#cfn-kinesisanalyticsv2-application-propertygroup-propertygroupid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPropertyGroupId();

        /**
         * `CfnApplicationV2.PropertyGroupProperty.PropertyMap`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-propertygroup.html#cfn-kinesisanalyticsv2-application-propertygroup-propertymap
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getPropertyMap();

        /**
         * @return a {@link Builder} of {@link PropertyGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PropertyGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String propertyGroupId;
            private java.lang.Object propertyMap;

            /**
             * Sets the value of PropertyGroupId
             * @param propertyGroupId `CfnApplicationV2.PropertyGroupProperty.PropertyGroupId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder propertyGroupId(java.lang.String propertyGroupId) {
                this.propertyGroupId = propertyGroupId;
                return this;
            }

            /**
             * Sets the value of PropertyMap
             * @param propertyMap `CfnApplicationV2.PropertyGroupProperty.PropertyMap`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder propertyMap(java.lang.Object propertyMap) {
                this.propertyMap = propertyMap;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PropertyGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public PropertyGroupProperty build() {
                return new Jsii$Proxy(propertyGroupId, propertyMap);
            }
        }

        /**
         * An implementation for {@link PropertyGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PropertyGroupProperty {
            private final java.lang.String propertyGroupId;
            private final java.lang.Object propertyMap;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.propertyGroupId = this.jsiiGet("propertyGroupId", java.lang.String.class);
                this.propertyMap = this.jsiiGet("propertyMap", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String propertyGroupId, java.lang.Object propertyMap) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.propertyGroupId = propertyGroupId;
                this.propertyMap = propertyMap;
            }

            @Override
            public java.lang.String getPropertyGroupId() {
                return this.propertyGroupId;
            }

            @Override
            public java.lang.Object getPropertyMap() {
                return this.propertyMap;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getPropertyGroupId() != null) {
                    obj.set("propertyGroupId", om.valueToTree(this.getPropertyGroupId()));
                }
                if (this.getPropertyMap() != null) {
                    obj.set("propertyMap", om.valueToTree(this.getPropertyMap()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PropertyGroupProperty.Jsii$Proxy that = (PropertyGroupProperty.Jsii$Proxy) o;

                if (this.propertyGroupId != null ? !this.propertyGroupId.equals(that.propertyGroupId) : that.propertyGroupId != null) return false;
                return this.propertyMap != null ? this.propertyMap.equals(that.propertyMap) : that.propertyMap == null;
            }

            @Override
            public int hashCode() {
                int result = this.propertyGroupId != null ? this.propertyGroupId.hashCode() : 0;
                result = 31 * result + (this.propertyMap != null ? this.propertyMap.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordcolumn.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface RecordColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.RecordColumnProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordcolumn.html#cfn-kinesisanalyticsv2-application-recordcolumn-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getName();

        /**
         * `CfnApplicationV2.RecordColumnProperty.SqlType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordcolumn.html#cfn-kinesisanalyticsv2-application-recordcolumn-sqltype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSqlType();

        /**
         * `CfnApplicationV2.RecordColumnProperty.Mapping`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordcolumn.html#cfn-kinesisanalyticsv2-application-recordcolumn-mapping
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getMapping();

        /**
         * @return a {@link Builder} of {@link RecordColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecordColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String name;
            private java.lang.String sqlType;
            private java.lang.String mapping;

            /**
             * Sets the value of Name
             * @param name `CfnApplicationV2.RecordColumnProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of SqlType
             * @param sqlType `CfnApplicationV2.RecordColumnProperty.SqlType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sqlType(java.lang.String sqlType) {
                this.sqlType = sqlType;
                return this;
            }

            /**
             * Sets the value of Mapping
             * @param mapping `CfnApplicationV2.RecordColumnProperty.Mapping`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder mapping(java.lang.String mapping) {
                this.mapping = mapping;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public RecordColumnProperty build() {
                return new Jsii$Proxy(name, sqlType, mapping);
            }
        }

        /**
         * An implementation for {@link RecordColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecordColumnProperty {
            private final java.lang.String name;
            private final java.lang.String sqlType;
            private final java.lang.String mapping;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.sqlType = this.jsiiGet("sqlType", java.lang.String.class);
                this.mapping = this.jsiiGet("mapping", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String name, java.lang.String sqlType, java.lang.String mapping) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.sqlType = java.util.Objects.requireNonNull(sqlType, "sqlType is required");
                this.mapping = mapping;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.String getSqlType() {
                return this.sqlType;
            }

            @Override
            public java.lang.String getMapping() {
                return this.mapping;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("name", om.valueToTree(this.getName()));
                obj.set("sqlType", om.valueToTree(this.getSqlType()));
                if (this.getMapping() != null) {
                    obj.set("mapping", om.valueToTree(this.getMapping()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecordColumnProperty.Jsii$Proxy that = (RecordColumnProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!sqlType.equals(that.sqlType)) return false;
                return this.mapping != null ? this.mapping.equals(that.mapping) : that.mapping == null;
            }

            @Override
            public int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.sqlType.hashCode());
                result = 31 * result + (this.mapping != null ? this.mapping.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordformat.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface RecordFormatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.RecordFormatProperty.RecordFormatType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordformat.html#cfn-kinesisanalyticsv2-application-recordformat-recordformattype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getRecordFormatType();

        /**
         * `CfnApplicationV2.RecordFormatProperty.MappingParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordformat.html#cfn-kinesisanalyticsv2-application-recordformat-mappingparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getMappingParameters();

        /**
         * @return a {@link Builder} of {@link RecordFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecordFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String recordFormatType;
            private java.lang.Object mappingParameters;

            /**
             * Sets the value of RecordFormatType
             * @param recordFormatType `CfnApplicationV2.RecordFormatProperty.RecordFormatType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder recordFormatType(java.lang.String recordFormatType) {
                this.recordFormatType = recordFormatType;
                return this;
            }

            /**
             * Sets the value of MappingParameters
             * @param mappingParameters `CfnApplicationV2.RecordFormatProperty.MappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder mappingParameters(software.amazon.awscdk.core.IResolvable mappingParameters) {
                this.mappingParameters = mappingParameters;
                return this;
            }

            /**
             * Sets the value of MappingParameters
             * @param mappingParameters `CfnApplicationV2.RecordFormatProperty.MappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder mappingParameters(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.MappingParametersProperty mappingParameters) {
                this.mappingParameters = mappingParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordFormatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public RecordFormatProperty build() {
                return new Jsii$Proxy(recordFormatType, mappingParameters);
            }
        }

        /**
         * An implementation for {@link RecordFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecordFormatProperty {
            private final java.lang.String recordFormatType;
            private final java.lang.Object mappingParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.recordFormatType = this.jsiiGet("recordFormatType", java.lang.String.class);
                this.mappingParameters = this.jsiiGet("mappingParameters", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String recordFormatType, java.lang.Object mappingParameters) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordFormatType = java.util.Objects.requireNonNull(recordFormatType, "recordFormatType is required");
                this.mappingParameters = mappingParameters;
            }

            @Override
            public java.lang.String getRecordFormatType() {
                return this.recordFormatType;
            }

            @Override
            public java.lang.Object getMappingParameters() {
                return this.mappingParameters;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("recordFormatType", om.valueToTree(this.getRecordFormatType()));
                if (this.getMappingParameters() != null) {
                    obj.set("mappingParameters", om.valueToTree(this.getMappingParameters()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecordFormatProperty.Jsii$Proxy that = (RecordFormatProperty.Jsii$Proxy) o;

                if (!recordFormatType.equals(that.recordFormatType)) return false;
                return this.mappingParameters != null ? this.mappingParameters.equals(that.mappingParameters) : that.mappingParameters == null;
            }

            @Override
            public int hashCode() {
                int result = this.recordFormatType.hashCode();
                result = 31 * result + (this.mappingParameters != null ? this.mappingParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-s3contentlocation.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface S3ContentLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.S3ContentLocationProperty.BucketARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-s3contentlocation.html#cfn-kinesisanalyticsv2-application-s3contentlocation-bucketarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getBucketArn();

        /**
         * `CfnApplicationV2.S3ContentLocationProperty.FileKey`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-s3contentlocation.html#cfn-kinesisanalyticsv2-application-s3contentlocation-filekey
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getFileKey();

        /**
         * `CfnApplicationV2.S3ContentLocationProperty.ObjectVersion`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-s3contentlocation.html#cfn-kinesisanalyticsv2-application-s3contentlocation-objectversion
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getObjectVersion();

        /**
         * @return a {@link Builder} of {@link S3ContentLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3ContentLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String bucketArn;
            private java.lang.String fileKey;
            private java.lang.String objectVersion;

            /**
             * Sets the value of BucketArn
             * @param bucketArn `CfnApplicationV2.S3ContentLocationProperty.BucketARN`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder bucketArn(java.lang.String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            /**
             * Sets the value of FileKey
             * @param fileKey `CfnApplicationV2.S3ContentLocationProperty.FileKey`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder fileKey(java.lang.String fileKey) {
                this.fileKey = fileKey;
                return this;
            }

            /**
             * Sets the value of ObjectVersion
             * @param objectVersion `CfnApplicationV2.S3ContentLocationProperty.ObjectVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder objectVersion(java.lang.String objectVersion) {
                this.objectVersion = objectVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ContentLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public S3ContentLocationProperty build() {
                return new Jsii$Proxy(bucketArn, fileKey, objectVersion);
            }
        }

        /**
         * An implementation for {@link S3ContentLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ContentLocationProperty {
            private final java.lang.String bucketArn;
            private final java.lang.String fileKey;
            private final java.lang.String objectVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.bucketArn = this.jsiiGet("bucketArn", java.lang.String.class);
                this.fileKey = this.jsiiGet("fileKey", java.lang.String.class);
                this.objectVersion = this.jsiiGet("objectVersion", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String bucketArn, java.lang.String fileKey, java.lang.String objectVersion) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketArn = bucketArn;
                this.fileKey = fileKey;
                this.objectVersion = objectVersion;
            }

            @Override
            public java.lang.String getBucketArn() {
                return this.bucketArn;
            }

            @Override
            public java.lang.String getFileKey() {
                return this.fileKey;
            }

            @Override
            public java.lang.String getObjectVersion() {
                return this.objectVersion;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getBucketArn() != null) {
                    obj.set("bucketArn", om.valueToTree(this.getBucketArn()));
                }
                if (this.getFileKey() != null) {
                    obj.set("fileKey", om.valueToTree(this.getFileKey()));
                }
                if (this.getObjectVersion() != null) {
                    obj.set("objectVersion", om.valueToTree(this.getObjectVersion()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3ContentLocationProperty.Jsii$Proxy that = (S3ContentLocationProperty.Jsii$Proxy) o;

                if (this.bucketArn != null ? !this.bucketArn.equals(that.bucketArn) : that.bucketArn != null) return false;
                if (this.fileKey != null ? !this.fileKey.equals(that.fileKey) : that.fileKey != null) return false;
                return this.objectVersion != null ? this.objectVersion.equals(that.objectVersion) : that.objectVersion == null;
            }

            @Override
            public int hashCode() {
                int result = this.bucketArn != null ? this.bucketArn.hashCode() : 0;
                result = 31 * result + (this.fileKey != null ? this.fileKey.hashCode() : 0);
                result = 31 * result + (this.objectVersion != null ? this.objectVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-sqlapplicationconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SqlApplicationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationV2.SqlApplicationConfigurationProperty.Inputs`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-sqlapplicationconfiguration.html#cfn-kinesisanalyticsv2-application-sqlapplicationconfiguration-inputs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getInputs();

        /**
         * @return a {@link Builder} of {@link SqlApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SqlApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object inputs;

            /**
             * Sets the value of Inputs
             * @param inputs `CfnApplicationV2.SqlApplicationConfigurationProperty.Inputs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder inputs(software.amazon.awscdk.core.IResolvable inputs) {
                this.inputs = inputs;
                return this;
            }

            /**
             * Sets the value of Inputs
             * @param inputs `CfnApplicationV2.SqlApplicationConfigurationProperty.Inputs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder inputs(java.util.List<java.lang.Object> inputs) {
                this.inputs = inputs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SqlApplicationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SqlApplicationConfigurationProperty build() {
                return new Jsii$Proxy(inputs);
            }
        }

        /**
         * An implementation for {@link SqlApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SqlApplicationConfigurationProperty {
            private final java.lang.Object inputs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.inputs = this.jsiiGet("inputs", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object inputs) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputs = inputs;
            }

            @Override
            public java.lang.Object getInputs() {
                return this.inputs;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getInputs() != null) {
                    obj.set("inputs", om.valueToTree(this.getInputs()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SqlApplicationConfigurationProperty.Jsii$Proxy that = (SqlApplicationConfigurationProperty.Jsii$Proxy) o;

                return this.inputs != null ? this.inputs.equals(that.inputs) : that.inputs == null;
            }

            @Override
            public int hashCode() {
                int result = this.inputs != null ? this.inputs.hashCode() : 0;
                return result;
            }
        }
    }
}
