package software.amazon.awscdk.services.kinesisanalytics;

/**
 * Properties for defining a `AWS::KinesisAnalyticsV2::Application`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-10-01T14:36:43.796Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnApplicationV2Props extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::KinesisAnalyticsV2::Application.RuntimeEnvironment`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-runtimeenvironment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getRuntimeEnvironment();

    /**
     * `AWS::KinesisAnalyticsV2::Application.ServiceExecutionRole`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-serviceexecutionrole
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getServiceExecutionRole();

    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getApplicationConfiguration();

    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationDescription`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationdescription
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getApplicationDescription();

    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getApplicationName();

    /**
     * @return a {@link Builder} of {@link CfnApplicationV2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApplicationV2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String runtimeEnvironment;
        private java.lang.String serviceExecutionRole;
        private java.lang.Object applicationConfiguration;
        private java.lang.String applicationDescription;
        private java.lang.String applicationName;

        /**
         * Sets the value of RuntimeEnvironment
         * @param runtimeEnvironment `AWS::KinesisAnalyticsV2::Application.RuntimeEnvironment`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder runtimeEnvironment(java.lang.String runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
            return this;
        }

        /**
         * Sets the value of ServiceExecutionRole
         * @param serviceExecutionRole `AWS::KinesisAnalyticsV2::Application.ServiceExecutionRole`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder serviceExecutionRole(java.lang.String serviceExecutionRole) {
            this.serviceExecutionRole = serviceExecutionRole;
            return this;
        }

        /**
         * Sets the value of ApplicationConfiguration
         * @param applicationConfiguration `AWS::KinesisAnalyticsV2::Application.ApplicationConfiguration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder applicationConfiguration(software.amazon.awscdk.core.IResolvable applicationConfiguration) {
            this.applicationConfiguration = applicationConfiguration;
            return this;
        }

        /**
         * Sets the value of ApplicationConfiguration
         * @param applicationConfiguration `AWS::KinesisAnalyticsV2::Application.ApplicationConfiguration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder applicationConfiguration(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ApplicationConfigurationProperty applicationConfiguration) {
            this.applicationConfiguration = applicationConfiguration;
            return this;
        }

        /**
         * Sets the value of ApplicationDescription
         * @param applicationDescription `AWS::KinesisAnalyticsV2::Application.ApplicationDescription`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder applicationDescription(java.lang.String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        /**
         * Sets the value of ApplicationName
         * @param applicationName `AWS::KinesisAnalyticsV2::Application.ApplicationName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder applicationName(java.lang.String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationV2Props}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnApplicationV2Props build() {
            return new Jsii$Proxy(runtimeEnvironment, serviceExecutionRole, applicationConfiguration, applicationDescription, applicationName);
        }
    }

    /**
     * An implementation for {@link CfnApplicationV2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApplicationV2Props {
        private final java.lang.String runtimeEnvironment;
        private final java.lang.String serviceExecutionRole;
        private final java.lang.Object applicationConfiguration;
        private final java.lang.String applicationDescription;
        private final java.lang.String applicationName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.runtimeEnvironment = this.jsiiGet("runtimeEnvironment", java.lang.String.class);
            this.serviceExecutionRole = this.jsiiGet("serviceExecutionRole", java.lang.String.class);
            this.applicationConfiguration = this.jsiiGet("applicationConfiguration", java.lang.Object.class);
            this.applicationDescription = this.jsiiGet("applicationDescription", java.lang.String.class);
            this.applicationName = this.jsiiGet("applicationName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String runtimeEnvironment, java.lang.String serviceExecutionRole, java.lang.Object applicationConfiguration, java.lang.String applicationDescription, java.lang.String applicationName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.runtimeEnvironment = java.util.Objects.requireNonNull(runtimeEnvironment, "runtimeEnvironment is required");
            this.serviceExecutionRole = java.util.Objects.requireNonNull(serviceExecutionRole, "serviceExecutionRole is required");
            this.applicationConfiguration = applicationConfiguration;
            this.applicationDescription = applicationDescription;
            this.applicationName = applicationName;
        }

        @Override
        public java.lang.String getRuntimeEnvironment() {
            return this.runtimeEnvironment;
        }

        @Override
        public java.lang.String getServiceExecutionRole() {
            return this.serviceExecutionRole;
        }

        @Override
        public java.lang.Object getApplicationConfiguration() {
            return this.applicationConfiguration;
        }

        @Override
        public java.lang.String getApplicationDescription() {
            return this.applicationDescription;
        }

        @Override
        public java.lang.String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("runtimeEnvironment", om.valueToTree(this.getRuntimeEnvironment()));
            obj.set("serviceExecutionRole", om.valueToTree(this.getServiceExecutionRole()));
            if (this.getApplicationConfiguration() != null) {
                obj.set("applicationConfiguration", om.valueToTree(this.getApplicationConfiguration()));
            }
            if (this.getApplicationDescription() != null) {
                obj.set("applicationDescription", om.valueToTree(this.getApplicationDescription()));
            }
            if (this.getApplicationName() != null) {
                obj.set("applicationName", om.valueToTree(this.getApplicationName()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApplicationV2Props.Jsii$Proxy that = (CfnApplicationV2Props.Jsii$Proxy) o;

            if (!runtimeEnvironment.equals(that.runtimeEnvironment)) return false;
            if (!serviceExecutionRole.equals(that.serviceExecutionRole)) return false;
            if (this.applicationConfiguration != null ? !this.applicationConfiguration.equals(that.applicationConfiguration) : that.applicationConfiguration != null) return false;
            if (this.applicationDescription != null ? !this.applicationDescription.equals(that.applicationDescription) : that.applicationDescription != null) return false;
            return this.applicationName != null ? this.applicationName.equals(that.applicationName) : that.applicationName == null;
        }

        @Override
        public int hashCode() {
            int result = this.runtimeEnvironment.hashCode();
            result = 31 * result + (this.serviceExecutionRole.hashCode());
            result = 31 * result + (this.applicationConfiguration != null ? this.applicationConfiguration.hashCode() : 0);
            result = 31 * result + (this.applicationDescription != null ? this.applicationDescription.hashCode() : 0);
            result = 31 * result + (this.applicationName != null ? this.applicationName.hashCode() : 0);
            return result;
        }
    }
}
