package software.amazon.awscdk.services.kinesisanalytics;

/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::ApplicationOutput`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationoutput.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-10-01T14:36:43.781Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesisanalytics.$Module.class, fqn = "@aws-cdk/aws-kinesisanalytics.CfnApplicationOutputV2")
public class CfnApplicationOutputV2 extends software.amazon.awscdk.core.CfnResource {

    protected CfnApplicationOutputV2(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplicationOutputV2(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutputV2.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::KinesisAnalyticsV2::ApplicationOutput`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnApplicationOutputV2(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutputV2Props props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::KinesisAnalyticsV2::ApplicationOutput.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationoutput.html#cfn-kinesisanalyticsv2-applicationoutput-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getApplicationName() {
        return this.jsiiGet("applicationName", java.lang.String.class);
    }

    /**
     * `AWS::KinesisAnalyticsV2::ApplicationOutput.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationoutput.html#cfn-kinesisanalyticsv2-applicationoutput-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApplicationName(final java.lang.String value) {
        this.jsiiSet("applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
    }

    /**
     * `AWS::KinesisAnalyticsV2::ApplicationOutput.Output`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationoutput.html#cfn-kinesisanalyticsv2-applicationoutput-output
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getOutput() {
        return this.jsiiGet("output", java.lang.Object.class);
    }

    /**
     * `AWS::KinesisAnalyticsV2::ApplicationOutput.Output`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationoutput.html#cfn-kinesisanalyticsv2-applicationoutput-output
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setOutput(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("output", java.util.Objects.requireNonNull(value, "output is required"));
    }

    /**
     * `AWS::KinesisAnalyticsV2::ApplicationOutput.Output`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationoutput.html#cfn-kinesisanalyticsv2-applicationoutput-output
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setOutput(final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutputV2.OutputProperty value) {
        this.jsiiSet("output", java.util.Objects.requireNonNull(value, "output is required"));
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-destinationschema.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface DestinationSchemaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationOutputV2.DestinationSchemaProperty.RecordFormatType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-destinationschema.html#cfn-kinesisanalyticsv2-applicationoutput-destinationschema-recordformattype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getRecordFormatType();

        /**
         * @return a {@link Builder} of {@link DestinationSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String recordFormatType;

            /**
             * Sets the value of RecordFormatType
             * @param recordFormatType `CfnApplicationOutputV2.DestinationSchemaProperty.RecordFormatType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder recordFormatType(java.lang.String recordFormatType) {
                this.recordFormatType = recordFormatType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationSchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public DestinationSchemaProperty build() {
                return new Jsii$Proxy(recordFormatType);
            }
        }

        /**
         * An implementation for {@link DestinationSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationSchemaProperty {
            private final java.lang.String recordFormatType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.recordFormatType = this.jsiiGet("recordFormatType", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String recordFormatType) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordFormatType = recordFormatType;
            }

            @Override
            public java.lang.String getRecordFormatType() {
                return this.recordFormatType;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getRecordFormatType() != null) {
                    obj.set("recordFormatType", om.valueToTree(this.getRecordFormatType()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationSchemaProperty.Jsii$Proxy that = (DestinationSchemaProperty.Jsii$Proxy) o;

                return this.recordFormatType != null ? this.recordFormatType.equals(that.recordFormatType) : that.recordFormatType == null;
            }

            @Override
            public int hashCode() {
                int result = this.recordFormatType != null ? this.recordFormatType.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-kinesisfirehoseoutput.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface KinesisFirehoseOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationOutputV2.KinesisFirehoseOutputProperty.ResourceARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-kinesisfirehoseoutput.html#cfn-kinesisanalyticsv2-applicationoutput-kinesisfirehoseoutput-resourcearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getResourceArn();

        /**
         * @return a {@link Builder} of {@link KinesisFirehoseOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisFirehoseOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String resourceArn;

            /**
             * Sets the value of ResourceArn
             * @param resourceArn `CfnApplicationOutputV2.KinesisFirehoseOutputProperty.ResourceARN`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisFirehoseOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public KinesisFirehoseOutputProperty build() {
                return new Jsii$Proxy(resourceArn);
            }
        }

        /**
         * An implementation for {@link KinesisFirehoseOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisFirehoseOutputProperty {
            private final java.lang.String resourceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.resourceArn = this.jsiiGet("resourceArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String resourceArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceArn = java.util.Objects.requireNonNull(resourceArn, "resourceArn is required");
            }

            @Override
            public java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("resourceArn", om.valueToTree(this.getResourceArn()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisFirehoseOutputProperty.Jsii$Proxy that = (KinesisFirehoseOutputProperty.Jsii$Proxy) o;

                return this.resourceArn.equals(that.resourceArn);
            }

            @Override
            public int hashCode() {
                int result = this.resourceArn.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-kinesisstreamsoutput.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface KinesisStreamsOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationOutputV2.KinesisStreamsOutputProperty.ResourceARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-kinesisstreamsoutput.html#cfn-kinesisanalyticsv2-applicationoutput-kinesisstreamsoutput-resourcearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getResourceArn();

        /**
         * @return a {@link Builder} of {@link KinesisStreamsOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisStreamsOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String resourceArn;

            /**
             * Sets the value of ResourceArn
             * @param resourceArn `CfnApplicationOutputV2.KinesisStreamsOutputProperty.ResourceARN`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisStreamsOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public KinesisStreamsOutputProperty build() {
                return new Jsii$Proxy(resourceArn);
            }
        }

        /**
         * An implementation for {@link KinesisStreamsOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisStreamsOutputProperty {
            private final java.lang.String resourceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.resourceArn = this.jsiiGet("resourceArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String resourceArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceArn = java.util.Objects.requireNonNull(resourceArn, "resourceArn is required");
            }

            @Override
            public java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("resourceArn", om.valueToTree(this.getResourceArn()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisStreamsOutputProperty.Jsii$Proxy that = (KinesisStreamsOutputProperty.Jsii$Proxy) o;

                return this.resourceArn.equals(that.resourceArn);
            }

            @Override
            public int hashCode() {
                int result = this.resourceArn.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-lambdaoutput.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LambdaOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationOutputV2.LambdaOutputProperty.ResourceARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-lambdaoutput.html#cfn-kinesisanalyticsv2-applicationoutput-lambdaoutput-resourcearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getResourceArn();

        /**
         * @return a {@link Builder} of {@link LambdaOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String resourceArn;

            /**
             * Sets the value of ResourceArn
             * @param resourceArn `CfnApplicationOutputV2.LambdaOutputProperty.ResourceARN`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LambdaOutputProperty build() {
                return new Jsii$Proxy(resourceArn);
            }
        }

        /**
         * An implementation for {@link LambdaOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaOutputProperty {
            private final java.lang.String resourceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.resourceArn = this.jsiiGet("resourceArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String resourceArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceArn = java.util.Objects.requireNonNull(resourceArn, "resourceArn is required");
            }

            @Override
            public java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("resourceArn", om.valueToTree(this.getResourceArn()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaOutputProperty.Jsii$Proxy that = (LambdaOutputProperty.Jsii$Proxy) o;

                return this.resourceArn.equals(that.resourceArn);
            }

            @Override
            public int hashCode() {
                int result = this.resourceArn.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-output.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface OutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApplicationOutputV2.OutputProperty.DestinationSchema`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-output.html#cfn-kinesisanalyticsv2-applicationoutput-output-destinationschema
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDestinationSchema();

        /**
         * `CfnApplicationOutputV2.OutputProperty.KinesisFirehoseOutput`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-output.html#cfn-kinesisanalyticsv2-applicationoutput-output-kinesisfirehoseoutput
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getKinesisFirehoseOutput();

        /**
         * `CfnApplicationOutputV2.OutputProperty.KinesisStreamsOutput`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-output.html#cfn-kinesisanalyticsv2-applicationoutput-output-kinesisstreamsoutput
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getKinesisStreamsOutput();

        /**
         * `CfnApplicationOutputV2.OutputProperty.LambdaOutput`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-output.html#cfn-kinesisanalyticsv2-applicationoutput-output-lambdaoutput
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getLambdaOutput();

        /**
         * `CfnApplicationOutputV2.OutputProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationoutput-output.html#cfn-kinesisanalyticsv2-applicationoutput-output-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object destinationSchema;
            private java.lang.Object kinesisFirehoseOutput;
            private java.lang.Object kinesisStreamsOutput;
            private java.lang.Object lambdaOutput;
            private java.lang.String name;

            /**
             * Sets the value of DestinationSchema
             * @param destinationSchema `CfnApplicationOutputV2.OutputProperty.DestinationSchema`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder destinationSchema(software.amazon.awscdk.core.IResolvable destinationSchema) {
                this.destinationSchema = destinationSchema;
                return this;
            }

            /**
             * Sets the value of DestinationSchema
             * @param destinationSchema `CfnApplicationOutputV2.OutputProperty.DestinationSchema`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder destinationSchema(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutputV2.DestinationSchemaProperty destinationSchema) {
                this.destinationSchema = destinationSchema;
                return this;
            }

            /**
             * Sets the value of KinesisFirehoseOutput
             * @param kinesisFirehoseOutput `CfnApplicationOutputV2.OutputProperty.KinesisFirehoseOutput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kinesisFirehoseOutput(software.amazon.awscdk.core.IResolvable kinesisFirehoseOutput) {
                this.kinesisFirehoseOutput = kinesisFirehoseOutput;
                return this;
            }

            /**
             * Sets the value of KinesisFirehoseOutput
             * @param kinesisFirehoseOutput `CfnApplicationOutputV2.OutputProperty.KinesisFirehoseOutput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kinesisFirehoseOutput(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutputV2.KinesisFirehoseOutputProperty kinesisFirehoseOutput) {
                this.kinesisFirehoseOutput = kinesisFirehoseOutput;
                return this;
            }

            /**
             * Sets the value of KinesisStreamsOutput
             * @param kinesisStreamsOutput `CfnApplicationOutputV2.OutputProperty.KinesisStreamsOutput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kinesisStreamsOutput(software.amazon.awscdk.core.IResolvable kinesisStreamsOutput) {
                this.kinesisStreamsOutput = kinesisStreamsOutput;
                return this;
            }

            /**
             * Sets the value of KinesisStreamsOutput
             * @param kinesisStreamsOutput `CfnApplicationOutputV2.OutputProperty.KinesisStreamsOutput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder kinesisStreamsOutput(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutputV2.KinesisStreamsOutputProperty kinesisStreamsOutput) {
                this.kinesisStreamsOutput = kinesisStreamsOutput;
                return this;
            }

            /**
             * Sets the value of LambdaOutput
             * @param lambdaOutput `CfnApplicationOutputV2.OutputProperty.LambdaOutput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder lambdaOutput(software.amazon.awscdk.core.IResolvable lambdaOutput) {
                this.lambdaOutput = lambdaOutput;
                return this;
            }

            /**
             * Sets the value of LambdaOutput
             * @param lambdaOutput `CfnApplicationOutputV2.OutputProperty.LambdaOutput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder lambdaOutput(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationOutputV2.LambdaOutputProperty lambdaOutput) {
                this.lambdaOutput = lambdaOutput;
                return this;
            }

            /**
             * Sets the value of Name
             * @param name `CfnApplicationOutputV2.OutputProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public OutputProperty build() {
                return new Jsii$Proxy(destinationSchema, kinesisFirehoseOutput, kinesisStreamsOutput, lambdaOutput, name);
            }
        }

        /**
         * An implementation for {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputProperty {
            private final java.lang.Object destinationSchema;
            private final java.lang.Object kinesisFirehoseOutput;
            private final java.lang.Object kinesisStreamsOutput;
            private final java.lang.Object lambdaOutput;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.destinationSchema = this.jsiiGet("destinationSchema", java.lang.Object.class);
                this.kinesisFirehoseOutput = this.jsiiGet("kinesisFirehoseOutput", java.lang.Object.class);
                this.kinesisStreamsOutput = this.jsiiGet("kinesisStreamsOutput", java.lang.Object.class);
                this.lambdaOutput = this.jsiiGet("lambdaOutput", java.lang.Object.class);
                this.name = this.jsiiGet("name", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object destinationSchema, java.lang.Object kinesisFirehoseOutput, java.lang.Object kinesisStreamsOutput, java.lang.Object lambdaOutput, java.lang.String name) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationSchema = java.util.Objects.requireNonNull(destinationSchema, "destinationSchema is required");
                this.kinesisFirehoseOutput = kinesisFirehoseOutput;
                this.kinesisStreamsOutput = kinesisStreamsOutput;
                this.lambdaOutput = lambdaOutput;
                this.name = name;
            }

            @Override
            public java.lang.Object getDestinationSchema() {
                return this.destinationSchema;
            }

            @Override
            public java.lang.Object getKinesisFirehoseOutput() {
                return this.kinesisFirehoseOutput;
            }

            @Override
            public java.lang.Object getKinesisStreamsOutput() {
                return this.kinesisStreamsOutput;
            }

            @Override
            public java.lang.Object getLambdaOutput() {
                return this.lambdaOutput;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("destinationSchema", om.valueToTree(this.getDestinationSchema()));
                if (this.getKinesisFirehoseOutput() != null) {
                    obj.set("kinesisFirehoseOutput", om.valueToTree(this.getKinesisFirehoseOutput()));
                }
                if (this.getKinesisStreamsOutput() != null) {
                    obj.set("kinesisStreamsOutput", om.valueToTree(this.getKinesisStreamsOutput()));
                }
                if (this.getLambdaOutput() != null) {
                    obj.set("lambdaOutput", om.valueToTree(this.getLambdaOutput()));
                }
                if (this.getName() != null) {
                    obj.set("name", om.valueToTree(this.getName()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputProperty.Jsii$Proxy that = (OutputProperty.Jsii$Proxy) o;

                if (!destinationSchema.equals(that.destinationSchema)) return false;
                if (this.kinesisFirehoseOutput != null ? !this.kinesisFirehoseOutput.equals(that.kinesisFirehoseOutput) : that.kinesisFirehoseOutput != null) return false;
                if (this.kinesisStreamsOutput != null ? !this.kinesisStreamsOutput.equals(that.kinesisStreamsOutput) : that.kinesisStreamsOutput != null) return false;
                if (this.lambdaOutput != null ? !this.lambdaOutput.equals(that.lambdaOutput) : that.lambdaOutput != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public int hashCode() {
                int result = this.destinationSchema.hashCode();
                result = 31 * result + (this.kinesisFirehoseOutput != null ? this.kinesisFirehoseOutput.hashCode() : 0);
                result = 31 * result + (this.kinesisStreamsOutput != null ? this.kinesisStreamsOutput.hashCode() : 0);
                result = 31 * result + (this.lambdaOutput != null ? this.lambdaOutput.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
}
